/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.profiles;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.io.ToStringRenderer;
import org.semanticweb.owl.model.OWLAntiSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiomVisitorEx;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLConstant;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataComplementOf;
import org.semanticweb.owl.model.OWLDataExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataOneOf;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLDataPropertyExpression;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataRange;
import org.semanticweb.owl.model.OWLDataRangeFacetRestriction;
import org.semanticweb.owl.model.OWLDataRangeRestriction;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataSubPropertyAxiom;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDataVisitorEx;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitorEx;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityAnnotationAxiom;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owl.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owl.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owl.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLLogicalAxiom;
import org.semanticweb.owl.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectComplementOf;
import org.semanticweb.owl.model.OWLObjectExactCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectIntersectionOf;
import org.semanticweb.owl.model.OWLObjectMaxCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectMinCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyChainSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLObjectPropertyInverse;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSelfRestriction;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectSubPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectUnionOf;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyAnnotationAxiom;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owl.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLTypedConstant;
import org.semanticweb.owl.model.OWLUntypedConstant;
import org.semanticweb.owl.model.SWRLRule;
import org.semanticweb.owl.profiles.AxiomNotAllowed;
import org.semanticweb.owl.profiles.ConstructNotAllowed;
import org.semanticweb.owl.profiles.DataRangeNotAllowed;
import org.semanticweb.owl.profiles.DescriptionNotAllowed;
import org.semanticweb.owl.profiles.OWLProfile;
import org.semanticweb.owl.profiles.OWLProfileReport;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;
import uk.ac.manchester.cs.owl.dlsyntax.DLSyntaxObjectRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELPlusPlusProfile
implements OWLProfile {
    private Set<URI> allowedDataTypes = new HashSet<URI>();
    private OWLOntology ont;

    public ELPlusPlusProfile() {
        this.allowedDataTypes.add(OWLRDFVocabulary.RDF_XML_LITERAL.getURI());
        this.allowedDataTypes.add(OWLRDFVocabulary.RDFS_LITERAL.getURI());
        this.allowedDataTypes.add(XSDVocabulary.DECIMAL.getURI());
        this.allowedDataTypes.add(XSDVocabulary.INTEGER.getURI());
        this.allowedDataTypes.add(XSDVocabulary.NON_NEGATIVE_INTEGER.getURI());
        this.allowedDataTypes.add(XSDVocabulary.STRING.getURI());
        this.allowedDataTypes.add(XSDVocabulary.NORMALIZED_STRING.getURI());
        this.allowedDataTypes.add(XSDVocabulary.TOKEN.getURI());
        this.allowedDataTypes.add(XSDVocabulary.NAME.getURI());
        this.allowedDataTypes.add(XSDVocabulary.NCNAME.getURI());
        this.allowedDataTypes.add(XSDVocabulary.NMTOKEN.getURI());
        this.allowedDataTypes.add(XSDVocabulary.HEX_BINARY.getURI());
        this.allowedDataTypes.add(XSDVocabulary.BASE_64_BINARY.getURI());
        this.allowedDataTypes.add(XSDVocabulary.ANY_URI.getURI());
        this.allowedDataTypes.add(XSDVocabulary.DATE_TIME.getURI());
    }

    @Override
    public String getName() {
        return "EL++";
    }

    @Override
    public OWLProfileReport checkOntology(OWLOntology ontology, OWLOntologyManager manager) {
        this.ont = ontology;
        ELPlusPlusChecker checker = new ELPlusPlusChecker();
        HashSet<ConstructNotAllowed> disallowedConstructs = new HashSet<ConstructNotAllowed>();
        for (OWLLogicalAxiom ax : ontology.getLogicalAxioms()) {
            ConstructNotAllowed cause = ax.accept(checker);
            if (cause == null) continue;
            disallowedConstructs.add(cause);
        }
        return new OWLProfileReport(this, ontology.getURI(), disallowedConstructs);
    }

    private void performGlobalCheck() {
        HashMap<OWLObjectProperty, Set<OWLObjectProperty>> map = new HashMap<OWLObjectProperty, Set<OWLObjectProperty>>();
        HashSet<OWLObjectProperty> processed = new HashSet<OWLObjectProperty>();
        for (OWLObjectProperty prop : this.ont.getReferencedObjectProperties()) {
            this.processProp(prop, map, processed);
        }
    }

    private Set<OWLObjectProperty> processProp(OWLObjectProperty prop, Map<OWLObjectProperty, Set<OWLObjectProperty>> map, Set<OWLObjectProperty> processed) {
        Set<OWLObjectProperty> props = map.get(prop);
        if (props == null) {
            props = new HashSet<OWLObjectProperty>();
            map.put(prop, props);
        }
        if (processed.contains(prop)) {
            return props;
        }
        processed.add(prop);
        for (OWLObjectSubPropertyAxiom ax : this.ont.getObjectSubPropertyAxiomsForLHS(prop)) {
            if (((OWLObjectPropertyExpression)ax.getSuperProperty()).isAnonymous()) continue;
            props.add(((OWLObjectPropertyExpression)ax.getSuperProperty()).asOWLObjectProperty());
            props.addAll(this.processProp(((OWLObjectPropertyExpression)ax.getSuperProperty()).asOWLObjectProperty(), map, processed));
        }
        return props;
    }

    public static void main(String[] args) {
        try {
            ToStringRenderer.getInstance().setRenderer(new DLSyntaxObjectRenderer());
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            man.setSilentMissingImportsHandling(true);
            OWLOntology ont = man.loadOntology(URI.create("http://rpc295.cs.man.ac.uk:8080/ontologyrepository/download?ontology=http://sweet.jpl.nasa.gov/ontology/earthrealm.owl&version=0&format=RDF/XML"));
            ELPlusPlusProfile profile = new ELPlusPlusProfile();
            profile.checkOntology(ont, man);
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
    }

    private class NonSingletonNominalsNotAllowed
    extends DescriptionNotAllowed {
        public NonSingletonNominalsNotAllowed(OWLDescription construct) {
            super(construct);
        }

        public NonSingletonNominalsNotAllowed(ConstructNotAllowed cause, OWLDescription construct) {
            super(cause, construct);
        }

        public String toString() {
            return "Non-singleton enumerations not allowed: " + this.getCause();
        }
    }

    private class DataTypeNotAllowed
    extends DataRangeNotAllowed {
        public DataTypeNotAllowed(OWLDataRange construct) {
            super(construct);
        }

        public DataTypeNotAllowed(ConstructNotAllowed cause, OWLDataRange construct) {
            super(cause, construct);
        }

        public String toString() {
            return "DataType not allowed: " + this.getCause();
        }
    }

    private class InversePropertiesNotAllowed
    extends ConstructNotAllowed {
        public InversePropertiesNotAllowed(Object construct) {
            super(construct);
        }

        public InversePropertiesNotAllowed(ConstructNotAllowed cause, Object construct) {
            super(cause, construct);
        }

        public String toString() {
            return "Inverse properties not allowed";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ELPlusPlusChecker
    implements OWLDescriptionVisitorEx<ConstructNotAllowed>,
    OWLPropertyExpressionVisitorEx<ConstructNotAllowed>,
    OWLDataVisitorEx<ConstructNotAllowed>,
    OWLAxiomVisitorEx<ConstructNotAllowed> {
        private ELPlusPlusChecker() {
        }

        @Override
        public ConstructNotAllowed visit(OWLSubClassAxiom axiom) {
            ConstructNotAllowed cause = axiom.getSubClass().accept(this);
            if (cause != null) {
                return new AxiomNotAllowed<OWLSubClassAxiom>(cause, axiom);
            }
            cause = axiom.getSuperClass().accept(this);
            if (cause != null) {
                return new AxiomNotAllowed<OWLSubClassAxiom>(cause, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
            return new AxiomNotAllowed<OWLNegativeObjectPropertyAssertionAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLAntiSymmetricObjectPropertyAxiom axiom) {
            return new AxiomNotAllowed<OWLAntiSymmetricObjectPropertyAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLReflexiveObjectPropertyAxiom axiom) {
            return ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        @Override
        public ConstructNotAllowed visit(OWLDisjointClassesAxiom axiom) {
            for (OWLDescription desc : axiom.getDescriptions()) {
                ConstructNotAllowed cause = desc.accept(this);
                if (cause == null) continue;
                return new AxiomNotAllowed<OWLDisjointClassesAxiom>(cause, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataPropertyDomainAxiom axiom) {
            return axiom.getDomain().accept(this);
        }

        @Override
        public ConstructNotAllowed visit(OWLImportsDeclaration axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLAxiomAnnotationAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyDomainAxiom axiom) {
            ConstructNotAllowed cause = ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            if (cause != null) {
                return new AxiomNotAllowed<OWLObjectPropertyDomainAxiom>(cause, axiom);
            }
            cause = axiom.getDomain().accept(this);
            if (cause != null) {
                return new AxiomNotAllowed<OWLObjectPropertyDomainAxiom>(cause, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLEquivalentObjectPropertiesAxiom axiom) {
            for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
                ConstructNotAllowed cause = prop.accept(this);
                if (cause == null) continue;
                return new AxiomNotAllowed<OWLEquivalentObjectPropertiesAxiom>(cause, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return new AxiomNotAllowed<OWLNegativeDataPropertyAssertionAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLDifferentIndividualsAxiom axiom) {
            return new AxiomNotAllowed<OWLDifferentIndividualsAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLDisjointDataPropertiesAxiom axiom) {
            return new AxiomNotAllowed<OWLDisjointDataPropertiesAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLDisjointObjectPropertiesAxiom axiom) {
            return new AxiomNotAllowed<OWLDisjointObjectPropertiesAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyRangeAxiom axiom) {
            ConstructNotAllowed cause = ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
            if (cause != null) {
                return new AxiomNotAllowed<OWLObjectPropertyRangeAxiom>(cause, axiom);
            }
            cause = ((OWLDescription)axiom.getRange()).accept(this);
            if (cause != null) {
                return new AxiomNotAllowed<OWLObjectPropertyRangeAxiom>(cause, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyAssertionAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLFunctionalObjectPropertyAxiom axiom) {
            return new AxiomNotAllowed<OWLFunctionalObjectPropertyAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectSubPropertyAxiom axiom) {
            ConstructNotAllowed cause = ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
            if (cause != null) {
                return new AxiomNotAllowed<OWLObjectSubPropertyAxiom>(cause, axiom);
            }
            cause = ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
            if (cause != null) {
                return new AxiomNotAllowed<OWLObjectSubPropertyAxiom>(cause, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDisjointUnionAxiom axiom) {
            return new AxiomNotAllowed<OWLDisjointUnionAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLDeclarationAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLEntityAnnotationAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLOntologyAnnotationAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLSymmetricObjectPropertyAxiom axiom) {
            return new AxiomNotAllowed<OWLSymmetricObjectPropertyAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLDataPropertyRangeAxiom axiom) {
            return ((OWLDataRange)axiom.getRange()).accept(this);
        }

        @Override
        public ConstructNotAllowed visit(OWLFunctionalDataPropertyAxiom axiom) {
            return new AxiomNotAllowed<OWLFunctionalDataPropertyAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLEquivalentDataPropertiesAxiom axiom) {
            return new AxiomNotAllowed<OWLEquivalentDataPropertiesAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLClassAssertionAxiom axiom) {
            ConstructNotAllowed cause = axiom.getDescription().accept(this);
            if (cause != null) {
                return new AxiomNotAllowed<OWLClassAssertionAxiom>(cause, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLEquivalentClassesAxiom axiom) {
            for (OWLDescription desc : axiom.getDescriptions()) {
                ConstructNotAllowed cause = desc.accept(this);
                if (cause == null) continue;
                return new AxiomNotAllowed<OWLEquivalentClassesAxiom>(cause, axiom);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataPropertyAssertionAxiom axiom) {
            return ((OWLConstant)axiom.getObject()).accept(this);
        }

        @Override
        public ConstructNotAllowed visit(OWLTransitiveObjectPropertyAxiom axiom) {
            return ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        }

        @Override
        public ConstructNotAllowed visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
            return new AxiomNotAllowed<OWLIrreflexiveObjectPropertyAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLDataSubPropertyAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
            return new AxiomNotAllowed<OWLInverseFunctionalObjectPropertyAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLSameIndividualsAxiom axiom) {
            return new AxiomNotAllowed<OWLSameIndividualsAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyChainSubPropertyAxiom axiom) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLInverseObjectPropertiesAxiom axiom) {
            return new AxiomNotAllowed<OWLInverseObjectPropertiesAxiom>(axiom);
        }

        @Override
        public ConstructNotAllowed visit(SWRLRule rule) {
            return new AxiomNotAllowed<SWRLRule>(rule);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectProperty property) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectPropertyInverse property) {
            return new InversePropertiesNotAllowed(property);
        }

        @Override
        public ConstructNotAllowed visit(OWLDataProperty property) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataType node) {
            if (ELPlusPlusProfile.this.allowedDataTypes.contains(node.getURI())) {
                return null;
            }
            return new DataTypeNotAllowed((OWLDataRange)node);
        }

        @Override
        public ConstructNotAllowed visit(OWLDataComplementOf node) {
            return new DataRangeNotAllowed(node);
        }

        @Override
        public ConstructNotAllowed visit(OWLDataOneOf node) {
            if (node.getValues().size() != 1) {
                return new DataRangeNotAllowed(node);
            }
            ConstructNotAllowed cause = node.getValues().iterator().next().accept(this);
            if (cause != null) {
                return new DataRangeNotAllowed(cause, (OWLDataRange)node);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataRangeRestriction node) {
            return new DataRangeNotAllowed(node);
        }

        @Override
        public ConstructNotAllowed visit(OWLTypedConstant node) {
            return node.getDataType().accept(this);
        }

        @Override
        public ConstructNotAllowed visit(OWLUntypedConstant node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataRangeFacetRestriction node) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLClass desc) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectIntersectionOf desc) {
            for (OWLDescription op : desc.getOperands()) {
                ConstructNotAllowed obj = op.accept(this);
                if (obj == null) continue;
                return new DescriptionNotAllowed(obj, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectUnionOf desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectComplementOf desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectSomeRestriction desc) {
            ConstructNotAllowed cause = ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            if (cause != null) {
                return new DescriptionNotAllowed(cause, (OWLDescription)desc);
            }
            cause = ((OWLDescription)desc.getFiller()).accept(this);
            if (cause != null) {
                return new DescriptionNotAllowed(cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectAllRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectValueRestriction desc) {
            ConstructNotAllowed cause = ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            if (cause != null) {
                return new DescriptionNotAllowed(cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectMinCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectExactCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectMaxCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectSelfRestriction desc) {
            ConstructNotAllowed cause = ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
            if (cause != null) {
                return new DescriptionNotAllowed(cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLObjectOneOf desc) {
            if (desc.getIndividuals().size() != 1) {
                return new NonSingletonNominalsNotAllowed((OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataSomeRestriction desc) {
            ConstructNotAllowed cause = ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
            if (cause != null) {
                return new DescriptionNotAllowed(cause, (OWLDescription)desc);
            }
            cause = ((OWLDataRange)desc.getFiller()).accept(this);
            if (cause != null) {
                return new DescriptionNotAllowed(cause, (OWLDescription)desc);
            }
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataAllRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLDataValueRestriction desc) {
            return null;
        }

        @Override
        public ConstructNotAllowed visit(OWLDataMinCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLDataExactCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }

        @Override
        public ConstructNotAllowed visit(OWLDataMaxCardinalityRestriction desc) {
            return new DescriptionNotAllowed(desc);
        }
    }
}

