/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.model.OWLAnnotation;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAssertionAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLDescriptionVisitorEx;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLDisjointUnionAxiom;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLEntityVisitorEx;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLNamedObjectVisitor;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLRuntimeException;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.ImplUtils;
import uk.ac.manchester.cs.owl.OWLObjectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLClassImpl
extends OWLObjectImpl
implements OWLClass {
    private URI uri;
    private boolean isThing;
    private boolean isNothing;

    public OWLClassImpl(OWLDataFactory dataFactory, URI uri) {
        super(dataFactory);
        this.uri = uri;
        this.isThing = uri.equals(OWLRDFVocabulary.OWL_THING.getURI());
        this.isNothing = uri.equals(OWLRDFVocabulary.OWL_NOTHING.getURI());
    }

    @Override
    public boolean isBuiltIn() {
        return this.isOWLThing() || this.isOWLNothing();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    public OWLClass asOWLClass() {
        return this;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public boolean isOWLThing() {
        return this.isThing;
    }

    @Override
    public boolean isOWLNothing() {
        return this.isNothing;
    }

    @Override
    public OWLDescription getNNF() {
        return this;
    }

    @Override
    public Set<OWLDescription> asConjunctSet() {
        return Collections.singleton(this);
    }

    @Override
    public Set<OWLDescription> asDisjunctSet() {
        return Collections.singleton(this);
    }

    @Override
    public OWLDescription getComplementNNF() {
        return this.getOWLDataFactory().getOWLObjectComplementOf(this);
    }

    public Set<OWLSubClassAxiom> getSubClassAxioms(OWLOntology ontology) {
        return ontology.getSubClassAxiomsForLHS(this);
    }

    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLOntology ontology) {
        return ontology.getEquivalentClassesAxioms(this);
    }

    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLOntology ontology) {
        return ontology.getDisjointClassesAxioms(this);
    }

    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLOntology ontology) {
        return ontology.getDisjointUnionAxioms(this);
    }

    @Override
    public Set<OWLDescription> getSuperClasses(OWLOntology ontology) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLSubClassAxiom axiom : this.getSubClassAxioms(ontology)) {
            result.add(axiom.getSuperClass());
        }
        return result;
    }

    @Override
    public Set<OWLDescription> getSuperClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getSuperClasses(ont));
        }
        return result;
    }

    @Override
    public Set<OWLDescription> getSubClasses(OWLOntology ontology) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLSubClassAxiom axiom : ontology.getSubClassAxiomsForRHS(this)) {
            result.add(axiom.getSubClass());
        }
        return result;
    }

    @Override
    public Set<OWLDescription> getSubClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getSubClasses(ont));
        }
        return result;
    }

    @Override
    public Set<OWLDescription> getEquivalentClasses(OWLOntology ontology) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLEquivalentClassesAxiom axiom : this.getEquivalentClassesAxioms(ontology)) {
            result.addAll(axiom.getDescriptions());
        }
        result.remove(this);
        return result;
    }

    @Override
    public Set<OWLDescription> getEquivalentClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getEquivalentClasses(ont));
        }
        return result;
    }

    @Override
    public Set<OWLDescription> getDisjointClasses(OWLOntology ontology) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLDisjointClassesAxiom axiom : this.getDisjointClassesAxioms(ontology)) {
            result.addAll(axiom.getDescriptions());
        }
        result.remove(this);
        return result;
    }

    @Override
    public Set<OWLDescription> getDisjointClasses(Set<OWLOntology> ontologies) {
        TreeSet<OWLDescription> result = new TreeSet<OWLDescription>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getDisjointClasses(ont));
        }
        return result;
    }

    @Override
    public Set<OWLIndividual> getIndividuals(OWLOntology ontology) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLClassAssertionAxiom ax : ontology.getClassAssertionAxioms(this)) {
            result.add(ax.getIndividual());
        }
        return result;
    }

    @Override
    public Set<OWLIndividual> getIndividuals(Set<OWLOntology> ontologies) {
        TreeSet<OWLIndividual> result = new TreeSet<OWLIndividual>();
        for (OWLOntology ont : ontologies) {
            result.addAll(this.getIndividuals(ont));
        }
        return result;
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology) {
        return ImplUtils.getAnnotations(this, Collections.singleton(ontology));
    }

    @Override
    public Set<OWLAnnotationAxiom> getAnnotationAxioms(OWLOntology ontology) {
        return ImplUtils.getAnnotationAxioms(this, Collections.singleton(ontology));
    }

    @Override
    public Set<OWLAnnotation> getAnnotations(OWLOntology ontology, URI annotationURI) {
        return ImplUtils.getAnnotations(this, annotationURI, Collections.singleton(ontology));
    }

    @Override
    public boolean isDefined(OWLOntology ontology) {
        return !ontology.getEquivalentClassesAxioms(this).isEmpty();
    }

    @Override
    public boolean isDefined(Set<OWLOntology> ontologies) {
        for (OWLOntology ont : ontologies) {
            if (!this.isDefined(ont)) continue;
            return true;
        }
        return false;
    }

    @Override
    public OWLDataProperty asOWLDataProperty() {
        throw new OWLRuntimeException("Not a data property!");
    }

    @Override
    public OWLDataType asOWLDataType() {
        throw new OWLRuntimeException("Not a data type!");
    }

    @Override
    public OWLIndividual asOWLIndividual() {
        throw new OWLRuntimeException("Not an individual!");
    }

    @Override
    public OWLObjectProperty asOWLObjectProperty() {
        throw new OWLRuntimeException("Not an object property");
    }

    @Override
    public boolean isOWLClass() {
        return true;
    }

    @Override
    public boolean isOWLDataProperty() {
        return false;
    }

    @Override
    public boolean isOWLDataType() {
        return false;
    }

    @Override
    public boolean isOWLIndividual() {
        return false;
    }

    @Override
    public boolean isOWLObjectProperty() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLClass)) {
                return false;
            }
            URI otherURI = ((OWLClass)obj).getURI();
            String otherFragment = otherURI.getFragment();
            String thisFragment = this.uri.getFragment();
            if (otherFragment != null && thisFragment != null && !otherFragment.equals(thisFragment)) {
                return false;
            }
            return otherURI.equals(this.uri);
        }
        return false;
    }

    @Override
    public void accept(OWLDescriptionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLEntityVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLNamedObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLEntityVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDescriptionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLClass other = (OWLClass)object;
        return this.getURI().compareTo(other.getURI());
    }
}

