/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDescriptionVisitor;
import org.semanticweb.owl.model.OWLDescriptionVisitorEx;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectOneOf;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import uk.ac.manchester.cs.owl.OWLAnonymousDescriptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLObjectOneOfImpl
extends OWLAnonymousDescriptionImpl
implements OWLObjectOneOf {
    private Set<OWLIndividual> values;

    public OWLObjectOneOfImpl(OWLDataFactory dataFactory, Set<OWLIndividual> values) {
        super(dataFactory);
        this.values = new HashSet<OWLIndividual>(values);
    }

    @Override
    public Set<OWLIndividual> getIndividuals() {
        return Collections.unmodifiableSet(this.values);
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public OWLDescription asObjectUnionOf() {
        if (this.values.size() == 1) {
            return this;
        }
        HashSet<OWLObjectOneOf> ops = new HashSet<OWLObjectOneOf>();
        for (OWLIndividual ind : this.values) {
            ops.add(this.getOWLDataFactory().getOWLObjectOneOf(ind));
        }
        return this.getOWLDataFactory().getOWLObjectUnionOf(ops);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLObjectOneOf)) {
                return false;
            }
            return ((Object)((OWLObjectOneOf)obj).getIndividuals()).equals(this.values);
        }
        return false;
    }

    @Override
    public void accept(OWLDescriptionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLDescriptionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return OWLObjectOneOfImpl.compareSets(this.values, ((OWLObjectOneOf)object).getIndividuals());
    }
}

