/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owl.io.OWLOntologyInputSource;
import org.semanticweb.owl.io.OWLOntologyOutputTarget;
import org.semanticweb.owl.io.PhysicalURIInputSource;
import org.semanticweb.owl.io.PhysicalURIMappingNotFoundException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.DefaultChangeBroadcastStrategy;
import org.semanticweb.owl.model.ImmutableOWLOntologyChangeException;
import org.semanticweb.owl.model.MissingImportEvent;
import org.semanticweb.owl.model.MissingImportListener;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLImportsDeclaration;
import org.semanticweb.owl.model.OWLMutableOntology;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyChangeListener;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyFactory;
import org.semanticweb.owl.model.OWLOntologyFactoryNotFoundException;
import org.semanticweb.owl.model.OWLOntologyFormat;
import org.semanticweb.owl.model.OWLOntologyLoaderListener;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.model.OWLOntologyManagerProperties;
import org.semanticweb.owl.model.OWLOntologyStorageException;
import org.semanticweb.owl.model.OWLOntologyStorer;
import org.semanticweb.owl.model.OWLOntologyStorerNotFoundException;
import org.semanticweb.owl.model.OWLOntologyURIMapper;
import org.semanticweb.owl.model.OWLOntologyURIMappingNotFoundException;
import org.semanticweb.owl.model.SetOntologyURI;
import org.semanticweb.owl.model.UnknownOWLOntologyException;
import uk.ac.manchester.cs.owl.OWLOntologyURIMapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLOntologyManagerImpl
implements OWLOntologyManager,
OWLOntologyFactory.OWLOntologyCreationHandler {
    private static final Logger logger = Logger.getLogger(OWLOntologyManagerImpl.class.getName());
    private boolean allowPhysicalURIsInImportsDeclarations = true;
    private Map<URI, OWLOntology> ontologiesByURI;
    private Map<URI, URI> physicalURIsByOntologyURI;
    private Map<OWLOntology, OWLOntologyFormat> ontologyFormatsByOntology;
    private List<OWLOntologyURIMapper> uriMappers;
    private List<OWLOntologyFactory> ontologyFactories;
    private List<OWLOntologyStorer> ontologyStorers;
    private boolean broadcastChanges;
    private int loadCount = 0;
    private int importsLoadCount = 0;
    private boolean silentMissingImportsHandling;
    private OWLDataFactory dataFactory;
    private Map<OWLOntology, Set<OWLOntology>> importsClosureCache;
    private OWLOntologyManagerProperties properties;
    private List<MissingImportListener> missingImportsListeners;
    private List<OWLOntologyLoaderListener> loaderListeners;
    private int autoGeneratedURICounter;
    private Map<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy> listenerMap = new LinkedHashMap<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy>();

    public OWLOntologyManagerImpl(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
        this.properties = new OWLOntologyManagerProperties();
        this.ontologiesByURI = new HashMap<URI, OWLOntology>();
        this.physicalURIsByOntologyURI = new HashMap<URI, URI>();
        this.ontologyFormatsByOntology = new HashMap<OWLOntology, OWLOntologyFormat>();
        this.uriMappers = new ArrayList<OWLOntologyURIMapper>();
        this.ontologyFactories = new ArrayList<OWLOntologyFactory>();
        this.installDefaultURIMappers();
        this.installDefaultOntologyFactories();
        this.broadcastChanges = true;
        this.ontologyStorers = new ArrayList<OWLOntologyStorer>();
        this.importsClosureCache = new HashMap<OWLOntology, Set<OWLOntology>>();
        this.missingImportsListeners = new ArrayList<MissingImportListener>();
        this.loaderListeners = new ArrayList<OWLOntologyLoaderListener>();
        this.autoGeneratedURICounter = 0;
    }

    public OWLOntologyManagerProperties getProperties() {
        return this.properties;
    }

    @Override
    public OWLDataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    @Override
    public Set<OWLOntology> getOntologies() {
        return new HashSet<OWLOntology>(this.ontologiesByURI.values());
    }

    @Override
    public Set<OWLOntology> getOntologies(OWLAxiom axiom) {
        HashSet<OWLOntology> result = new HashSet<OWLOntology>(this.ontologiesByURI.size());
        for (OWLOntology ont : this.getOntologies()) {
            if (!ont.containsAxiom(axiom)) continue;
            result.add(ont);
        }
        return result;
    }

    public boolean contains(OWLOntology ontology) {
        return this.ontologiesByURI.containsValue(ontology);
    }

    @Override
    public boolean contains(URI ontologyURI) {
        return this.ontologiesByURI.containsKey(ontologyURI);
    }

    @Override
    public OWLOntology getOntology(URI ontologyURI) {
        return this.ontologiesByURI.get(ontologyURI);
    }

    @Override
    public OWLOntology getImportedOntology(OWLImportsDeclaration declaration) {
        OWLOntology importedOntology = this.ontologiesByURI.get(declaration.getImportedOntologyURI());
        if (importedOntology != null) {
            return importedOntology;
        }
        if (this.allowPhysicalURIsInImportsDeclarations) {
            for (URI ontURI : this.physicalURIsByOntologyURI.keySet()) {
                URI physicalURI = this.physicalURIsByOntologyURI.get(ontURI);
                if (!declaration.getImportedOntologyURI().equals(physicalURI)) continue;
                return this.ontologiesByURI.get(ontURI);
            }
        }
        return null;
    }

    @Override
    public Set<OWLOntology> getImports(OWLOntology ontology) {
        HashSet<OWLOntology> imports = new HashSet<OWLOntology>();
        for (OWLImportsDeclaration axiom : ontology.getImportsDeclarations()) {
            OWLOntology importedOntology = this.getImportedOntology(axiom);
            if (importedOntology == null) continue;
            imports.add(importedOntology);
        }
        return imports;
    }

    @Override
    public Set<OWLOntology> getImportsClosure(OWLOntology ontology) {
        Set<OWLOntology> ontologies = this.importsClosureCache.get(ontology);
        if (ontologies == null) {
            ontologies = new HashSet<OWLOntology>();
            this.getImportsClosure(ontology, ontologies);
            this.importsClosureCache.put(ontology, ontologies);
        }
        return Collections.unmodifiableSet(ontologies);
    }

    private void getImportsClosure(OWLOntology ontology, Set<OWLOntology> ontologies) {
        ontologies.add(ontology);
        for (OWLOntology ont : this.getImports(ontology)) {
            if (ontologies.contains(ont)) continue;
            this.getImportsClosure(ont, ontologies);
        }
    }

    @Override
    public List<OWLOntology> getSortedImportsClosure(OWLOntology ontology) throws UnknownOWLOntologyException {
        ArrayList<OWLOntology> importsClosure = new ArrayList<OWLOntology>();
        this.getSortedImportsClosure(ontology, importsClosure, new HashSet<OWLOntology>());
        return importsClosure;
    }

    private void getSortedImportsClosure(OWLOntology ontology, List<OWLOntology> imports, Set<OWLOntology> marker) {
        if (!marker.contains(ontology)) {
            imports.add(ontology);
            marker.add(ontology);
            for (OWLOntology imported : this.getImports(ontology)) {
                this.getSortedImportsClosure(imported, imports, marker);
            }
        }
    }

    private boolean isChangeApplicable(OWLOntologyChange change) {
        return this.getProperties().isLoadAnnotationAxioms() || !(change instanceof AddAxiom) || !(change.getAxiom() instanceof OWLAnnotationAxiom);
    }

    private List<OWLOntologyChange> enactChangeApplication(OWLOntologyChange change) throws OWLOntologyChangeException {
        if (!this.isChangeApplicable(change)) {
            return Collections.emptyList();
        }
        OWLOntology ont = change.getOntology();
        if (!(ont instanceof OWLMutableOntology)) {
            throw new ImmutableOWLOntologyChangeException(change);
        }
        List<OWLOntologyChange> appliedChanges = ((OWLMutableOntology)ont).applyChange(change);
        this.checkForOntologyURIChange(change);
        this.checkForImportsChange(change);
        return appliedChanges;
    }

    @Override
    public List<OWLOntologyChange> applyChanges(List<? extends OWLOntologyChange> changes) throws OWLOntologyChangeException {
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            appliedChanges.addAll(this.enactChangeApplication(oWLOntologyChange));
        }
        this.broadcastChanges(changes);
        return appliedChanges;
    }

    @Override
    public List<OWLOntologyChange> addAxiom(OWLOntology ont, OWLAxiom axiom) throws OWLOntologyChangeException {
        return this.addAxioms(ont, Collections.singleton(axiom));
    }

    @Override
    public List<OWLOntologyChange> addAxioms(OWLOntology ont, Set<? extends OWLAxiom> axioms) throws OWLOntologyChangeException {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>(axioms.size());
        if (ont instanceof OWLMutableOntology) {
            for (OWLAxiom oWLAxiom : axioms) {
                if (ont.containsAxiom(oWLAxiom)) continue;
                AddAxiom addAx = new AddAxiom(ont, oWLAxiom);
                changes.addAll(this.enactChangeApplication(addAx));
            }
        }
        this.broadcastChanges(changes);
        return changes;
    }

    @Override
    public List<OWLOntologyChange> applyChange(OWLOntologyChange change) throws OWLOntologyChangeException {
        List<OWLOntologyChange> changes = this.enactChangeApplication(change);
        this.broadcastChanges(changes);
        return changes;
    }

    private void checkForImportsChange(OWLOntologyChange change) {
        if (change.isAxiomChange() && change.getAxiom() instanceof OWLImportsDeclaration) {
            this.resetImportsClosureCache();
        }
    }

    private void checkForOntologyURIChange(OWLOntologyChange change) {
        if (change instanceof SetOntologyURI) {
            SetOntologyURI setURI = (SetOntologyURI)change;
            this.renameOntology(setURI.getOriginalURI(), setURI.getNewURI());
            this.resetImportsClosureCache();
        }
    }

    @Override
    public void ontologyCreated(OWLOntology ontology) {
        this.addOntology(ontology);
    }

    @Override
    public void setOntologyFormat(OWLOntology ontology, OWLOntologyFormat format) {
        this.ontologyFormatsByOntology.put(ontology, format);
    }

    @Override
    public OWLOntologyFormat getOntologyFormat(OWLOntology ontology) {
        return this.ontologyFormatsByOntology.get(ontology);
    }

    @Override
    public OWLOntology createOntology(URI ontologyURI) throws OWLOntologyCreationException {
        OWLOntology ontology = this.ontologiesByURI.get(ontologyURI);
        if (ontology != null) {
            return ontology;
        }
        URI physicalURI = this.getPhysicalURIFromOntologyURI(ontologyURI, false);
        for (OWLOntologyFactory factory : this.ontologyFactories) {
            if (!factory.canCreateFromPhysicalURI(physicalURI)) continue;
            this.physicalURIsByOntologyURI.put(ontologyURI, physicalURI);
            return factory.createOWLOntology(ontologyURI, physicalURI, this);
        }
        throw new OWLOntologyFactoryNotFoundException(physicalURI);
    }

    @Override
    public OWLOntology createOntology(URI ontologyURI, Set<OWLOntology> ontologies) throws OWLOntologyCreationException, OWLOntologyChangeException {
        return this.createOntology(ontologyURI, ontologies, false);
    }

    @Override
    public OWLOntology createOntology(URI ontologyURI, Set<OWLOntology> ontologies, boolean copyLogicalAxiomsOnly) throws OWLOntologyCreationException, OWLOntologyChangeException {
        if (this.contains(ontologyURI)) {
            throw new OWLOntologyCreationException("Ontology already exists: " + ontologyURI);
        }
        OWLOntology ont = this.createOntology(ontologyURI);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLOntology ontology : ontologies) {
            if (copyLogicalAxiomsOnly) {
                axioms.addAll(ontology.getLogicalAxioms());
                continue;
            }
            axioms.addAll(ontology.getAxioms());
        }
        this.addAxioms(ont, axioms);
        return ont;
    }

    @Override
    public OWLOntology createOntology(Set<OWLAxiom> axioms, URI ontologyURI) throws OWLOntologyCreationException, OWLOntologyChangeException {
        if (this.contains(ontologyURI)) {
            throw new OWLOntologyCreationException("Ontology already exists: " + ontologyURI);
        }
        OWLOntology ont = this.createOntology(ontologyURI);
        this.addAxioms(ont, axioms);
        return ont;
    }

    @Override
    public OWLOntology createOntology(Set<OWLAxiom> axioms) throws OWLOntologyCreationException, OWLOntologyChangeException {
        return this.createOntology(axioms, this.getNextAutoGeneratedURI());
    }

    protected URI getNextAutoGeneratedURI() {
        ++this.autoGeneratedURICounter;
        return URI.create("owlapi:ontology:ont" + this.autoGeneratedURICounter);
    }

    @Override
    public OWLOntology loadOntology(URI ontologyURI) throws OWLOntologyCreationException {
        OWLOntology ontology;
        String frag = ontologyURI.getFragment();
        if (frag == null || frag.length() == 0) {
            // empty if block
        }
        if ((ontology = this.ontologiesByURI.get(ontologyURI)) != null) {
            return ontology;
        }
        URI physicalURI = this.getPhysicalURIFromOntologyURI(ontologyURI, true);
        if (physicalURI != null) {
            ontology = this.getOntology(physicalURI);
            if (ontology != null) {
                return ontology;
            }
        } else {
            throw new PhysicalURIMappingNotFoundException(ontologyURI);
        }
        return this.loadOntology(ontologyURI, new PhysicalURIInputSource(physicalURI));
    }

    @Override
    public OWLOntology loadOntologyFromPhysicalURI(URI uri) throws OWLOntologyCreationException {
        return this.loadOntology(null, new PhysicalURIInputSource(uri));
    }

    @Override
    public OWLOntology loadOntology(OWLOntologyInputSource inputSource) throws OWLOntologyCreationException {
        return this.loadOntology(null, inputSource);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected OWLOntology loadOntology(URI ontologyURI, OWLOntologyInputSource inputSource) throws OWLOntologyCreationException {
        if (this.loadCount != this.importsLoadCount) {
            System.err.println("Runtime Warning: Parsers should load imported ontologies using the makeImportLoadRequest method.");
        }
        this.fireStartedLoadingEvent(ontologyURI, inputSource.getPhysicalURI(), this.loadCount > 0);
        ++this.loadCount;
        this.broadcastChanges = false;
        OWLOntologyCreationException ex = null;
        URI uriOfLoadedOntology = ontologyURI;
        try {
            for (OWLOntologyFactory factory : this.ontologyFactories) {
                if (!factory.canLoad(inputSource)) continue;
                OWLOntology ontology = factory.loadOWLOntology(inputSource, this);
                uriOfLoadedOntology = ontology.getURI();
                this.physicalURIsByOntologyURI.put(ontology.getURI(), inputSource.getPhysicalURI());
                OWLOntology oWLOntology = ontology;
                --this.loadCount;
                if (this.loadCount == 0) {
                    this.broadcastChanges = true;
                }
                this.fireFinishedLoadingEvent(uriOfLoadedOntology, inputSource.getPhysicalURI(), this.loadCount > 0, ex);
                return oWLOntology;
            }
        }
        catch (OWLOntologyCreationException e) {
            try {
                ex = e;
                throw e;
            }
            catch (Throwable throwable) {
                --this.loadCount;
                if (this.loadCount == 0) {
                    this.broadcastChanges = true;
                }
                this.fireFinishedLoadingEvent(uriOfLoadedOntology, inputSource.getPhysicalURI(), this.loadCount > 0, ex);
                throw throwable;
            }
        }
        --this.loadCount;
        if (this.loadCount == 0) {
            this.broadcastChanges = true;
        }
        this.fireFinishedLoadingEvent(uriOfLoadedOntology, inputSource.getPhysicalURI(), this.loadCount > 0, ex);
        throw new OWLOntologyFactoryNotFoundException(inputSource.getPhysicalURI());
    }

    @Override
    public OWLOntology reloadOntology(URI ontologyURI) throws OWLOntologyCreationException {
        this.removeOntology(ontologyURI);
        return this.loadOntology(ontologyURI);
    }

    @Override
    public void removeOntology(URI ontologyURI) {
        OWLOntology ontology = this.ontologiesByURI.get(ontologyURI);
        this.ontologiesByURI.remove(ontologyURI);
        this.ontologyFormatsByOntology.remove(ontology);
        this.physicalURIsByOntologyURI.remove(ontologyURI);
        this.resetImportsClosureCache();
    }

    private void addOntology(OWLOntology ont) {
        this.ontologiesByURI.put(ont.getURI(), ont);
    }

    @Override
    public URI getPhysicalURIForOntology(OWLOntology ontology) throws UnknownOWLOntologyException {
        URI physicalURI = this.physicalURIsByOntologyURI.get(ontology.getURI());
        if (physicalURI == null) {
            throw new UnknownOWLOntologyException(ontology.getURI());
        }
        return physicalURI;
    }

    @Override
    public void setPhysicalURIForOntology(OWLOntology ontology, URI physicalURI) throws UnknownOWLOntologyException {
        if (!this.ontologiesByURI.containsValue(ontology)) {
            throw new UnknownOWLOntologyException(ontology.getURI());
        }
        this.physicalURIsByOntologyURI.put(ontology.getURI(), physicalURI);
    }

    private void renameOntology(URI oldURI, URI newURI) {
        OWLOntology ont = this.ontologiesByURI.get(oldURI);
        if (ont == null) {
            return;
        }
        this.ontologiesByURI.remove(oldURI);
        this.ontologiesByURI.put(newURI, ont);
        URI physicalURI = this.physicalURIsByOntologyURI.remove(oldURI);
        this.physicalURIsByOntologyURI.put(newURI, physicalURI);
        this.resetImportsClosureCache();
    }

    private void resetImportsClosureCache() {
        this.importsClosureCache.clear();
    }

    @Override
    public void saveOntology(OWLOntology ontology) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        OWLOntologyFormat format = this.getOntologyFormat(ontology);
        this.saveOntology(ontology, format);
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyFormat ontologyFormat) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        URI physicalURI = this.getPhysicalURIForOntology(ontology);
        this.saveOntology(ontology, ontologyFormat, physicalURI);
    }

    @Override
    public void saveOntology(OWLOntology ontology, URI physicalURI) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        OWLOntologyFormat format = this.getOntologyFormat(ontology);
        this.saveOntology(ontology, format, physicalURI);
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyFormat ontologyFormat, URI physcialURI) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        for (OWLOntologyStorer storer : this.ontologyStorers) {
            if (!storer.canStoreOntology(ontologyFormat)) continue;
            storer.storeOntology((OWLOntologyManager)this, ontology, physcialURI, ontologyFormat);
            return;
        }
        throw new OWLOntologyStorerNotFoundException(ontologyFormat);
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyOutputTarget outputTarget) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        this.saveOntology(ontology, this.getOntologyFormat(ontology), outputTarget);
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyFormat ontologyFormat, OWLOntologyOutputTarget outputTarget) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        for (OWLOntologyStorer storer : this.ontologyStorers) {
            if (!storer.canStoreOntology(ontologyFormat)) continue;
            storer.storeOntology((OWLOntologyManager)this, ontology, outputTarget, ontologyFormat);
        }
    }

    @Override
    public void addOntologyStorer(OWLOntologyStorer storer) {
        this.ontologyStorers.add(0, storer);
    }

    @Override
    public void removeOntologyStorer(OWLOntologyStorer storer) {
        this.ontologyStorers.remove(storer);
    }

    @Override
    public void addURIMapper(OWLOntologyURIMapper mapper) {
        this.uriMappers.add(0, mapper);
    }

    @Override
    public void clearURIMappers() {
        this.uriMappers.clear();
    }

    @Override
    public void removeURIMapper(OWLOntologyURIMapper mapper) {
        this.uriMappers.remove(mapper);
    }

    @Override
    public void addOntologyFactory(OWLOntologyFactory factory) {
        this.ontologyFactories.add(0, factory);
        factory.setOWLOntologyManager(this);
    }

    @Override
    public void removeOntologyFactory(OWLOntologyFactory factory) {
        this.ontologyFactories.remove(factory);
    }

    private URI getPhysicalURIFromOntologyURI(URI ontologyURI, boolean quiet) {
        for (OWLOntologyURIMapper mapper : this.uriMappers) {
            URI physicalURI = mapper.getPhysicalURI(ontologyURI);
            if (physicalURI == null) continue;
            return physicalURI;
        }
        if (!quiet) {
            throw new OWLOntologyURIMappingNotFoundException(ontologyURI);
        }
        return null;
    }

    private void installDefaultURIMappers() {
        this.addURIMapper(new OWLOntologyURIMapperImpl());
    }

    private void installDefaultOntologyFactories() {
    }

    @Override
    public void addOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.listenerMap.put(listener, new DefaultChangeBroadcastStrategy());
    }

    private void broadcastChanges(List<? extends OWLOntologyChange> changes) {
        if (!this.broadcastChanges) {
            return;
        }
        for (OWLOntologyChangeListener listener : new ArrayList<OWLOntologyChangeListener>(this.listenerMap.keySet())) {
            OWLOntologyChangeBroadcastStrategy strategy = this.listenerMap.get(listener);
            if (strategy == null) continue;
            try {
                strategy.broadcastChanges(listener, changes);
            }
            catch (Exception e) {
                logger.warning("BADLY BEHAVING LISTENER: " + e);
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addOntologyChangeListener(OWLOntologyChangeListener listener, OWLOntologyChangeBroadcastStrategy strategy) {
        this.listenerMap.put(listener, strategy);
    }

    @Override
    public void removeOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.listenerMap.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImports(OWLImportsDeclaration declaration) throws OWLOntologyCreationException {
        ++this.importsLoadCount;
        try {
            this.loadOntology(declaration.getImportedOntologyURI());
        }
        catch (OWLOntologyCreationException e) {
            if (!this.silentMissingImportsHandling) {
                throw e;
            }
            MissingImportEvent evt = new MissingImportEvent(declaration.getImportedOntologyURI(), e);
            this.fireMissingImportEvent(evt);
        }
        finally {
            --this.importsLoadCount;
        }
    }

    @Override
    public void makeLoadImportRequest(OWLImportsDeclaration declaration) throws OWLOntologyCreationException {
        this.loadImports(declaration);
    }

    @Override
    public void setSilentMissingImportsHandling(boolean b) {
        this.silentMissingImportsHandling = b;
    }

    @Override
    public boolean isSilentMissingImportsHandling() {
        return this.silentMissingImportsHandling;
    }

    @Override
    public void addMissingImportListener(MissingImportListener listener) {
        this.missingImportsListeners.add(listener);
    }

    @Override
    public void removeMissingImportListener(MissingImportListener listener) {
        this.missingImportsListeners.remove(listener);
    }

    protected void fireMissingImportEvent(MissingImportEvent evt) {
        for (MissingImportListener listener : new ArrayList<MissingImportListener>(this.missingImportsListeners)) {
            listener.importMissing(evt);
        }
    }

    @Override
    public void addOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.loaderListeners.add(listener);
    }

    @Override
    public void removeOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.loaderListeners.remove(listener);
    }

    protected void fireStartedLoadingEvent(URI ontologyURI, URI physicalURI, boolean imported) {
        for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
            listener.startedLoadingOntology(new OWLOntologyLoaderListener.LoadingStartedEvent(ontologyURI, physicalURI, imported));
        }
    }

    protected void fireFinishedLoadingEvent(URI ontologyURI, URI physicalURI, boolean imported, OWLOntologyCreationException ex) {
        for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
            listener.finishedLoadingOntology(new OWLOntologyLoaderListener.LoadingFinishedEvent(ontologyURI, physicalURI, imported, ex));
        }
    }
}

