/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl;

import java.util.Arrays;
import java.util.HashSet;
import org.semanticweb.owl.model.AxiomType;
import org.semanticweb.owl.model.OWLAxiomVisitor;
import org.semanticweb.owl.model.OWLAxiomVisitorEx;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLObjectVisitorEx;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import uk.ac.manchester.cs.owl.OWLNaryClassAxiomImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLSubClassAxiomImpl
extends OWLNaryClassAxiomImpl
implements OWLSubClassAxiom {
    private OWLDescription subClass;
    private OWLDescription superClass;

    public OWLSubClassAxiomImpl(OWLDataFactory dataFactory, OWLDescription subClass, OWLDescription superClass) {
        super(dataFactory, new HashSet<OWLDescription>(Arrays.asList(subClass, superClass)));
        this.subClass = subClass;
        this.superClass = superClass;
    }

    @Override
    public OWLDescription getSubClass() {
        return this.subClass;
    }

    @Override
    public OWLDescription getSuperClass() {
        return this.superClass;
    }

    @Override
    public boolean isGCI() {
        return this.subClass.isAnonymous();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            if (!(obj instanceof OWLSubClassAxiom)) {
                return false;
            }
            OWLSubClassAxiom other = (OWLSubClassAxiom)obj;
            return other.getSubClass().equals(this.subClass) && other.getSuperClass().equals(this.superClass);
        }
        return false;
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public AxiomType getAxiomType() {
        return AxiomType.SUBCLASS;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLSubClassAxiom other = (OWLSubClassAxiom)object;
        int diff = this.subClass.compareTo(other.getSubClass());
        if (diff != 0) {
            return diff;
        }
        return this.superClass.compareTo(other.getSuperClass());
    }
}

