/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.modularity;

import com.clarkparsia.modularity.locality.LocalityClass;
import com.clarkparsia.modularity.locality.SyntacticLocalityEvaluator;
import java.net.URI;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.semanticweb.owl.model.OWLAnnotationAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLAxiomAnnotationAxiom;
import org.semanticweb.owl.model.OWLDeclarationAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;
import org.semanticweb.owl.modularity.OntologySegmenter;
import uk.ac.manchester.cs.owl.modularity.ModuleType;
import uk.ac.manchester.cs.owl.modularity.SyntacticLocalityModule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyntacticLocalityModuleExtractor
implements OntologySegmenter {
    protected ModuleType moduleType;
    protected OntologyAxiomSet ontologyAxiomSet;
    protected OWLOntology associatedOntology;
    protected OWLOntologyManager associatedOntologyManager;

    public OWLOntology getAssociatedOntology() {
        return this.associatedOntology;
    }

    public OWLOntologyManager getAssociatedOntologyManager() {
        return this.associatedOntologyManager;
    }

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, OWLOntology ont, Set<OWLAxiom> axs, ModuleType moduleType) {
        this.setModuleType(moduleType);
        this.associatedOntologyManager = man;
        this.associatedOntology = ont;
        this.ontologyAxiomSet = new OntologyAxiomSet(axs);
    }

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, OWLOntology ont, ModuleType moduleType) {
        this(man, ont, ont.getAxioms(), moduleType);
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    protected boolean[] extractLogicalAxioms(boolean[] subOnt, Set<OWLEntity> signature, LocalityClass localityClass) {
        boolean[] mod = this.ontologyAxiomSet.getSubset(false);
        boolean[] q2 = this.ontologyAxiomSet.cloneSubset(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        while (change) {
            change = false;
            for (int i = 0; i < q2.length; ++i) {
                if (!q2[i] || sle.isLocal(this.ontologyAxiomSet.getAxiom(i), signature)) continue;
                mod[i] = true;
                q2[i] = false;
                int oldSize = signature.size();
                signature.addAll(this.ontologyAxiomSet.getAxiom(i).getSignature());
                if (signature.size() <= oldSize) continue;
                change = true;
            }
        }
        return mod;
    }

    protected Set<OWLAxiom> extractNonLogicalAxioms(Set<OWLAxiom> logicalAxioms, Set<OWLEntity> sig) {
        HashSet<OWLAxiom> allAxioms = new HashSet<OWLAxiom>(logicalAxioms);
        HashSet<OWLAxiom> nonLogicalAxioms = new HashSet<OWLAxiom>();
        for (int i = 0; i < this.ontologyAxiomSet.size(); ++i) {
            OWLAxiom axiom = this.ontologyAxiomSet.getAxiom(i);
            if (!OWLDeclarationAxiom.class.isAssignableFrom(axiom.getClass()) || !sig.contains(((OWLDeclarationAxiom)axiom).getEntity())) continue;
            allAxioms.add(axiom);
            nonLogicalAxioms.add(axiom);
        }
        for (OWLEntity entity : sig) {
            Set<OWLAnnotationAxiom> annotationAxioms = entity.getAnnotationAxioms(this.associatedOntology);
            allAxioms.addAll(annotationAxioms);
            nonLogicalAxioms.addAll(annotationAxioms);
        }
        LinkedList<OWLAxiomAnnotationAxiom> annotations = new LinkedList<OWLAxiomAnnotationAxiom>();
        for (OWLAxiom axiom : allAxioms) {
            annotations.addAll(axiom.getAnnotationAxioms(this.associatedOntology));
            while (!annotations.isEmpty()) {
                OWLAxiom first = (OWLAxiom)annotations.remove();
                annotations.addAll(first.getAnnotationAxioms(this.associatedOntology));
                allAxioms.add(first);
                nonLogicalAxioms.add(first);
            }
        }
        return nonLogicalAxioms;
    }

    protected boolean[] extractNestedLogicalModule(Set<OWLEntity> signature, boolean[] subOnt, LocalityClass cls1, LocalityClass cls2) {
        HashSet<OWLEntity> seedSig = new HashSet<OWLEntity>(signature);
        boolean[] preModule = this.extractLogicalAxioms(subOnt, seedSig, cls1);
        return this.extractLogicalAxioms(preModule, signature, cls2);
    }

    public SyntacticLocalityModule extractModule(Set<OWLEntity> sig) {
        boolean[] module;
        boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>(sig);
        switch (this.moduleType) {
            case TOP: {
                module = this.extractLogicalAxioms(subOnt, signature, LocalityClass.TOP_TOP);
                break;
            }
            case BOT: {
                module = this.extractLogicalAxioms(subOnt, signature, LocalityClass.BOTTOM_BOTTOM);
                break;
            }
            case BOT_OF_TOP: {
                module = this.extractNestedLogicalModule(signature, subOnt, LocalityClass.TOP_TOP, LocalityClass.BOTTOM_BOTTOM);
                break;
            }
            case TOP_OF_BOT: {
                module = this.extractNestedLogicalModule(signature, subOnt, LocalityClass.BOTTOM_BOTTOM, LocalityClass.TOP_TOP);
                break;
            }
            case INTERSECTION: {
                HashSet<OWLEntity> signature1 = new HashSet<OWLEntity>(sig);
                boolean[] module1 = this.extractNestedLogicalModule(signature1, subOnt, LocalityClass.TOP_TOP, LocalityClass.BOTTOM_BOTTOM);
                HashSet<OWLEntity> signature2 = new HashSet<OWLEntity>(sig);
                boolean[] module2 = this.extractNestedLogicalModule(signature2, subOnt, LocalityClass.BOTTOM_BOTTOM, LocalityClass.TOP_TOP);
                module = new boolean[module1.length];
                for (int i = 0; i < module.length; ++i) {
                    module[i] = module1[i] && module2[i];
                }
                break;
            }
            case BEST: {
                HashSet<OWLEntity> signature1 = new HashSet<OWLEntity>(sig);
                boolean[] module1 = this.extractNestedLogicalModule(signature1, subOnt, LocalityClass.TOP_TOP, LocalityClass.BOTTOM_BOTTOM);
                HashSet<OWLEntity> signature2 = new HashSet<OWLEntity>(sig);
                boolean[] module2 = this.extractNestedLogicalModule(signature2, subOnt, LocalityClass.BOTTOM_BOTTOM, LocalityClass.TOP_TOP);
                if (this.ontologyAxiomSet.subsetCardinality(module1) < this.ontologyAxiomSet.subsetCardinality(module2)) {
                    module = module1;
                    break;
                }
                module = module2;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported module type: " + (Object)((Object)this.moduleType));
            }
        }
        Set<OWLAxiom> logicalAxioms = this.ontologyAxiomSet.getAxiomSet(module);
        HashSet<OWLEntity> moduleSignature = new HashSet<OWLEntity>();
        for (int i = 0; i < module.length; ++i) {
            if (!module[i]) continue;
            moduleSignature.addAll(this.ontologyAxiomSet.getAxiom(i).getSignature());
        }
        Set<OWLAxiom> nonLogicalAxioms = this.extractNonLogicalAxioms(logicalAxioms, moduleSignature);
        return new SyntacticLocalityModule(this, logicalAxioms, nonLogicalAxioms, module, sig, moduleSignature);
    }

    @Override
    public Set<OWLAxiom> extract(Set<OWLEntity> sig) {
        return this.extractModule(sig).getAxioms();
    }

    @Override
    public OWLOntology extractAsOntology(Set<OWLEntity> signature, URI uri) throws OWLOntologyCreationException, OWLOntologyChangeException {
        return this.extractModule(signature).asOWLOntology(uri);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class OntologyAxiomSet {
        protected OWLAxiom[] ax;

        public OntologyAxiomSet(Set<OWLAxiom> axs) {
            this.ax = axs.toArray(new OWLAxiom[axs.size()]);
        }

        public int size() {
            return this.ax.length;
        }

        public OWLAxiom getAxiom(int i) {
            return this.ax[i];
        }

        public OWLAxiom[] getAllAxioms() {
            return this.ax;
        }

        public Set<OWLAxiom> getAxiomSet(boolean[] isIn) {
            HashSet<OWLAxiom> gas = new HashSet<OWLAxiom>();
            for (int i = 0; i < isIn.length; ++i) {
                if (!isIn[i]) continue;
                gas.add(this.ax[i]);
            }
            return gas;
        }

        public boolean[] getSubset(boolean init) {
            boolean[] subset = new boolean[this.ax.length];
            for (int i = 0; i < this.ax.length; ++i) {
                subset[i] = init;
            }
            return subset;
        }

        public boolean[] cloneSubset(boolean[] oldSubset) {
            boolean[] newSubset = new boolean[this.ax.length];
            System.arraycopy(oldSubset, 0, newSubset, 0, this.ax.length);
            return newSubset;
        }

        public int subsetCardinality(boolean[] subset) {
            int card = 0;
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                ++card;
            }
            return card;
        }

        public Set<OWLAxiom> toSet(boolean[] subset) {
            HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>();
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                axs.add(this.ax[i]);
            }
            return axs;
        }
    }
}

