/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.turtle.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.coode.owl.rdfxml.parser.AnonymousNodeChecker;
import org.coode.string.EscapeUtils;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLMutableOntology;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.vocab.OWLRDFVocabulary;
import org.semanticweb.owl.vocab.XSDVocabulary;
import uk.ac.manchester.cs.owl.turtle.parser.ParseException;
import uk.ac.manchester.cs.owl.turtle.parser.SimpleCharStream;
import uk.ac.manchester.cs.owl.turtle.parser.Token;
import uk.ac.manchester.cs.owl.turtle.parser.TripleHandler;
import uk.ac.manchester.cs.owl.turtle.parser.TurtleParserConstants;
import uk.ac.manchester.cs.owl.turtle.parser.TurtleParserException;
import uk.ac.manchester.cs.owl.turtle.parser.TurtleParserTokenManager;

public class TurtleParser
implements AnonymousNodeChecker,
TurtleParserConstants {
    private OWLOntology ontology;
    private OWLDataFactory dataFactory;
    private Map<String, URI> string2URI;
    private Map<String, String> prefix2NamespaceMap;
    private boolean ignoreAnnotationsAndDeclarations = false;
    private String base;
    private int blankNodeId;
    private TripleHandler handler;
    public TurtleParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[21];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public TurtleParser(Reader reader, TripleHandler handler, String base) {
        this(reader);
        this.handler = handler;
        this.base = base;
        this.string2URI = new HashMap<String, URI>();
        this.blankNodeId = 0;
        this.prefix2NamespaceMap = new HashMap<String, String>();
        this.prefix2NamespaceMap.put("", "");
        this.prefix2NamespaceMap.put(null, "");
        this.prefix2NamespaceMap.put("_", "");
    }

    public TurtleParser(InputStream is, TripleHandler handler, String base) {
        this(is);
        this.handler = handler;
        this.base = base;
        this.string2URI = new HashMap<String, URI>();
        this.blankNodeId = 0;
        this.prefix2NamespaceMap = new HashMap<String, String>();
        this.prefix2NamespaceMap.put("", "");
        this.prefix2NamespaceMap.put("_", "");
    }

    public void setTripleHandler(TripleHandler handler) {
        this.handler = handler;
    }

    public boolean isAnonymousNode(String uri) {
        return uri.indexOf("genid") != -1;
    }

    public boolean isAnonymousNode(URI uri) {
        String frag = uri.getFragment();
        return frag != null && frag.indexOf("genid") != -1;
    }

    protected URI getNextBlankNode() {
        URI uri = this.getURI("genid" + this.blankNodeId);
        ++this.blankNodeId;
        return uri;
    }

    protected URI getURIFromQName(String qname) {
        int sepIndex = qname.indexOf(58);
        String prefix = "";
        String localName = qname;
        if (sepIndex != -1) {
            prefix = qname.substring(0, sepIndex);
            localName = qname.substring(sepIndex + 1, qname.length());
        }
        String ns = this.prefix2NamespaceMap.get(prefix);
        return this.getURI(ns + localName);
    }

    protected void addAxiom(OWLAxiom ax) throws TurtleParserException {
        try {
            ((OWLMutableOntology)this.ontology).applyChange(new AddAxiom(this.ontology, ax));
        }
        catch (OWLOntologyChangeException e) {
            throw new TurtleParserException(e);
        }
    }

    public URI getURI(String s) {
        URI uri;
        if (s.charAt(0) == '<') {
            s = s.substring(1, s.length() - 1);
        }
        if ((uri = this.string2URI.get(s)) == null) {
            try {
                uri = new URI(s);
                if (!uri.isAbsolute()) {
                    String uriString = uri.toString();
                    uri = uri.getFragment() != null ? new URI(this.base + uriString) : (this.base.endsWith("/") ? new URI(this.base + uriString) : new URI(this.base + "#" + uriString));
                }
                this.string2URI.put(s, uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return uri;
    }

    public void setIgnoreAnnotationsAndDeclarations(boolean b) {
        this.ignoreAnnotationsAndDeclarations = b;
    }

    public final void parseDocument() throws ParseException {
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 24: 
                case 26: {
                    this.parseDirective();
                    break;
                }
                case 19: 
                case 29: 
                case 30: 
                case 39: 
                case 41: 
                case 42: 
                case 46: {
                    this.parseStatement();
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: 
                case 24: 
                case 26: 
                case 29: 
                case 30: 
                case 39: 
                case 41: 
                case 42: 
                case 46: {
                    continue block7;
                }
            }
            break;
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(0);
        this.handler.handleEnd();
    }

    public final void parseDirective() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: {
                this.parsePrefixDirective();
                break;
            }
            case 26: {
                this.parseBaseDirective();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void parsePrefixDirective() throws ParseException {
        String prefix = "";
        this.jj_consume_token(24);
        Token t = this.jj_consume_token(41);
        prefix = t.image.substring(0, t.image.indexOf(58));
        URI ns = this.parseURIRef();
        this.jj_consume_token(22);
        this.prefix2NamespaceMap.put(prefix, ns.toString());
        this.handler.handlePrefixDirective(prefix, ns.toString());
    }

    public final void parseBaseDirective() throws ParseException {
        this.jj_consume_token(26);
        Token t = this.jj_consume_token(39);
        this.base = t.image.substring(1, t.image.length() - 1);
        this.jj_consume_token(22);
        this.handler.handleBaseDirective(this.base);
    }

    public final void parseStatement() throws ParseException {
        this.parseTriples();
    }

    public final void parseTriples() throws ParseException {
        URI subject = this.parseSubject();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: 
            case 39: 
            case 41: 
            case 46: {
                this.parsePredicateObjectList(subject);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.jj_consume_token(22);
    }

    public final URI parseSubject() throws ParseException {
        URI uri;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: 
            case 41: 
            case 46: {
                uri = this.parseResource();
                break;
            }
            case 19: 
            case 29: 
            case 30: 
            case 42: {
                uri = this.parseBlankNode();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return uri;
    }

    public final URI parseQName() throws ParseException {
        Token t = this.jj_consume_token(41);
        return this.getURIFromQName(t.image);
    }

    public final URI parseURIRef() throws ParseException {
        Token t = this.jj_consume_token(39);
        return this.getURI(t.image);
    }

    public final URI parseBlankNode() throws ParseException {
        URI uri;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                uri = this.parseNodeID();
                break;
            }
            case 29: {
                this.jj_consume_token(29);
                uri = this.getNextBlankNode();
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                uri = this.getNextBlankNode();
                this.parsePredicateObjectList(uri);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                    }
                }
                this.jj_consume_token(31);
                break;
            }
            case 19: {
                uri = this.parseCollection();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return uri;
    }

    public final URI parseNodeID() throws ParseException {
        Token t = this.jj_consume_token(42);
        return this.getURIFromQName(t.image);
    }

    public final void parsePredicateObjectList(URI subject) throws ParseException {
        URI predicate = this.parseVerb();
        this.parseObjectList(subject, predicate);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 23: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(23);
            predicate = this.parseVerb();
            this.parseObjectList(subject, predicate);
        }
    }

    public final URI parseVerb() throws ParseException {
        URI uri;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                uri = OWLRDFVocabulary.RDF_TYPE.getURI();
                break;
            }
            case 39: 
            case 41: 
            case 46: {
                uri = this.parsePredicate();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return uri;
    }

    public final URI parsePredicate() throws ParseException {
        URI uri = this.parseResource();
        return uri;
    }

    public final URI parseResource() throws ParseException {
        URI uri;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 39: {
                uri = this.parseURIRef();
                break;
            }
            case 41: {
                uri = this.parseQName();
                break;
            }
            case 46: {
                uri = this.parseVar();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return uri;
    }

    public final URI parseVar() throws ParseException {
        Token t = this.jj_consume_token(46);
        return this.getURI(t.image.substring(0, t.image.length()));
    }

    public final void parseObjectList(URI subject, URI predicate) throws ParseException {
        this.parseObject(subject, predicate);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
            this.parseObject(subject, predicate);
        }
    }

    public final void parseObject(URI subject, URI predicate) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 33: 
            case 34: {
                this.parseLiteral(subject, predicate);
                break;
            }
            case 19: 
            case 29: 
            case 30: 
            case 39: 
            case 41: 
            case 42: 
            case 46: {
                URI resObject;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 39: 
                    case 41: 
                    case 46: {
                        resObject = this.parseResource();
                        break;
                    }
                    case 19: 
                    case 29: 
                    case 30: 
                    case 42: {
                        resObject = this.parseBlankNode();
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.handler.handleTriple(subject, predicate, resObject);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final URI parseCollection() throws ParseException {
        this.jj_consume_token(19);
        URI uri = this.parseItemList();
        this.jj_consume_token(20);
        return uri;
    }

    public final URI parseItemList() throws ParseException {
        URI firstSubject = null;
        URI subject = null;
        URI type = OWLRDFVocabulary.RDF_TYPE.getURI();
        URI first = OWLRDFVocabulary.RDF_FIRST.getURI();
        URI rest = OWLRDFVocabulary.RDF_REST.getURI();
        URI list = OWLRDFVocabulary.RDF_LIST.getURI();
        URI nil = OWLRDFVocabulary.RDF_NIL.getURI();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 9: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 29: 
                case 30: 
                case 33: 
                case 34: 
                case 39: 
                case 41: 
                case 42: 
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            URI prevSubject = subject;
            subject = this.getNextBlankNode();
            if (prevSubject != null) {
                this.handler.handleTriple(prevSubject, rest, subject);
            } else {
                firstSubject = subject;
            }
            this.handler.handleTriple(subject, type, list);
            this.parseObject(subject, first);
        }
        this.handler.handleTriple(subject, rest, nil);
        return firstSubject;
    }

    public final String parseName() throws ParseException {
        Token t = this.jj_consume_token(41);
        return t.image;
    }

    public final void parseLiteral(URI subject, URI predicate) throws ParseException {
        String lang = null;
        URI datatype = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 13: {
                String literal = this.parseQuotedString();
                block7 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 25: 
                    case 27: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 25: {
                                this.jj_consume_token(25);
                                datatype = this.parseResource();
                                break block7;
                            }
                            case 27: {
                                Token t;
                                this.jj_consume_token(27);
                                block17: while (true) {
                                    t = this.jj_consume_token(43);
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 43: {
                                            continue block17;
                                        }
                                    }
                                    break;
                                }
                                this.jj_la1[14] = this.jj_gen;
                                lang = t.image;
                                break block7;
                            }
                        }
                        this.jj_la1[15] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[16] = this.jj_gen;
                    }
                }
                if (datatype != null) {
                    this.handler.handleTriple(subject, predicate, literal, datatype);
                    break;
                }
                if (lang != null) {
                    this.handler.handleTriple(subject, predicate, literal, lang);
                    break;
                }
                this.handler.handleTriple(subject, predicate, literal);
                break;
            }
            case 14: 
            case 15: {
                String literal = this.parseInteger();
                this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.INTEGER.getURI());
                break;
            }
            case 16: {
                String literal = this.parseDouble();
                this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.DOUBLE.getURI());
                break;
            }
            case 17: {
                String literal = this.parseDecimal();
                this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.DECIMAL.getURI());
                break;
            }
            case 33: 
            case 34: {
                String literal = this.parseBoolean();
                this.handler.handleTriple(subject, predicate, literal, XSDVocabulary.BOOLEAN.getURI());
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final String parseInteger() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                Token t = this.jj_consume_token(15);
                return t.image;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                return t.image;
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String parseDouble() throws ParseException {
        Token t = this.jj_consume_token(16);
        return t.image;
    }

    public final String parseDecimal() throws ParseException {
        Token t = this.jj_consume_token(17);
        return t.image;
    }

    public final String parseBoolean() throws ParseException {
        Token t;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                t = this.jj_consume_token(33);
                break;
            }
            case 34: {
                t = this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return t.image;
    }

    public final String parseQuotedString() throws ParseException {
        String s = this.parseString();
        return s;
    }

    public final String parseString() throws ParseException {
        String rawString = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                Token t = this.jj_consume_token(9);
                rawString = t.image.substring(1, t.image.length() - 1);
                break;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                rawString = t.image.substring(3, t.image.length() - 3);
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return EscapeUtils.unescapeString(rawString);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{1695023104, 1695023104, 0x5000000, 0x10000000, 0x60080000, 0x400000, 0x60080000, 0x800000, 0x10000000, 0, 0x200000, 0x60080000, 1611391488, 1611391488, 0, 0xA000000, 0xA000000, 254464, 49152, 0, 8704};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{18048, 18048, 0, 17024, 18048, 0, 1024, 0, 17024, 17024, 0, 18048, 18054, 18054, 2048, 0, 0, 6, 0, 6, 0};
    }

    public TurtleParser(InputStream stream) {
        this(stream, null);
    }

    public TurtleParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new TurtleParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public TurtleParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new TurtleParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public TurtleParser(TurtleParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(TurtleParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 21; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[49];
        for (i = 0; i < 49; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 21; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 49; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        TurtleParser.jj_la1_0();
        TurtleParser.jj_la1_1();
    }
}

