/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.inference;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.BasicConfigurator;
import org.semanticweb.owl.inference.OWLTaxonomyReasoner;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataPropertyInstance;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLIndividualTypeAssertion;
import org.semanticweb.owl.model.OWLInverseFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLInversePropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyInstance;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLSymmetricPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitivePropertyAxiom;
import org.semanticweb.owl.model.change.OntologyChange;
import org.semanticweb.owl.model.change.OntologyChangeListener;
import org.semanticweb.owl.model.change.OntologyChangeSource;
import org.semanticweb.owl.model.helper.OWLObjectVisitorAdapter;
import org.semanticweb.owl.model.helper.OntologyHelper;

public class NonInferencingTaxonomyReasoner
implements OWLTaxonomyReasoner,
OntologyChangeListener {
    private OWLOntology ontology;
    private Map supers = new HashMap();
    private Map subs = new HashMap();

    public void setOntology(OWLOntology onto) throws OWLException {
        if (this.ontology != null && this.ontology instanceof OntologyChangeSource) {
            ((OntologyChangeSource)this.ontology).removeOntologyChangeListener((OntologyChangeListener)this);
            this.ontology = null;
        }
        if (onto != null) {
            this.ontology = onto;
            if (this.ontology instanceof OntologyChangeSource) {
                ((OntologyChangeSource)this.ontology).addOntologyChangeListener((OntologyChangeListener)this);
            }
            this.initialise();
        }
    }

    private void initialise() throws OWLException {
        OWLClass clazz;
        this.supers = new HashMap();
        this.subs = new HashMap();
        SuperExtracter extracter = new SuperExtracter();
        Iterator it = this.ontology.getClasses().iterator();
        while (it.hasNext()) {
            OWLClass superClass;
            Iterator classIt;
            OWLDescription desc;
            clazz = (OWLClass)it.next();
            Iterator superIt = clazz.getSuperClasses(this.ontology).iterator();
            while (superIt.hasNext()) {
                desc = (OWLDescription)superIt.next();
                extracter.reset();
                desc.accept((OWLObjectVisitor)extracter);
                classIt = extracter.getSupers().iterator();
                while (classIt.hasNext()) {
                    superClass = (OWLClass)classIt.next();
                    this.addSuper(clazz, superClass);
                    this.addSub(superClass, clazz);
                }
            }
            superIt = clazz.getEquivalentClasses(this.ontology).iterator();
            while (superIt.hasNext()) {
                desc = (OWLDescription)superIt.next();
                extracter.reset();
                desc.accept((OWLObjectVisitor)extracter);
                classIt = extracter.getSupers().iterator();
                while (classIt.hasNext()) {
                    superClass = (OWLClass)classIt.next();
                    this.addSuper(clazz, superClass);
                    this.addSub(superClass, clazz);
                }
            }
        }
        it = this.ontology.getClasses().iterator();
        while (it.hasNext()) {
            clazz = (OWLClass)it.next();
            if (!this.superClassesOf(clazz).isEmpty()) continue;
            try {
                OWLClass thing = this.ontology.getClass(new URI(OWLVocabularyAdapter.INSTANCE.getThing()));
                if (clazz == thing) continue;
                this.addSuper(clazz, thing);
                this.addSub(thing, clazz);
            }
            catch (URISyntaxException ex) {}
        }
    }

    private void addSuper(OWLClass class1, OWLClass class2) {
        try {
            HashSet s = (HashSet)this.supers.get(class1);
            if (s == null) {
                s = new HashSet();
                this.supers.put(class1, s);
            }
            Iterator it = s.iterator();
            while (it.hasNext()) {
                Set innerSet = (Set)it.next();
                if (!innerSet.contains(class2)) continue;
                return;
            }
            HashSet<OWLClass> newSet = new HashSet<OWLClass>();
            newSet.add(class2);
            s.add(newSet);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private void addSub(OWLClass class1, OWLClass class2) {
        try {
            HashSet s = (HashSet)this.subs.get(class1);
            if (s == null) {
                s = new HashSet();
                this.subs.put(class1, s);
            }
            Iterator it = s.iterator();
            while (it.hasNext()) {
                Set innerSet = (Set)it.next();
                if (!innerSet.contains(class2)) continue;
                return;
            }
            HashSet<OWLClass> newSet = new HashSet<OWLClass>();
            newSet.add(class2);
            s.add(newSet);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public Set superClassesOf(OWLClass clazz) throws OWLException {
        try {
            HashSet s = (HashSet)this.supers.get(clazz);
            if (s == null) {
                s = new HashSet();
                this.supers.put(clazz, s);
            }
            return s;
        }
        catch (ClassCastException classCastException) {
            return new HashSet();
        }
    }

    public Set subClassesOf(OWLClass clazz) throws OWLException {
        try {
            HashSet s = (HashSet)this.subs.get(clazz);
            if (s == null) {
                s = new HashSet();
                this.subs.put(clazz, s);
            }
            return s;
        }
        catch (ClassCastException classCastException) {
            return new HashSet();
        }
    }

    public Set ancestorClassesOf(OWLClass d) throws OWLException {
        return new HashSet();
    }

    public Set descendantClassesOf(OWLClass d) throws OWLException {
        return new HashSet();
    }

    public Set equivalentClassesOf(OWLClass d) throws OWLException {
        return new HashSet();
    }

    public void ontologyChanged(OntologyChange event) throws OWLException {
    }

    public void dumpHierarchy(PrintWriter pw, OWLClass clazz, int level) throws OWLException {
        for (int i = 0; i < level; ++i) {
            pw.print(" ");
        }
        pw.println(clazz.getURI());
        Set subs = this.subClassesOf(clazz);
        Iterator sit = subs.iterator();
        while (sit.hasNext()) {
            Iterator innerIt = ((Set)sit.next()).iterator();
            while (innerIt.hasNext()) {
                OWLClass cl = (OWLClass)innerIt.next();
                this.dumpHierarchy(pw, cl, level + 1);
            }
        }
    }

    public void dumpHierarchy(PrintWriter pw) throws OWLException {
        try {
            OWLClass thing = this.ontology.getClass(new URI(OWLVocabularyAdapter.INSTANCE.getThing()));
            this.dumpHierarchy(pw, thing, 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            URI uri = new URI(args[0]);
            OWLOntology onto = OntologyHelper.getOntology((URI)uri);
            NonInferencingTaxonomyReasoner reasoner = new NonInferencingTaxonomyReasoner();
            reasoner.setOntology(onto);
            Iterator it = onto.getClasses().iterator();
            while (it.hasNext()) {
                OWLClass clazz = (OWLClass)it.next();
                System.out.println(clazz.getURI());
                Set subs = reasoner.subClassesOf(clazz);
                Iterator sit = subs.iterator();
                while (sit.hasNext()) {
                    Iterator innerIt = ((Set)sit.next()).iterator();
                    while (innerIt.hasNext()) {
                        OWLClass cl = (OWLClass)innerIt.next();
                        System.out.println("> " + cl.getURI());
                    }
                }
                Set supers = reasoner.superClassesOf(clazz);
                Iterator sit2 = supers.iterator();
                while (sit2.hasNext()) {
                    Iterator innerIt = ((Set)sit2.next()).iterator();
                    while (innerIt.hasNext()) {
                        OWLClass cl = (OWLClass)innerIt.next();
                        System.out.println("< " + cl.getURI());
                    }
                }
                Set equivs = reasoner.equivalentClassesOf(clazz);
                Iterator eit = equivs.iterator();
                while (eit.hasNext()) {
                    Iterator innerIt = ((Set)eit.next()).iterator();
                    while (innerIt.hasNext()) {
                        OWLClass cl = (OWLClass)innerIt.next();
                        System.out.println("= " + cl.getURI());
                    }
                }
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            reasoner.dumpHierarchy(pw);
            System.out.println(sw);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void notImplemented(String message) throws OWLException {
        throw new OWLException(message + ": Not yet implemented");
    }

    private class SuperExtracter
    extends OWLObjectVisitorAdapter {
        private Set supers;

        SuperExtracter() {
        }

        void reset() {
            this.supers = new HashSet();
        }

        Set getSupers() {
            return this.supers;
        }

        public void visit(OWLClass node) throws OWLException {
            this.supers.add(node);
        }

        public void visit(OWLAnd node) throws OWLException {
            Iterator it = node.getOperands().iterator();
            while (it.hasNext()) {
                OWLDescription description = (OWLDescription)it.next();
                description.accept((OWLObjectVisitor)this);
            }
        }

        public void visit(OWLFunctionalPropertyAxiom node) throws OWLException {
        }

        public void visit(OWLInverseFunctionalPropertyAxiom node) throws OWLException {
        }

        public void visit(OWLTransitivePropertyAxiom node) throws OWLException {
        }

        public void visit(OWLSymmetricPropertyAxiom node) throws OWLException {
        }

        public void visit(OWLInversePropertyAxiom node) throws OWLException {
        }

        public void visit(OWLPropertyDomainAxiom node) throws OWLException {
        }

        public void visit(OWLObjectPropertyRangeAxiom node) throws OWLException {
        }

        public void visit(OWLDataPropertyRangeAxiom node) throws OWLException {
        }

        public void visit(OWLObjectPropertyInstance node) throws OWLException {
        }

        public void visit(OWLDataPropertyInstance node) throws OWLException {
        }

        public void visit(OWLIndividualTypeAssertion node) throws OWLException {
        }
    }
}

