/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.inference.dl;

import org.apache.log4j.Logger;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLEntityVisitor;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.change.AddAnnotationInstance;
import org.semanticweb.owl.model.change.AddClassAxiom;
import org.semanticweb.owl.model.change.AddDataPropertyInstance;
import org.semanticweb.owl.model.change.AddDataPropertyRange;
import org.semanticweb.owl.model.change.AddDataType;
import org.semanticweb.owl.model.change.AddDomain;
import org.semanticweb.owl.model.change.AddEntity;
import org.semanticweb.owl.model.change.AddEnumeration;
import org.semanticweb.owl.model.change.AddEquivalentClass;
import org.semanticweb.owl.model.change.AddImport;
import org.semanticweb.owl.model.change.AddIndividualAxiom;
import org.semanticweb.owl.model.change.AddIndividualClass;
import org.semanticweb.owl.model.change.AddInverse;
import org.semanticweb.owl.model.change.AddObjectPropertyInstance;
import org.semanticweb.owl.model.change.AddObjectPropertyRange;
import org.semanticweb.owl.model.change.AddPropertyAxiom;
import org.semanticweb.owl.model.change.AddSuperClass;
import org.semanticweb.owl.model.change.AddSuperProperty;
import org.semanticweb.owl.model.change.ChangeVisitorAdapter;
import org.semanticweb.owl.model.change.RemoveEntity;
import org.semanticweb.owl.model.change.SetDeprecated;
import org.semanticweb.owl.model.change.SetFunctional;
import org.semanticweb.owl.model.change.SetInverseFunctional;
import org.semanticweb.owl.model.change.SetOneToOne;
import org.semanticweb.owl.model.change.SetSymmetric;
import org.semanticweb.owl.model.change.SetTransitive;
import uk.ac.man.cs.img.owl.inference.dl.ReasonerProxy;
import uk.ac.man.cs.img.owl.io.dig1_0.RenderingVisitor;

public class OntologyChangeConverter
extends ChangeVisitorAdapter {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$inference$dl$OntologyChangeConverter == null ? (class$uk$ac$man$cs$img$owl$inference$dl$OntologyChangeConverter = OntologyChangeConverter.class$("uk.ac.man.cs.img.owl.inference.dl.OntologyChangeConverter")) : class$uk$ac$man$cs$img$owl$inference$dl$OntologyChangeConverter));
    private RenderingVisitor renderer = new RenderingVisitor();
    private ReasonerProxy reasonerProxy;
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$inference$dl$OntologyChangeConverter;

    public OntologyChangeConverter(ReasonerProxy rP) {
        this.reasonerProxy = rP;
    }

    private void tell(String str) throws OWLException {
        this.reasonerProxy.tell(str);
        logger.debug((Object)str);
    }

    public void visit(AddAnnotationInstance event) throws OWLException {
    }

    public void visit(AddEntity event) throws OWLException {
        EntityAdder adder = new EntityAdder();
        event.getEntity().accept((OWLEntityVisitor)adder);
    }

    public void visit(AddDataType event) throws OWLException {
        throw new OWLException("Can't deal with data types!!");
    }

    public void visit(RemoveEntity event) throws OWLException {
        throw new OWLException("Can't deal with removals!!");
    }

    public void visit(AddImport event) throws OWLException {
        throw new OWLException("Can't yet deal with imports!");
    }

    public void visit(AddIndividualAxiom event) throws OWLException {
        throw new OWLException("Can't deal with individual axioms!");
    }

    public void visit(AddClassAxiom event) throws OWLException {
        this.renderer.reset();
        event.getAxiom().accept((OWLObjectVisitor)this.renderer);
        this.tell(this.renderer.result() + "\n");
    }

    public void visit(AddPropertyAxiom event) throws OWLException {
        this.renderer.reset();
        event.getAxiom().accept((OWLObjectVisitor)this.renderer);
        this.tell(this.renderer.result() + "\n");
    }

    public void visit(AddSuperClass event) throws OWLException {
        String t = "<impliesc>\n";
        this.renderer.reset();
        event.getOWLClass().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        this.renderer.reset();
        event.getDescription().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        t = t + "</impliesc>\n";
        this.tell(t);
    }

    public void visit(AddSuperProperty event) throws OWLException {
        String t = "<impliesr>\n";
        this.renderer.reset();
        event.getProperty().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        this.renderer.reset();
        event.getSuperProperty().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        t = t + "</impliesr>\n";
        this.tell(t);
    }

    public void visit(AddIndividualClass event) throws OWLException {
        String t = "<instanceof>\n";
        this.renderer.reset();
        event.getIndividual().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        this.renderer.reset();
        event.getDescription().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        t = t + "</instanceof>\n";
        this.tell(t);
    }

    public void visit(AddEquivalentClass event) throws OWLException {
        String t = "<equalc>\n";
        this.renderer.reset();
        event.getOWLClass().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        this.renderer.reset();
        event.getDescription().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        t = t + "</equalc>\n";
        this.tell(t);
    }

    public void visit(AddEnumeration event) throws OWLException {
        String t = "<equalc>\n";
        this.renderer.reset();
        event.getOWLClass().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        this.renderer.reset();
        event.getEnumeration().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        t = t + "</equalc>\n";
        this.tell(t);
    }

    public void visit(AddDomain event) throws OWLException {
        String t = "<domain>\n";
        this.renderer.reset();
        event.getProperty().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        this.renderer.reset();
        event.getDomain().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        t = t + "</domain>\n";
        this.tell(t);
    }

    public void visit(AddDataPropertyRange event) throws OWLException {
        throw new OWLException("Can't deal with data property range!!");
    }

    public void visit(AddObjectPropertyRange event) throws OWLException {
        String t = "<range>\n";
        this.renderer.reset();
        event.getProperty().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        this.renderer.reset();
        event.getRange().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        t = t + "</range>\n";
        this.tell(t);
    }

    public void visit(AddInverse event) throws OWLException {
        String t = "<equalr>\n";
        this.renderer.reset();
        event.getProperty().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        this.renderer.reset();
        t = t + "  <inverse>\n";
        event.getInverse().accept((OWLObjectVisitor)this.renderer);
        t = t + "  " + this.renderer.result() + "\n";
        t = t + "  </inverse>\n";
        t = t + "</equalr>\n";
        this.tell(t);
    }

    public void visit(SetFunctional event) throws OWLException {
        if (!event.isFunctional()) {
            throw new OWLException(event.toString());
        }
        String t = "<functional>\n";
        this.renderer.reset();
        event.getProperty().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        t = t + "</functional>\n";
        this.tell(t);
    }

    public void visit(SetTransitive event) throws OWLException {
        if (!event.isTransitive()) {
            throw new OWLException(event.toString());
        }
        String t = "<transitive>\n";
        this.renderer.reset();
        event.getProperty().accept((OWLObjectVisitor)this.renderer);
        t = t + " " + this.renderer.result() + "\n";
        t = t + "</transitive>\n";
        this.tell(t);
    }

    public void visit(SetSymmetric event) throws OWLException {
        throw new OWLException("Can't deal with symmetric");
    }

    public void visit(SetInverseFunctional event) throws OWLException {
        throw new OWLException("Can't deal with inversefunctional");
    }

    public void visit(SetOneToOne event) throws OWLException {
        throw new OWLException("Can't deal with one-to-one");
    }

    public void visit(SetDeprecated event) throws OWLException {
    }

    public void visit(AddObjectPropertyInstance event) throws OWLException {
        throw new OWLException("Can't deal with object property instance");
    }

    public void visit(AddDataPropertyInstance event) throws OWLException {
        throw new OWLException("Can't deal with data property instance");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EntityAdder
    implements OWLEntityVisitor {
        private EntityAdder() {
        }

        public void visit(OWLClass entity) throws OWLException {
            OntologyChangeConverter.this.tell("<defconcept name=\"" + entity.getURI() + "\"/>\n");
        }

        public void visit(OWLObjectProperty entity) throws OWLException {
            OntologyChangeConverter.this.tell("<defrole name=\"" + entity.getURI() + "\"/>\n");
        }

        public void visit(OWLAnnotationProperty entity) throws OWLException {
        }

        public void visit(OWLDataProperty entity) throws OWLException {
            OntologyChangeConverter.this.tell("<defattribute name=\"" + entity.getURI() + "\"/>\n");
        }

        public void visit(OWLIndividual entity) throws OWLException {
            OntologyChangeConverter.this.tell("<defindividual name=\"" + entity.getURI() + "\"/>\n");
        }
    }
}

