/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.man.cs.img.owl.inference.dl;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.semanticweb.owl.inference.OWLConsistencyChecker;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.helper.OntologyHelper;
import org.semanticweb.owl.validation.SpeciesValidator;
import org.semanticweb.owl.validation.SpeciesValidatorReporter;
import org.w3c.dom.Element;
import uk.ac.man.cs.img.dig.helper.Response;
import uk.ac.man.cs.img.dig.reasoner.Reasoner;
import uk.ac.man.cs.img.dig.reasoner.impl.HTTPReasoner;
import uk.ac.man.cs.img.owl.inference.dl.ReasonerProxy;
import uk.ac.man.cs.img.owl.io.dig1_0.Renderer;
import uk.ac.man.cs.img.owl.io.dig1_0.RenderingVisitor;

public class RACERConsistencyChecker
implements OWLConsistencyChecker,
ReasonerProxy {
    static Logger logger = Logger.getLogger((Class)(class$uk$ac$man$cs$img$owl$inference$dl$RACERConsistencyChecker == null ? (class$uk$ac$man$cs$img$owl$inference$dl$RACERConsistencyChecker = RACERConsistencyChecker.class$("uk.ac.man.cs.img.owl.inference.dl.RACERConsistencyChecker")) : class$uk$ac$man$cs$img$owl$inference$dl$RACERConsistencyChecker));
    private Reasoner digReasoner;
    private RenderingVisitor renderer;
    private SpeciesValidator validator;
    private OWLOntology ontology;
    private static int OK = 0;
    private static int NOTOK = 1;
    private static int UNKNOWN = 2;
    private int status;
    static /* synthetic */ Class class$uk$ac$man$cs$img$owl$inference$dl$RACERConsistencyChecker;

    public RACERConsistencyChecker(Reasoner digReasoner) throws OWLException {
        this.digReasoner = digReasoner;
        this.renderer = new RenderingVisitor();
        this.validator = new uk.ac.man.cs.img.owl.validation.SpeciesValidator();
        this.validator.setReporter(new SpeciesValidatorReporter(){

            public void ontology(OWLOntology onto) {
            }

            public void done(String str) {
            }

            public void message(String str) {
            }

            public void explain(int l, String str) {
            }

            public void explain(int l, int code, String str) {
            }
        });
        this.status = UNKNOWN;
    }

    private void initialiseReasoner() throws OWLException {
        this.tell("<clearKB/>");
        this.tell("<defconcept name=\"" + OWLVocabularyAdapter.INSTANCE.getThing() + "\"/>");
        this.tell("<equalc><catom name=\"" + OWLVocabularyAdapter.INSTANCE.getThing() + "\"/><top/></equalc>");
        this.tell("<defconcept name=\"" + OWLVocabularyAdapter.INSTANCE.getNothing() + "\"/>");
        this.tell("<equalc><catom name=\"" + OWLVocabularyAdapter.INSTANCE.getNothing() + "\"/><bottom/></equalc>");
    }

    public void tell(String str) throws OWLException {
        StringWriter sw = new StringWriter();
        sw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sw.write("<tells xmlns=\"http://dl.kr.org/dig/lang\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://dl.kr.org/dig/lang dig.xsd\">");
        sw.write(str);
        sw.write("</tells>");
        StringWriter response = new StringWriter();
        try {
            this.digReasoner.request((Reader)new StringReader(sw.toString()), (Writer)response);
        }
        catch (Exception e) {
            throw new OWLException(e.getMessage());
        }
    }

    private void transmitOntology() throws OWLException {
        this.initialiseReasoner();
        try {
            Renderer renderer = new Renderer();
            StringWriter sw = new StringWriter();
            renderer.renderOntology(this.ontology, (Writer)sw);
            StringWriter response = new StringWriter();
            this.digReasoner.request((Reader)new StringReader(sw.toString()), (Writer)response);
        }
        catch (Exception e) {
            throw new OWLException(e.getMessage());
        }
    }

    public int consistency(OWLOntology onto) throws OWLException {
        this.ontology = onto;
        this.status = UNKNOWN;
        try {
            this.checkStatus();
            StringWriter sw = new StringWriter();
            sw.write("<asks xmlns=\"http://dl.kr.org/dig/lang\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://dl.kr.org/dig/lang dig.xsd\">");
            sw.write("<consistentKB id=\"q\"><top/></consistentKB>");
            sw.write("</asks>");
            StringWriter response = new StringWriter();
            try {
                this.digReasoner.request((Reader)new StringReader(sw.toString()), (Writer)response);
            }
            catch (Exception e) {
                throw new OWLException(e.getMessage());
            }
            Response serverResponse = new Response(response.toString());
            logger.debug((Object)response.toString());
            Element r = serverResponse.extractResponse("q");
            if (r.getTagName().equals("true")) {
                return 0;
            }
            if (r.getTagName().equals("false")) {
                return 1;
            }
            return UNKNOWN;
        }
        catch (OWLException ex) {
            return UNKNOWN;
        }
    }

    private void checkStatus() throws OWLException {
        if (this.status == UNKNOWN) {
            if (!this.validator.isOWLDL(this.ontology)) {
                this.status = NOTOK;
            } else {
                this.status = OK;
                this.transmitOntology();
            }
        }
        if (this.status == NOTOK) {
            throw new ExpressivenessOutOfScopeException("Ontology: " + this.ontology.getURI() + " is not OWL DL!\nThis reasoner can only reason about DL ontologies.");
        }
    }

    private void notImplemented(String message) throws OWLException {
        throw new OWLException(message + ": Not yet implemented");
    }

    public static void main(String[] args) {
        try {
            BasicConfigurator.configure();
            URI uri = new URI(args[1]);
            HTTPReasoner digReasoner = new HTTPReasoner(args[0]);
            RACERConsistencyChecker reasoner = new RACERConsistencyChecker((Reasoner)digReasoner);
            OWLOntology onto = OntologyHelper.getOntology((URI)uri);
            System.out.println("Checking Consistency...");
            int result = reasoner.consistency(onto);
            System.out.println(result == 0 ? "\tConsistent" : (result == 1 ? "\tInconsistent" : "\tUnknown"));
        }
        catch (ExpressivenessOutOfScopeException ex) {
            System.out.println(ex.getMessage());
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ExpressivenessOutOfScopeException
    extends OWLException {
        ExpressivenessOutOfScopeException(String m) {
            super(m);
        }
    }
}

