/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.rdfxml.DoubtfulSet;
import com.clarkparsia.pellint.util.CollectionUtil;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.mindswap.pellet.jena.vocabulary.SWRL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OWLEntityDatabase {
    public static final Logger log = Logger.getLogger(OWLEntityDatabase.class.getName());
    private DoubtfulSet<RDFNode> m_Ontologies = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_Classes = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_Datatypes = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_Individuals = new DoubtfulSet();
    private Set<RDFNode> m_AllRoles = CollectionUtil.makeSet();
    private DoubtfulSet<RDFNode> m_AnnotationRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_OntologyRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_ObjectRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_DatatypeRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_SWRLVariables = new DoubtfulSet();
    private Set<RDFNode> m_RDFClasses = CollectionUtil.makeSet();
    private Set<Resource> m_Restrictions = CollectionUtil.makeSet();
    private Set<RDFNode> m_Literals = CollectionUtil.makeSet();

    public void addOntology(RDFNode s) {
        this.m_Ontologies.addDefinite(OWLEntityDatabase.normalizeURI(s));
    }

    public void assumeOntology(RDFNode s) {
        this.m_Ontologies.add(OWLEntityDatabase.normalizeURI(s));
    }

    public boolean containsOntology(RDFNode s) {
        return this.m_Ontologies.contains(OWLEntityDatabase.normalizeURI(s));
    }

    public Set<RDFNode> getDoubtfulOntologies() {
        return this.m_Ontologies.getDoubtfulElements();
    }

    private static RDFNode normalizeURI(RDFNode s) {
        if (!s.isResource()) {
            log.fine("Trying to normalize a URI for a non-resource node: " + s);
            return s;
        }
        Resource r = (Resource)s;
        if (!r.getURI().endsWith("#")) {
            return ResourceFactory.createResource((String)(s + "#"));
        }
        return r;
    }

    public void addRDFSClass(RDFNode s) {
        this.m_RDFClasses.add(s);
    }

    public Set<RDFNode> getAllRDFClasses() {
        return this.m_RDFClasses;
    }

    public void addRestriction(Resource s) {
        this.m_Restrictions.add(s);
    }

    public Set<Resource> getAllRestrictions() {
        return this.m_Restrictions;
    }

    public void addLiteral(RDFNode s) {
        this.m_Literals.add(s);
    }

    public void addClass(RDFNode s) {
        this.m_Classes.addDefinite(s);
    }

    public void assumeClass(RDFNode s) {
        this.m_Classes.add(s);
    }

    public boolean containsClass(RDFNode s) {
        return this.m_Classes.contains(s) || this.m_Restrictions.contains(s);
    }

    public Set<RDFNode> getDoubtfulClasses() {
        Set<RDFNode> classes = this.m_Classes.getDoubtfulElements();
        classes.removeAll(this.m_Restrictions);
        return classes;
    }

    public void addDatatype(RDFNode s) {
        this.m_Datatypes.addDefinite(s);
    }

    public void assumeDatatype(RDFNode s) {
        this.m_Datatypes.add(s);
    }

    public boolean containsDatatype(RDFNode s) {
        return this.m_Datatypes.contains(s);
    }

    public Set<RDFNode> getDoubtfulDatatypes() {
        return this.m_Datatypes.getDoubtfulElements();
    }

    public void addIndividual(RDFNode s) {
        this.m_Individuals.addDefinite(s);
    }

    public void assumeIndividual(RDFNode s) {
        this.m_Individuals.add(s);
    }

    public boolean containsIndividual(RDFNode s) {
        return this.m_Individuals.contains(s);
    }

    public Set<RDFNode> getDoubtfulIndividuals() {
        return this.m_Individuals.getDoubtfulElements();
    }

    public void addUntypedRole(RDFNode s) {
        this.m_AllRoles.add(s);
    }

    public boolean containsRole(RDFNode s) {
        return this.m_AllRoles.contains(s);
    }

    public Set<RDFNode> getDoubtfulRoles() {
        Set<RDFNode> roles = CollectionUtil.copy(this.m_AllRoles);
        roles.removeAll(this.m_AnnotationRoles);
        roles.removeAll(this.m_OntologyRoles);
        roles.removeAll(this.m_ObjectRoles);
        roles.removeAll(this.m_DatatypeRoles);
        return roles;
    }

    public void addAnnotationRole(RDFNode s) {
        this.m_AllRoles.add(s);
        this.m_AnnotationRoles.addDefinite(s);
    }

    public void assumeAnnotationRole(RDFNode s) {
        this.m_AnnotationRoles.add(s);
    }

    public boolean containsAnnotaionRole(RDFNode s) {
        return this.m_AnnotationRoles.contains(s);
    }

    public Set<RDFNode> getDoubtfulAnnotaionRoles() {
        return this.m_AnnotationRoles.getDoubtfulElements();
    }

    public void addOntologyRole(RDFNode s) {
        this.m_AllRoles.add(s);
        this.m_OntologyRoles.addDefinite(s);
    }

    public boolean containsOntologyRole(RDFNode s) {
        return this.m_OntologyRoles.contains(s);
    }

    public void addObjectRole(RDFNode s) {
        this.m_AllRoles.add(s);
        this.m_ObjectRoles.addDefinite(s);
    }

    public void assumeObjectRole(RDFNode s) {
        this.m_ObjectRoles.add(s);
    }

    public boolean containsObjectRole(RDFNode s) {
        return this.m_ObjectRoles.contains(s);
    }

    public Set<RDFNode> getDoubtfulObjectRoles() {
        return this.m_ObjectRoles.getDoubtfulElements();
    }

    public void addInverseFunctionalRole(RDFNode s) {
        this.addObjectRole(s);
    }

    public void addTransitiveRole(RDFNode s) {
        this.addObjectRole(s);
    }

    public void addSymmetricRole(RDFNode s) {
        this.addObjectRole(s);
    }

    public void addAntiSymmetricRole(Resource s) {
        this.addObjectRole((RDFNode)s);
    }

    public void addReflexiveRole(Resource s) {
        this.addObjectRole((RDFNode)s);
    }

    public void addIrreflexiveRole(Resource s) {
        this.addObjectRole((RDFNode)s);
    }

    public void addDatatypeRole(RDFNode s) {
        this.m_AllRoles.add(s);
        this.m_DatatypeRoles.addDefinite(s);
    }

    public void assumeDatatypeRole(RDFNode s) {
        this.m_DatatypeRoles.add(s);
    }

    public boolean containsDatatypeRole(RDFNode s) {
        return this.m_DatatypeRoles.contains(s);
    }

    public Set<RDFNode> getDoubtfulDatatypeRoles() {
        return this.m_DatatypeRoles.getDoubtfulElements();
    }

    public void addSWRLVariable(RDFNode s) {
        this.m_SWRLVariables.addDefinite(s);
    }

    public void assumeSWRLVariable(RDFNode s) {
        this.m_SWRLVariables.add(s);
    }

    public boolean containsSWRLVariable(RDFNode s) {
        return this.m_SWRLVariables.contains(s);
    }

    public Set<RDFNode> getDoubtfulSWRLVariables() {
        return this.m_SWRLVariables.getDoubtfulElements();
    }

    public boolean containsResource(RDFNode s) {
        return this.m_Ontologies.contains(s) || this.m_Classes.contains(s) || this.m_Datatypes.contains(s) || this.m_Individuals.contains(s) || this.m_AllRoles.contains(s) || this.m_RDFClasses.contains(s) || this.m_Restrictions.contains(s) || this.m_Literals.contains(s) || this.m_SWRLVariables.contains(s);
    }

    public Map<RDFNode, List<String>> getAllMultiTypedResources() {
        Map<String, Set<RDFNode>> definiteResourcesByType = CollectionUtil.makeMap();
        definiteResourcesByType.put("Ontology", this.m_Ontologies.getDefiniteElements());
        definiteResourcesByType.put("Class", this.m_Classes.getDefiniteElements());
        definiteResourcesByType.put("Datatype", this.m_Datatypes.getDefiniteElements());
        definiteResourcesByType.put("Individual", this.m_Individuals.getDefiniteElements());
        definiteResourcesByType.put("Annotation Role", this.m_AnnotationRoles.getDefiniteElements());
        definiteResourcesByType.put("Ontology Role", this.m_OntologyRoles.getDefiniteElements());
        definiteResourcesByType.put("Object Role", this.m_ObjectRoles.getDefiniteElements());
        definiteResourcesByType.put("Datatype Role", this.m_DatatypeRoles.getDefiniteElements());
        definiteResourcesByType.put("Literal", this.m_Literals);
        definiteResourcesByType.put("SWRL Variable", this.m_SWRLVariables.getDefiniteElements());
        Set<RDFNode> allDefiniteResources = CollectionUtil.makeSet();
        for (Set definiteResources : definiteResourcesByType.values()) {
            allDefiniteResources.addAll(definiteResources);
        }
        Map<RDFNode, List<String>> multiTypedResources = CollectionUtil.makeMap();
        for (RDFNode node : allDefiniteResources) {
            List types = CollectionUtil.makeList();
            for (Map.Entry definiteResources : definiteResourcesByType.entrySet()) {
                if (!((Set)definiteResources.getValue()).contains(node)) continue;
                types.add(definiteResources.getKey());
            }
            if (types.size() <= 1) continue;
            multiTypedResources.put(node, types);
        }
        return multiTypedResources;
    }

    public List<Statement> getAllTypingStatements() {
        List<Statement> statements = CollectionUtil.makeList();
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulOntologies(), OWL.Ontology);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulClasses(), OWL.Class);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulDatatypes(), RDFS.Datatype);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulIndividuals(), OWL.Thing);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulRoles(), OWL.ObjectProperty);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulAnnotaionRoles(), OWL.AnnotationProperty);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulObjectRoles(), OWL.ObjectProperty);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulDatatypeRoles(), OWL.DatatypeProperty);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulSWRLVariables(), SWRL.Variable);
        return statements;
    }

    private static void addTypingStatements(List<Statement> statements, Set<RDFNode> subjects, Resource rdfType) {
        Model model = ModelFactory.createDefaultModel();
        for (RDFNode s : subjects) {
            statements.add(model.createStatement((Resource)s, RDF.type, (RDFNode)rdfType));
        }
    }
}

