/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class FileUtil {
    private static final Logger LOGGER = Logger.getLogger(FileUtil.class.getName());

    public static URI toURI(String pathOrURI) {
        URI uri = null;
        try {
            uri = new URI(pathOrURI);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (uri == null || !uri.isAbsolute()) {
            File file = new File(pathOrURI);
            if (!file.exists()) {
                LOGGER.severe("File does not exist: " + file.getAbsolutePath());
                throw new RuntimeException(new FileNotFoundException(file.getAbsolutePath() + " is not found"));
            }
            uri = file.toURI();
        }
        return uri;
    }
}

