/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.io.owl_rdf;

import java.net.URI;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.io.ShortFormProvider;

public class QNameShortFormProvider
implements ShortFormProvider {
    private static String OWL = "http://www.w3.org/2002/07/owl#";
    private static String RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    private static String RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static String XSD = "http://www.w3.org/2001/XMLSchema#";
    private static String DC = "http://purl.org/dc/elements/1.1/";
    private static String FOAF = "http://xmlns.com/foaf/0.1/";
    Map uriToPrefix = new Hashtable();
    Map prefixToUri = new Hashtable();
    Map touchedPrefixes = new Hashtable();

    public QNameShortFormProvider() {
        this.setMapping("owl", OWL);
        this.setMapping("rdf", RDF);
        this.setMapping("rdfs", RDFS);
        this.setMapping("xsd", XSD);
        this.setMapping("dc", DC);
    }

    public static boolean isNameStartChar(char ch) {
        return Character.isLetter(ch) || ch == '_';
    }

    public static boolean isNameChar(char ch) {
        return QNameShortFormProvider.isNameStartChar(ch) || Character.isDigit(ch) || ch == '.' || ch == '-';
    }

    public static int findNameStartIndex(String str) {
        char[] strChars = str.toCharArray();
        int nameStartIndex = -1;
        boolean foundNameChar = false;
        for (int strIndex = strChars.length - 1; strIndex >= 0; --strIndex) {
            char letter = strChars[strIndex];
            if (QNameShortFormProvider.isNameStartChar(letter)) {
                nameStartIndex = strIndex;
                foundNameChar = true;
                continue;
            }
            if (foundNameChar && !QNameShortFormProvider.isNameChar(letter)) break;
        }
        return nameStartIndex;
    }

    public static int findLastNameIndex(String str) {
        char letter;
        char[] strChars = str.toCharArray();
        int nameIndex = -1;
        int strIndex = strChars.length - 1;
        while (strIndex >= 0 && QNameShortFormProvider.isNameChar(letter = strChars[strIndex])) {
            nameIndex = strIndex--;
        }
        return nameIndex;
    }

    public static int findNextNonNameIndex(String str, int startIndex) {
        char letter;
        char[] strChars = str.toCharArray();
        int nameIndex = startIndex;
        for (nameIndex = startIndex; nameIndex < strChars.length && QNameShortFormProvider.isNameChar(letter = strChars[nameIndex]); ++nameIndex) {
        }
        return nameIndex;
    }

    protected static String[] splitURI(URI uri) {
        String prefix;
        String base;
        String uriString = uri.toString();
        String[] bpn = new String[3];
        int nameStart = QNameShortFormProvider.findLastNameIndex(uriString);
        if (nameStart < 0) {
            return null;
        }
        String name = uriString.substring(nameStart);
        if (nameStart == 0) {
            base = "";
            prefix = "a";
        } else {
            base = uriString.substring(0, nameStart);
            int prefixStart = QNameShortFormProvider.findNameStartIndex(base);
            if (prefixStart < 0) {
                prefix = "b";
            } else {
                int prefixEnd = QNameShortFormProvider.findNextNonNameIndex(base, prefixStart + 1);
                prefix = uriString.substring(prefixStart, prefixEnd);
            }
        }
        bpn[0] = base;
        bpn[1] = prefix;
        bpn[2] = name;
        return bpn;
    }

    public String getPrefix(String uri) {
        return (String)this.uriToPrefix.get(uri);
    }

    public String getURI(String prefix) {
        return (String)this.prefixToUri.get(prefix);
    }

    public boolean setMapping(String prefix, String uri) {
        String currentUri = this.getURI(prefix = this.removeExtension(prefix));
        if (currentUri == null) {
            this.prefixToUri.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
            return true;
        }
        return currentUri == uri;
    }

    public Set getPrefixSet() {
        return this.prefixToUri.keySet();
    }

    public String shortForm(URI uri) {
        return this.shortForm(uri, true);
    }

    public String shortForm(URI uri, boolean default_to_uri) {
        String[] bpn = QNameShortFormProvider.splitURI(uri);
        if (bpn == null) {
            if (default_to_uri) {
                return uri.toString();
            }
            return null;
        }
        String base = bpn[0];
        String possible_prefix = bpn[1];
        String name = bpn[2];
        String prefix = this.getPrefix(base);
        if (prefix == null) {
            prefix = this.removeExtension(possible_prefix);
            int mod = 0;
            while (!this.setMapping(prefix, base)) {
                prefix = possible_prefix + mod;
                ++mod;
            }
        }
        this.touchedPrefixes.put(prefix, base);
        String qname = prefix + ":" + name;
        return qname;
    }

    private String removeExtension(String prefix) {
        if (prefix.indexOf(".") >= 0) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        return prefix;
    }
}

