/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem;

import de.dfki.s2m2de.service.PlainTextContent;
import de.dfki.s2m2de.service.RegistryEventHandler;
import de.dfki.s2m2de.service.ServiceComponent;
import de.dfki.s2m2de.service.ServiceRegistry;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.ViewExtractor;
import de.dfki.s2m2de.service.ViewGenerationException;
import de.dfki.s2m2de.textsim.Index;
import de.dfki.s2m2de.textsim.IndexException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class AddToIndexEventHandler
implements RegistryEventHandler {
    private Logger logger = Logger.getLogger(AddToIndexEventHandler.class);
    protected ServiceRegistry registry;
    protected Index index;
    protected ViewExtractor viewExtractor;
    protected Set<String> textSources;

    public AddToIndexEventHandler(ServiceRegistry registry, Index index, ViewExtractor viewExtractor, Set<String> textSources) {
        this.registry = registry;
        this.index = index;
        this.viewExtractor = viewExtractor;
        this.textSources = textSources;
    }

    public AddToIndexEventHandler(ServiceRegistry registry, Index index, ViewExtractor viewExtractor, String textSource) {
        this.registry = registry;
        this.index = index;
        this.viewExtractor = viewExtractor;
        this.textSources = new HashSet<String>();
        this.textSources.add(textSource);
    }

    @Override
    public void handle(URI serviceUri) {
        try {
            ServiceView serviceView = this.registry.getViewOnService(serviceUri, this.viewExtractor);
            String content = "";
            for (String textSource : this.textSources) {
                for (ServiceComponent component : serviceView.getComponents(textSource)) {
                    if (!component.hasCharacteristic(PlainTextContent.class)) continue;
                    content = String.valueOf(content) + component.toString();
                }
            }
            this.index.addDocument(serviceUri.toString(), content);
        }
        catch (ViewGenerationException e) {
            this.logger.warn((Object)("Unable to handle " + serviceUri.toString()), (Throwable)e);
        }
        catch (IndexException e) {
            this.logger.warn((Object)("Unable to handle " + serviceUri.toString()), (Throwable)e);
        }
    }
}

