/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem;

import de.dfki.isem.ISeMReasoner;
import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import de.dfki.s2m2de.inference.InferenceException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.model.OWLDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ApproximatedConceptSubsumption
extends AbstractExpression<URI, Double> {
    protected ISeMReasoner reasoner;

    protected ApproximatedConceptSubsumption(ISeMReasoner reasoner) {
        this.reasoner = reasoner;
    }

    @Override
    public Double evaluate(URI conceptD, URI conceptC) throws ExpressionEvaluationException {
        try {
            double probCPrime;
            double icD;
            OWLDescription conceptK = this.reasoner.contract(conceptC, conceptD);
            if (conceptK == null) {
                return 0.0;
            }
            OWLDescription conceptCPrime = this.reasoner.abduce(conceptK, conceptD);
            if (conceptCPrime == null) {
                return 0.0;
            }
            double icC = -Math.log(this.reasoner.getProbability(conceptC));
            if (Double.isInfinite(icC)) {
                icC = 0.0;
            }
            if (Double.isInfinite(icD = -Math.log(this.reasoner.getProbability(conceptD)))) {
                icD = 0.0;
            }
            double icCPrime = (probCPrime = this.reasoner.getProbability(conceptCPrime)) > 0.0 ? -Math.log(probCPrime) : -Math.log(this.reasoner.getProbabilityLowerBound());
            Set<URI> dcsCPrimeD = this.reasoner.getDirectCommonSubsumers(conceptD, conceptCPrime);
            double icMaxdcs = -1.0;
            for (URI dcs : dcsCPrimeD) {
                double ic = -Math.log(this.reasoner.getProbability(dcs));
                if (!(ic > icMaxdcs)) continue;
                icMaxdcs = ic;
            }
            double simInfCPrimeD = 2.0 * icMaxdcs / (icCPrime + icD);
            Set<URI> dcsCPrimeC = this.reasoner.getDirectCommonSubsumers(conceptC, conceptCPrime);
            icMaxdcs = -1.0;
            for (URI dcs : dcsCPrimeC) {
                double ic = -Math.log(this.reasoner.getProbability(dcs));
                if (!(ic > icMaxdcs)) continue;
                icMaxdcs = ic;
            }
            double simInfCPrimeC = 2.0 * icMaxdcs / (icCPrime + icC);
            return simInfCPrimeD - (1.0 - simInfCPrimeC);
        }
        catch (InferenceException e) {
            throw new ExpressionEvaluationException("Unable to compute approximate concept subsumption for " + conceptC + " and " + conceptD + ".", e);
        }
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        return Collections.emptyList();
    }
}

