/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem;

import de.dfki.isem.ISeM;
import de.dfki.isem.ISeMFactory;
import de.dfki.s2m2de.MatchingException;
import de.dfki.s2m2de.MatchingResult;
import de.dfki.s2m2de.expression.svm.Sample;
import de.dfki.s2m2de.expression.svm.TrainingSet;
import de.dfki.s2m2de.service.ServiceRegistry;
import de.dfki.sme2.RelevanceSet;
import de.dfki.sme2.TestCollection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ISeMCLITool {
    private static Logger logger = Logger.getLogger(ISeMCLITool.class);
    private static File DEFAULT_MODEL = new File("default_model.xml");
    private static String WELCOME = "Welcome to iSeM v1.0 (Intelligent Service Matchmaker).";
    private static String COPYRIGHT = "(c) DFKI GmbH 2010";
    private static String USAGE = "Usage: java -jar isem.jar";
    private static String T = "-t";
    private static String TRAININGSET = "<trainingset>";
    private static String H = "-h";
    private static String C = "-c";
    private static String X = "-x";
    private static String TC = "<testcollection>";
    private static String REQUESTS = "<request(s)>";
    private static String OFFERS = "<offer(s)>+";
    private static String M = "-m";
    private static String MODEL = "<model>";
    private static String V = "-v";
    private static String O = "-o";
    private static String OUTPUT = "<output>";
    private static String REQUESTS_EXPL = "URL or path to OWL-S request document or path to directory of (multiple) OWL-S request documents.";
    private static String OFFERS_EXPL = "URL or path to OWL-S offer document or path to directory of (multiple) OWL-S offer documents. Multiple occurences in arbitrary combination allowed.";
    private static String H_EXPL = "Displays this help message.";
    private static String C_EXPL = "Experiment setup as subsequent arguments in command line interface. " + H + ", " + X + " and " + T + " are exclusive.";
    private static String X_EXPL = "Experiment setup using XML test collection from SME2. " + H + ", " + X + " and " + T + " are exclusive.";
    private static String TC_EXPL = "XML format for test collection as in SME2";
    private static String M_EXPL = "Set the SVM model file to use or the create. \"" + DEFAULT_MODEL.getName() + "\" is used by default.";
    private static String T_EXPL = "Sets iSeM to training mode. Provided test collection XML is used for supervised training. " + H + ", " + X + " and " + T + " are exclusive.";
    private static String TRAININGSET_EXPL = "Training set to train iSeM. XML format for binary relevance as in SME2.";
    private static String MODEL_EXPL = "Model XML file location.";
    private static String V_EXPL = "Run in verbose mode.";
    private static String O_EXPL = "Write result rankings as XML to specified location. If this option is not set, output will printed to the console.";
    private static String OUTPUT_EXPL = "Output XML file.";
    private static String NO_REQUEST_ERROR = "Error: At least one OWL-S request must be specified.";
    private static String NO_OFFER_ERROR = "Error: At least one OWL-S offer must be specified.";
    private static String FILE_NOT_FOUND_ERROR = "Error: The specified file does not exist.";
    private static String NO_MODEL_ERROR = "Error: Model option is set but no file is specified.";
    private static String MATCHING_ERROR = "Error: Matching error. See stack trace for details.";
    private static String NO_TC_ERROR = "Error: A test collection XML file must be provided for the -x option.";
    private static String NO_OUTPUT_ERROR = "Error: Output option is set but no file is specified.";
    private static String SAVE_ERROR = "Error: Unable to write result rankings to file.";
    private static String OPTIONS_ERROR = "Error: Invalid combination of matching/training options. Exactly one of (" + T + ", " + C + ", " + X + ") is allowed.";
    private static String LOGGER_INFO = "See log file for details.";

    public static void main(String[] args) {
        System.out.println(WELCOME);
        System.out.println(COPYRIGHT);
        System.out.println();
        if (args.length == 0) {
            ISeMCLITool.printUsage();
            System.exit(0);
        }
        Vector arguments = new Vector();
        Collections.addAll(arguments, args);
        if (arguments.contains(H)) {
            ISeMCLITool.printUsage();
            System.out.println("  " + X + ":\t\t\t" + X_EXPL);
            System.out.println("  " + TC + ":\t" + TC_EXPL);
            System.out.println();
            System.out.println("  " + C + ":\t\t" + C_EXPL);
            System.out.println("  " + REQUESTS + ":\t" + REQUESTS_EXPL);
            System.out.println("  " + OFFERS + ":\t" + OFFERS_EXPL);
            System.out.println();
            System.out.println("  " + O + ":\t\t" + O_EXPL);
            System.out.println("  " + OUTPUT + ":\t" + OUTPUT_EXPL);
            System.out.println();
            System.out.println("  " + M + ":\t\t" + M_EXPL);
            System.out.println("  " + MODEL + ":\t" + MODEL_EXPL);
            System.out.println();
            System.out.println("  " + T + ":\t\t\t" + T_EXPL);
            System.out.println("  " + TRAININGSET + ":\t" + TRAININGSET_EXPL);
            System.out.println();
            System.out.println("  " + V + ":\t" + V_EXPL);
            System.out.println();
            System.out.println("  " + H + ":\t" + H_EXPL);
            System.out.println();
            System.exit(0);
        }
        int variants = 0;
        if (arguments.contains(T)) {
            ++variants;
        }
        if (arguments.contains(C)) {
            ++variants;
        }
        if (arguments.contains(X)) {
            ++variants;
        }
        if (variants != 1) {
            System.err.println(OPTIONS_ERROR);
            System.exit(1);
        }
        boolean verbose = false;
        if (arguments.contains(V)) {
            verbose = true;
        }
        File modelFile = DEFAULT_MODEL;
        if (arguments.contains(M)) {
            try {
                String modelString = (String)arguments.get(arguments.indexOf(M) + 1);
                if (modelString.startsWith("-")) {
                    System.err.println(NO_MODEL_ERROR);
                    System.exit(1);
                }
                modelFile = new File(modelString);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println(NO_MODEL_ERROR);
                System.exit(1);
            }
        } else if (verbose) {
            System.out.println("Default model file location \"" + DEFAULT_MODEL + "\" is used.");
            System.out.println();
        }
        File outputFile = null;
        if (arguments.contains(O)) {
            try {
                String outputString = (String)arguments.get(arguments.indexOf(O) + 1);
                if (outputString.startsWith("-")) {
                    System.err.println(NO_OUTPUT_ERROR);
                    System.exit(1);
                }
                outputFile = new File(outputString);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println(NO_OUTPUT_ERROR);
                System.exit(1);
            }
        }
        if (arguments.contains(C)) {
            String requestString = null;
            int requestIndex = arguments.indexOf(C) + 1;
            try {
                requestString = (String)arguments.get(requestIndex);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println(NO_REQUEST_ERROR);
                System.exit(1);
            }
            Set<URI> requests = null;
            try {
                requests = ISeMCLITool.getUris(requestString);
            }
            catch (FileNotFoundException e) {
                System.err.println(String.valueOf(FILE_NOT_FOUND_ERROR) + " (" + requestString + ")");
                System.exit(1);
            }
            HashSet<String> offerStrings = new HashSet<String>();
            int i = requestIndex + 1;
            while (i < arguments.size()) {
                String str = (String)arguments.get(i);
                if (str.startsWith("-")) break;
                offerStrings.add(str);
                ++i;
            }
            if (offerStrings.isEmpty()) {
                System.err.println(NO_OFFER_ERROR);
                System.exit(1);
            }
            HashSet<URI> offers = new HashSet<URI>();
            for (String offerString : offerStrings) {
                try {
                    offers.addAll(ISeMCLITool.getUris(offerString));
                }
                catch (FileNotFoundException e) {
                    System.err.println(String.valueOf(FILE_NOT_FOUND_ERROR) + " (" + offerString + ")");
                    System.exit(1);
                }
            }
            if (!modelFile.exists()) {
                System.err.println(String.valueOf(FILE_NOT_FOUND_ERROR) + " (" + modelFile.getName() + ")");
                System.exit(1);
            }
            Map<URI, Vector<MatchingResult>> matchingResult = ISeMCLITool.match(requests, offers, modelFile, verbose);
            if (outputFile == null) {
                ISeMCLITool.printRankings(matchingResult);
            } else {
                try {
                    ISeMCLITool.saveRankings(outputFile, matchingResult, "iSeM Intelligent Service Matchmaker", "from command line interface");
                }
                catch (IOException e) {
                    System.err.println(String.valueOf(SAVE_ERROR) + " (" + outputFile.toString() + ")");
                    logger.error((Object)(String.valueOf(SAVE_ERROR) + " (" + outputFile.toString() + ")"), (Throwable)e);
                    System.err.println(LOGGER_INFO);
                    System.exit(1);
                }
            }
            System.exit(0);
        }
        if (arguments.contains(X)) {
            HashSet<URI> requests = null;
            HashSet<URI> offers = null;
            String tcName = null;
            try {
                String tcString = (String)arguments.get(arguments.indexOf(X) + 1);
                TestCollection tc = TestCollection.parse((String)tcString);
                if (tc == null) {
                    System.err.println(String.valueOf(FILE_NOT_FOUND_ERROR) + " (" + tcString + ")");
                    System.exit(1);
                }
                tcName = tc.getName();
                if (verbose) {
                    ISeMCLITool.printTCInfo(tc);
                }
                requests = new HashSet<URI>();
                for (URI request : tc.getQueries()) {
                    requests.add(request);
                }
                offers = new HashSet<URI>();
                for (URI offer : tc.getServiceOffers()) {
                    offers.add(offer);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println(NO_TC_ERROR);
                System.exit(1);
            }
            if (!modelFile.exists()) {
                System.err.println(String.valueOf(FILE_NOT_FOUND_ERROR) + " (" + modelFile.getName() + ")");
                System.exit(1);
            }
            Map<URI, Vector<MatchingResult>> matchingResult = ISeMCLITool.match(requests, offers, modelFile, verbose);
            if (outputFile == null) {
                ISeMCLITool.printRankings(matchingResult);
            } else {
                try {
                    ISeMCLITool.saveRankings(outputFile, matchingResult, "iSeM Intelligent Service Matchmaker", tcName);
                }
                catch (IOException e) {
                    System.err.println(String.valueOf(SAVE_ERROR) + " (" + outputFile.toString() + ")");
                    logger.error((Object)(String.valueOf(SAVE_ERROR) + " (" + outputFile.toString() + ")"), (Throwable)e);
                    System.err.println(LOGGER_INFO);
                    System.exit(1);
                }
            }
            System.exit(0);
        }
        if (arguments.contains(T)) {
            try {
                String tcString = (String)arguments.get(arguments.indexOf(T) + 1);
                TestCollection tc = TestCollection.parse((String)tcString);
                if (verbose) {
                    ISeMCLITool.printTCInfo(tc);
                }
                ISeMCLITool.train(tc, modelFile, verbose);
                System.exit(0);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println(NO_TC_ERROR);
                System.exit(1);
            }
        }
    }

    private static void printUsage() {
        System.out.println(String.valueOf(USAGE) + " [" + X + " " + TC + "] [" + C + " " + REQUESTS + " " + OFFERS + "] [" + O + " " + OUTPUT + "] [" + M + " " + MODEL + "] [" + T + " " + TRAININGSET + "] [" + V + "] [" + H + "]");
        System.out.println();
    }

    private static Set<URI> getUris(String str) throws FileNotFoundException {
        try {
            URI uri = new URI(str);
            if (uri.getScheme().equals("file")) {
                File file = new File(uri);
                if (!file.exists()) {
                    throw new FileNotFoundException();
                }
                if (file.isDirectory()) {
                    return ISeMCLITool.getUrisFromDirectory(file);
                }
            }
            return Collections.singleton(uri);
        }
        catch (URISyntaxException uri) {
            File file = new File(str);
            if (!file.exists()) {
                throw new FileNotFoundException();
            }
            if (file.isDirectory()) {
                return ISeMCLITool.getUrisFromDirectory(file);
            }
            return Collections.singleton(file.toURI());
        }
    }

    private static Set<URI> getUrisFromDirectory(File dir) {
        HashSet<URI> uris = new HashSet<URI>();
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                uris.addAll(ISeMCLITool.getUrisFromDirectory(file));
            } else {
                uris.add(file.toURI());
            }
            ++n2;
        }
        return uris;
    }

    private static Map<URI, Vector<MatchingResult>> match(Set<URI> requests, Set<URI> offers, File modelFile, boolean verbose) {
        ISeM iSeM = ISeMFactory.createHybridInclApproxLBSVMMatcher(modelFile, true);
        ServiceRegistry registry = iSeM.getServiceRegistry();
        int count = 1;
        for (URI offer : offers) {
            try {
                if (verbose) {
                    System.out.println("Register service offer " + count + " of " + offers.size());
                }
                registry.registerServices(offer.toURL());
                ++count;
            }
            catch (IOException e) {
                System.err.println(String.valueOf(FILE_NOT_FOUND_ERROR) + " (" + offer.toString() + ")");
                logger.error((Object)(String.valueOf(FILE_NOT_FOUND_ERROR) + " (" + offer.toString() + ")"), (Throwable)e);
                System.err.println(LOGGER_INFO);
                System.exit(1);
            }
        }
        if (verbose) {
            System.out.println("Service Registration completed. " + offers.size() + " in total.");
        }
        count = 1;
        HashMap<URI, Vector<MatchingResult>> rankings = new HashMap<URI, Vector<MatchingResult>>();
        for (URI request : requests) {
            try {
                if (verbose) {
                    System.out.println("Match request " + count + " of " + requests.size());
                }
                rankings.put(request, iSeM.match(request.toURL()));
                ++count;
            }
            catch (MatchingException e) {
                System.err.println(MATCHING_ERROR);
                logger.error((Object)MATCHING_ERROR, (Throwable)e);
                System.err.println(LOGGER_INFO);
                System.exit(1);
            }
            catch (IOException e) {
                System.err.println(String.valueOf(FILE_NOT_FOUND_ERROR) + " (" + request.toString() + ")");
                System.exit(1);
            }
        }
        if (verbose) {
            System.out.println("Matching completed. " + requests.size() + " in total.");
        }
        return rankings;
    }

    private static void train(TestCollection tc, File modelFile, boolean verbose) {
        try {
            TrainingSet<URL> trainingSet = new TrainingSet<URL>();
            for (URI request : tc.getQueries()) {
                RelevanceSet relSet = tc.getRelevanceSet(request);
                for (URI offer : tc.getServiceOffers()) {
                    trainingSet.addTrainingSample(new Sample<URL>(request.toURL(), offer.toURL(), relSet.isBinaryRelevant(offer)));
                }
            }
            if (verbose) {
                System.out.println(String.valueOf(trainingSet.getTrainingSet().size()) + " samples available. Training started...");
            }
            ISeMFactory.createHybridInclApproxLBSVMMatcher(trainingSet, modelFile, true);
            if (verbose) {
                System.out.println("Training finised. Model saved to \"" + modelFile.toString() + "\".");
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private static void printTCInfo(TestCollection tc) {
        System.out.println("Test collection information:");
        System.out.println("Name:\t\t" + tc.getName());
        System.out.println("Authors:\t" + tc.getAuthors());
        System.out.println("Type:\t\t" + tc.getType());
        System.out.println("Desc:\t\t" + tc.getDescription());
        System.out.println();
    }

    private static void printRankings(Map<URI, Vector<MatchingResult>> rankings) {
        for (URI request : rankings.keySet()) {
            System.out.println(String.valueOf(request.toString()) + ":");
            int i = 0;
            while (i < request.toString().length()) {
                System.out.print("-");
                ++i;
            }
            System.out.println();
            Vector<MatchingResult> ranking = rankings.get(request);
            int i2 = 0;
            while (i2 < ranking.size()) {
                MatchingResult result = ranking.get(i2);
                System.out.println("  " + (i2 + 1) + ": " + result.getServiceOffer() + " - " + result.getFeatures().values().iterator().next());
                ++i2;
            }
            System.out.println();
        }
    }

    public static void saveRankings(File file, Map<URI, Vector<MatchingResult>> rankings, String matchmakerName, String tcName) throws IOException {
        try {
            Document xml = null;
            Element eval = null;
            xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            eval = xml.createElement("evaluation");
            xml.appendChild(eval);
            Element resultElem = xml.createElement("result");
            resultElem.setAttribute("matchmaker", matchmakerName);
            Element environment = xml.createElement("environment");
            Element timeStamp = xml.createElement("timestamp");
            timeStamp.setTextContent(new Long(new Date().getTime()).toString());
            environment.appendChild(timeStamp);
            Element testCollection = xml.createElement("testcollection");
            testCollection.setTextContent(tcName);
            environment.appendChild(testCollection);
            Element java = xml.createElement("java");
            java.setTextContent(System.getProperty("java.version"));
            environment.appendChild(java);
            Element system = xml.createElement("system");
            system.setTextContent(System.getProperty("os.name"));
            system.setAttribute("version", System.getProperty("os.version"));
            system.setAttribute("architecture", System.getProperty("os.arch"));
            environment.appendChild(system);
            resultElem.appendChild(environment);
            Element rankingsElem = xml.createElement("rankings");
            for (URI query : rankings.keySet()) {
                Vector<MatchingResult> rankedResult = rankings.get(query);
                Element ranking = xml.createElement("ranking");
                ranking.setAttribute("query", query.toString());
                int rankId = 1;
                for (MatchingResult result : rankedResult) {
                    Element rank = xml.createElement("rank");
                    rank.setTextContent(result.getServiceOffer().toString());
                    rank.setAttribute("id", new Integer(rankId++).toString());
                    try {
                        rank.setAttribute("match", "" + result.getFeatures().values().iterator().next());
                    }
                    catch (Exception e) {
                        rank.setAttribute("match", "error");
                    }
                    ranking.appendChild(rank);
                }
                rankingsElem.appendChild(ranking);
            }
            resultElem.appendChild(rankingsElem);
            eval.appendChild(resultElem);
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(xml);
                FileOutputStream os = new FileOutputStream(file);
                StreamResult streamResult = new StreamResult(os);
                transformer.transform(source, streamResult);
            }
            catch (TransformerConfigurationException e) {
                throw new IOException("Unable to save results.", e);
            }
            catch (FileNotFoundException e) {
                throw new IOException("Unable to save results.", e);
            }
            catch (TransformerException e) {
                throw new IOException("Unable to save results.", e);
            }
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to save results.", e);
        }
    }
}

