/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem;

import de.dfki.isem.AddToIndexEventHandler;
import de.dfki.isem.ISeM;
import de.dfki.isem.ISeMReasoner;
import de.dfki.isem.ParameterDefinitionExtractor;
import de.dfki.isem.ProcessClassesEventHandler;
import de.dfki.isem.PruningSVMAggregation;
import de.dfki.isem.RemoveFromIndexEventHandler;
import de.dfki.s2m2de.MatchingSetup;
import de.dfki.s2m2de.expression.Average;
import de.dfki.s2m2de.expression.BooleanAsDouble;
import de.dfki.s2m2de.expression.CachedExpression;
import de.dfki.s2m2de.expression.Concatenation;
import de.dfki.s2m2de.expression.ConditionalExpression;
import de.dfki.s2m2de.expression.Conjunction;
import de.dfki.s2m2de.expression.Disjunction;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import de.dfki.s2m2de.expression.FixedValue;
import de.dfki.s2m2de.expression.GreaterEquals;
import de.dfki.s2m2de.expression.Inverse;
import de.dfki.s2m2de.expression.Maximum;
import de.dfki.s2m2de.expression.Negation;
import de.dfki.s2m2de.expression.ServiceConceptsFilter;
import de.dfki.s2m2de.expression.ServiceLevelConceptsEvaluation;
import de.dfki.s2m2de.expression.ServiceLevelLiteralsEvaluation;
import de.dfki.s2m2de.expression.SpecificationAvailable;
import de.dfki.s2m2de.expression.SpecificationEvaluation;
import de.dfki.s2m2de.expression.True;
import de.dfki.s2m2de.expression.bpg.BipartiteGraphMatching;
import de.dfki.s2m2de.expression.svm.SVMAggregation;
import de.dfki.s2m2de.expression.svm.SVMException;
import de.dfki.s2m2de.expression.svm.Sample;
import de.dfki.s2m2de.expression.svm.TrainingSet;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.dl.DLReasoner;
import de.dfki.s2m2de.inference.dl.NotSupportedException;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import de.dfki.s2m2de.inference.dl.pellet.StructuralConceptSimilarity;
import de.dfki.s2m2de.inference.tp.TheoremProver;
import de.dfki.s2m2de.inference.tp.thetasubsumption.ThetaSubsumptionChecker;
import de.dfki.s2m2de.ranking.RankByCategory;
import de.dfki.s2m2de.ranking.RankDescending;
import de.dfki.s2m2de.service.ServiceRegistry;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.ViewExtractor;
import de.dfki.s2m2de.service.ViewGenerationException;
import de.dfki.s2m2de.service.owls.OWLSExtractor;
import de.dfki.s2m2de.service.owls.OWLSRegistry;
import de.dfki.s2m2de.service.pddl.PDDLExpression;
import de.dfki.s2m2de.textsim.Cosine;
import de.dfki.s2m2de.textsim.Index;
import de.dfki.s2m2de.textsim.IndexException;
import de.dfki.s2m2de.textsim.LossOfInformation;
import de.dfki.s2m2de.textsim.TextSimilarityMeasure;
import de.dfki.s2m2de.textsim.lucene.LuceneMemoryIndex;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ISeMFactory {
    private static Logger logger = Logger.getLogger(ISeMFactory.class);
    private static final OWLSExtractor logicViewExtractor = new OWLSExtractor();
    private static final ParameterDefinitionExtractor hybridViewExtractor = new ParameterDefinitionExtractor();

    private ISeMFactory() {
    }

    public static OWLSExtractor getLogicViewExtractor() {
        return logicViewExtractor;
    }

    public static ParameterDefinitionExtractor getHybridViewExtractor() {
        return hybridViewExtractor;
    }

    public static List<Expression<ServiceView, Boolean>> createLogicBasedFilters(DLReasoner reasoner) throws NotSupportedException {
        LinkedList<Expression<ServiceView, Boolean>> filters = new LinkedList<Expression<ServiceView, Boolean>>();
        ServiceConceptsFilter inputExact = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new Inverse<Collection<URI>, Boolean>(new GreaterEquals(new BipartiteGraphMatching(new BooleanAsDouble<URI>(reasoner.getConceptEquivalence())), new FixedValue(1.0))), "input");
        ServiceConceptsFilter outputExact = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new GreaterEquals<Collection<URI>>(new BipartiteGraphMatching(new BooleanAsDouble<URI>(reasoner.getConceptEquivalence())), new FixedValue(1.0)), "output");
        Conjunction<ServiceView> exactFilter = new Conjunction<ServiceView>(inputExact, outputExact);
        filters.add(exactFilter);
        CachedExpression<ServiceView, Boolean> inputSubsumes = new CachedExpression<ServiceView, Boolean>(new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new Inverse<Collection<URI>, Boolean>(new GreaterEquals(new BipartiteGraphMatching(new BooleanAsDouble<URI>(reasoner.getConceptSubsumption())), new FixedValue(1.0))), "input"));
        ServiceConceptsFilter outputPlugin = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new GreaterEquals<Collection<URI>>(new BipartiteGraphMatching(new BooleanAsDouble<URI>(reasoner.getLeastGenericConcept())), new FixedValue(1.0)), "output");
        Conjunction<ServiceView> pluginFilter = new Conjunction<ServiceView>(inputSubsumes, outputPlugin);
        filters.add(pluginFilter);
        ServiceConceptsFilter outputSubsumes = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new GreaterEquals<Collection<URI>>(new BipartiteGraphMatching(new BooleanAsDouble<URI>(reasoner.getConceptSubsumption())), new FixedValue(1.0)), "output");
        Conjunction<ServiceView> subsumesFilter = new Conjunction<ServiceView>(inputSubsumes, outputSubsumes);
        filters.add(subsumesFilter);
        ServiceConceptsFilter outputSubsumedBy = new ServiceConceptsFilter((Expression<Collection<URI>, Boolean>)new GreaterEquals<Collection<URI>>(new BipartiteGraphMatching(new BooleanAsDouble<URI>(reasoner.getLeastSpecificConcept())), new FixedValue(1.0)), "output");
        Conjunction<ServiceView> subsumedByFilter = new Conjunction<ServiceView>(inputSubsumes, outputSubsumedBy);
        filters.add(subsumedByFilter);
        filters.add(new True());
        return filters;
    }

    public static SpecificationEvaluation<PDDLExpression, Boolean> createPreconditionFilter(TheoremProver<PDDLExpression> prover) {
        SpecificationEvaluation<PDDLExpression, Boolean> expression = new SpecificationEvaluation<PDDLExpression, Boolean>(prover.getImplication(), "precondition");
        return expression;
    }

    public static SpecificationEvaluation<PDDLExpression, Boolean> createEffectFilter(TheoremProver<PDDLExpression> prover) {
        SpecificationEvaluation<PDDLExpression, Boolean> expression = new SpecificationEvaluation<PDDLExpression, Boolean>(new Inverse(prover.getImplication()), "effect");
        return expression;
    }

    public static SVMAggregation<ServiceView> createLogicBasedSVMFilter(DLReasoner reasoner) throws NotSupportedException {
        List<Expression<ServiceView, Boolean>> lbFilters = ISeMFactory.createLogicBasedFilters(reasoner);
        Vector featureSpace = new Vector();
        for (Expression<ServiceView, Boolean> filter : lbFilters) {
            featureSpace.add(new BooleanAsDouble<ServiceView>(filter));
        }
        return new SVMAggregation<ServiceView>(featureSpace);
    }

    public static MatchingSetup createLogicBasedSetup(DLReasoner reasoner) throws NotSupportedException {
        List<Expression<ServiceView, Boolean>> filters = ISeMFactory.createLogicBasedFilters(reasoner);
        RankByCategory rankingOrder = new RankByCategory(filters);
        MatchingSetup setup = new MatchingSetup(logicViewExtractor, new HashSet<Expression<ServiceView, Boolean>>(filters), rankingOrder);
        return setup;
    }

    public static MatchingSetup createLogicBasedSVMSetup(DLReasoner reasoner) throws NotSupportedException {
        SVMAggregation<ServiceView> svmAggregation = ISeMFactory.createLogicBasedSVMFilter(reasoner);
        RankDescending rankingOrder = new RankDescending(svmAggregation);
        HashSet<SVMAggregation<ServiceView>> filters = new HashSet<SVMAggregation<ServiceView>>();
        filters.add(svmAggregation);
        MatchingSetup setup = new MatchingSetup(logicViewExtractor, filters, rankingOrder);
        return setup;
    }

    public static ISeM createLogicBasedMatcher() {
        try {
            OWLSRegistry registry = new OWLSRegistry();
            PelletReasoner reasoner = new PelletReasoner();
            registry.addEventHandler("processClasses", new ProcessClassesEventHandler(registry, reasoner, logicViewExtractor), ServiceRegistry.Event.REGISTRATION);
            MatchingSetup setup = ISeMFactory.createLogicBasedSetup(reasoner);
            return new ISeM(registry, setup);
        }
        catch (NotSupportedException e) {
            return null;
        }
    }

    public static ISeM createLogicBasedSVMMatcher(TrainingSet<URL> trainingSet, File outputFile) {
        MatchingSetup setup;
        OWLSRegistry registry = new OWLSRegistry();
        PelletReasoner reasoner = new PelletReasoner();
        registry.addEventHandler("processClasses", new ProcessClassesEventHandler(registry, reasoner, logicViewExtractor), ServiceRegistry.Event.REGISTRATION);
        try {
            setup = ISeMFactory.createLogicBasedSVMSetup(reasoner);
        }
        catch (NotSupportedException e) {
            return null;
        }
        ISeM iSeM = new ISeM(registry, setup);
        try {
            OWLSRegistry tmpRegistry = new OWLSRegistry();
            tmpRegistry.addEventHandler("processClasses", new ProcessClassesEventHandler(tmpRegistry, reasoner, logicViewExtractor), ServiceRegistry.Event.REGISTRATION);
            TrainingSet<ServiceView> tmpTrainingSet = new TrainingSet<ServiceView>();
            for (Sample<URL> sample : trainingSet.getTrainingSet()) {
                URL requestUrl = sample.getRequestEntity();
                URL offerUrl = sample.getOfferEntity();
                try {
                    URI requestUri = tmpRegistry.registerServices(requestUrl).iterator().next();
                    URI offerUri = tmpRegistry.registerServices(offerUrl).iterator().next();
                    Sample<ServiceView> tmpSample = new Sample<ServiceView>(((ServiceRegistry)tmpRegistry).getViewOnService(requestUri, logicViewExtractor), ((ServiceRegistry)tmpRegistry).getViewOnService(offerUri, logicViewExtractor), sample.isRelevant());
                    tmpTrainingSet.addTrainingSample(tmpSample);
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to temporarly register sample service for SVM training.", (Throwable)e);
                }
                catch (ViewGenerationException e) {
                    logger.warn((Object)"Unable to extract sample service information for SVM training.", (Throwable)e);
                }
            }
            if (outputFile == null) {
                ((SVMAggregation)setup.getFeatureSpace().iterator().next()).train(tmpTrainingSet, 2.0, 0.25, 6, 0L);
            } else {
                ((SVMAggregation)setup.getFeatureSpace().iterator().next()).train(tmpTrainingSet, 2.0, 0.25, 6, 0L, outputFile);
            }
        }
        catch (SVMException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        catch (ExpressionEvaluationException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            e.printStackTrace();
        }
        return iSeM;
    }

    public static Expression<ServiceView, Double> createTextSimilarityFilter(TextSimilarityMeasure textSimMeasure) {
        HashSet<String> textScope = new HashSet<String>();
        textScope.add("inputDef");
        textScope.add("outputDef");
        return new ServiceLevelLiteralsEvaluation<Double>(new Concatenation<Double>(textSimMeasure), textScope);
    }

    public static Expression<ServiceView, Double> createStructuredTextSimilarityFilter(TextSimilarityMeasure inputTextSim, TextSimilarityMeasure outputTextSim) {
        return new Average<ServiceView>(new ServiceLevelLiteralsEvaluation<Double>(new Concatenation<Double>(inputTextSim), "inputDef"), new ServiceLevelLiteralsEvaluation<Double>(new Concatenation<Double>(outputTextSim), "outputDef"));
    }

    public static MatchingSetup createTextSimilaritySetup(TextSimilarityMeasure textSimMeasure) {
        Expression<ServiceView, Double> filter = ISeMFactory.createTextSimilarityFilter(textSimMeasure);
        HashSet<Expression<ServiceView, Double>> filters = new HashSet<Expression<ServiceView, Double>>();
        filters.add(filter);
        RankDescending rankingOrder = new RankDescending(filter);
        MatchingSetup setup = new MatchingSetup(hybridViewExtractor, filters, rankingOrder);
        return setup;
    }

    public static MatchingSetup createStructuredTextSimilaritySetup(TextSimilarityMeasure inputTextSim, TextSimilarityMeasure outputTextSim) {
        Expression<ServiceView, Double> filter = ISeMFactory.createStructuredTextSimilarityFilter(inputTextSim, outputTextSim);
        HashSet<Expression<ServiceView, Double>> filters = new HashSet<Expression<ServiceView, Double>>();
        filters.add(filter);
        RankDescending rankingOrder = new RankDescending(filter);
        MatchingSetup setup = new MatchingSetup(hybridViewExtractor, filters, rankingOrder);
        return setup;
    }

    public static Expression<ServiceView, Double> createStructuralFilter(PelletReasoner reasoner) {
        return new Average<ServiceView>(new ServiceLevelConceptsEvaluation<Double>(new Inverse(new BipartiteGraphMatching<URI>(new StructuralConceptSimilarity(reasoner))), "input"), new ServiceLevelConceptsEvaluation<Double>(new BipartiteGraphMatching<URI>(new StructuralConceptSimilarity(reasoner)), "output"));
    }

    public static MatchingSetup createStructureSetup(PelletReasoner reasoner) {
        Expression<ServiceView, Double> filter = ISeMFactory.createStructuralFilter(reasoner);
        HashSet<Expression<ServiceView, Double>> filters = new HashSet<Expression<ServiceView, Double>>();
        filters.add(filter);
        RankDescending rankingOrder = new RankDescending(filter);
        MatchingSetup setup = new MatchingSetup(logicViewExtractor, filters, rankingOrder);
        return setup;
    }

    public static ISeM createStructureMatcher() {
        OWLSRegistry registry = new OWLSRegistry();
        PelletReasoner reasoner = new PelletReasoner();
        registry.addEventHandler("processClasses", new ProcessClassesEventHandler(registry, reasoner, logicViewExtractor), ServiceRegistry.Event.REGISTRATION);
        MatchingSetup setup = ISeMFactory.createStructureSetup(reasoner);
        return new ISeM(registry, setup);
    }

    public static ISeM createCosineTextSimMatcher() {
        LuceneMemoryIndex index;
        try {
            index = new LuceneMemoryIndex();
        }
        catch (IndexException e) {
            logger.error((Object)"Unable to create document index instance. Matcher has not been initialized.", (Throwable)e);
            return null;
        }
        OWLSRegistry registry = new OWLSRegistry();
        HashSet<String> textSources = new HashSet<String>();
        textSources.add("inputDef");
        textSources.add("outputDef");
        registry.addEventHandler("addDoc", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)index, (ViewExtractor)hybridViewExtractor, textSources), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("removeDoc", new RemoveFromIndexEventHandler(index), ServiceRegistry.Event.DEREGISTRATION);
        Cosine cosineMeasure = new Cosine(index);
        MatchingSetup setup = ISeMFactory.createTextSimilaritySetup(cosineMeasure);
        return new ISeM(registry, setup);
    }

    public static ISeM createStructuredCosineTextSimMatcher() {
        LuceneMemoryIndex outputIndex;
        LuceneMemoryIndex inputIndex;
        try {
            inputIndex = new LuceneMemoryIndex();
            outputIndex = new LuceneMemoryIndex();
        }
        catch (IndexException e) {
            logger.error((Object)"Unable to create document index instance. Matcher has not been initialized.", (Throwable)e);
            return null;
        }
        OWLSRegistry registry = new OWLSRegistry();
        registry.addEventHandler("addDoc_input", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)inputIndex, (ViewExtractor)hybridViewExtractor, "inputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_output", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)outputIndex, (ViewExtractor)hybridViewExtractor, "outputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("removeDoc_input", new RemoveFromIndexEventHandler(inputIndex), ServiceRegistry.Event.DEREGISTRATION);
        registry.addEventHandler("removeDoc_output", new RemoveFromIndexEventHandler(outputIndex), ServiceRegistry.Event.DEREGISTRATION);
        Cosine inputCosineMeasure = new Cosine(inputIndex);
        Cosine outputCosineMeasure = new Cosine(outputIndex);
        MatchingSetup setup = ISeMFactory.createStructuredTextSimilaritySetup(inputCosineMeasure, outputCosineMeasure);
        return new ISeM(registry, setup);
    }

    public static SVMAggregation<ServiceView> createHybridSVMFilter(PelletReasoner reasoner, TheoremProver<PDDLExpression> prover, TextSimilarityMeasure inputSim, TextSimilarityMeasure outputSim, TextSimilarityMeasure descSim) throws NotSupportedException {
        List<Expression<ServiceView, Boolean>> lbFilters = ISeMFactory.createLogicBasedFilters(reasoner);
        Vector featureSpace = new Vector();
        for (Expression<ServiceView, Boolean> filter : lbFilters) {
            featureSpace.add(new BooleanAsDouble<ServiceView>(filter));
        }
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(inputSim), "inputDef"));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(outputSim), "outputDef"));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(descSim), "description"));
        if (prover != null) {
            featureSpace.add(new BooleanAsDouble<PDDLExpression>(ISeMFactory.createPreconditionFilter(prover)));
            featureSpace.add(new BooleanAsDouble<PDDLExpression>(ISeMFactory.createEffectFilter(prover)));
            featureSpace.add(new BooleanAsDouble<ServiceView>(new SpecificationAvailable("precondition")));
            featureSpace.add(new BooleanAsDouble<ServiceView>(new SpecificationAvailable("effect")));
        }
        featureSpace.add(ISeMFactory.createStructuralFilter(reasoner));
        return new SVMAggregation<ServiceView>(featureSpace);
    }

    public static MatchingSetup createHybridSVMSetup(PelletReasoner reasoner, TheoremProver<PDDLExpression> prover, TextSimilarityMeasure inputSim, TextSimilarityMeasure outputSim, TextSimilarityMeasure descSim) throws NotSupportedException {
        SVMAggregation<ServiceView> svmAggregation = ISeMFactory.createHybridSVMFilter(reasoner, prover, inputSim, outputSim, descSim);
        RankDescending rankingOrder = new RankDescending(svmAggregation);
        HashSet<SVMAggregation<ServiceView>> filters = new HashSet<SVMAggregation<ServiceView>>();
        filters.add(svmAggregation);
        MatchingSetup setup = new MatchingSetup(hybridViewExtractor, filters, rankingOrder);
        return setup;
    }

    public static ISeM createHybridSVMMatcher(TrainingSet<URL> trainingSet, File outputFile, boolean matchPE) {
        MatchingSetup setup;
        LuceneMemoryIndex descIndex;
        LuceneMemoryIndex outputIndex;
        LuceneMemoryIndex inputIndex;
        OWLSRegistry registry = new OWLSRegistry();
        PelletReasoner reasoner = new PelletReasoner();
        ThetaSubsumptionChecker prover = null;
        if (matchPE) {
            try {
                prover = new ThetaSubsumptionChecker();
            }
            catch (InferenceException e) {
                logger.error((Object)"Unable to initialize theta-subsumption checker. Matcher will be initialized without PE matching capability.", (Throwable)e);
                prover = null;
            }
        }
        try {
            inputIndex = new LuceneMemoryIndex();
            outputIndex = new LuceneMemoryIndex();
            descIndex = new LuceneMemoryIndex();
        }
        catch (IndexException e) {
            logger.error((Object)"Unable to create document index instance. Matcher has not been initialized.", (Throwable)e);
            return null;
        }
        registry.addEventHandler("processClasses", new ProcessClassesEventHandler(registry, reasoner, hybridViewExtractor), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_input", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)inputIndex, (ViewExtractor)hybridViewExtractor, "inputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_output", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)outputIndex, (ViewExtractor)hybridViewExtractor, "outputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_desc", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)descIndex, (ViewExtractor)hybridViewExtractor, "description"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("removeDoc_input", new RemoveFromIndexEventHandler(inputIndex), ServiceRegistry.Event.DEREGISTRATION);
        registry.addEventHandler("removeDoc_output", new RemoveFromIndexEventHandler(outputIndex), ServiceRegistry.Event.DEREGISTRATION);
        registry.addEventHandler("removeDoc_desc", new RemoveFromIndexEventHandler(descIndex), ServiceRegistry.Event.DEREGISTRATION);
        Cosine inputCosineMeasure = new Cosine(inputIndex);
        Cosine outputCosineMeasure = new Cosine(outputIndex);
        Cosine descCosineMeasure = new Cosine(descIndex);
        try {
            setup = ISeMFactory.createHybridSVMSetup(reasoner, prover, inputCosineMeasure, outputCosineMeasure, descCosineMeasure);
        }
        catch (NotSupportedException e) {
            return null;
        }
        ISeM iSeM = new ISeM(registry, setup);
        try {
            OWLSRegistry tmpRegistry = new OWLSRegistry();
            tmpRegistry.addEventHandler("processClasses", new ProcessClassesEventHandler(tmpRegistry, reasoner, hybridViewExtractor), ServiceRegistry.Event.REGISTRATION);
            tmpRegistry.addEventHandler("addDoc_input", new AddToIndexEventHandler((ServiceRegistry)tmpRegistry, (Index)inputIndex, (ViewExtractor)hybridViewExtractor, "inputDef"), ServiceRegistry.Event.REGISTRATION);
            tmpRegistry.addEventHandler("addDoc_output", new AddToIndexEventHandler((ServiceRegistry)tmpRegistry, (Index)outputIndex, (ViewExtractor)hybridViewExtractor, "outputDef"), ServiceRegistry.Event.REGISTRATION);
            tmpRegistry.addEventHandler("addDoc_desc", new AddToIndexEventHandler((ServiceRegistry)tmpRegistry, (Index)descIndex, (ViewExtractor)hybridViewExtractor, "description"), ServiceRegistry.Event.REGISTRATION);
            TrainingSet<ServiceView> tmpTrainingSet = new TrainingSet<ServiceView>();
            for (Sample<URL> sample : trainingSet.getTrainingSet()) {
                URL requestUrl = sample.getRequestEntity();
                URL offerUrl = sample.getOfferEntity();
                try {
                    URI requestUri = tmpRegistry.registerServices(requestUrl).iterator().next();
                    URI offerUri = tmpRegistry.registerServices(offerUrl).iterator().next();
                    Sample<ServiceView> tmpSample = new Sample<ServiceView>(((ServiceRegistry)tmpRegistry).getViewOnService(requestUri, hybridViewExtractor), ((ServiceRegistry)tmpRegistry).getViewOnService(offerUri, hybridViewExtractor), sample.isRelevant());
                    tmpTrainingSet.addTrainingSample(tmpSample);
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to temporarly register sample service for SVM training.", (Throwable)e);
                }
                catch (ViewGenerationException e) {
                    logger.warn((Object)"Unable to extract sample service information for SVM training.", (Throwable)e);
                }
            }
            if (outputFile == null) {
                ((SVMAggregation)setup.getFeatureSpace().iterator().next()).train(tmpTrainingSet, 2.0, 0.25, 6, 0L);
            } else {
                ((SVMAggregation)setup.getFeatureSpace().iterator().next()).train(tmpTrainingSet, 2.0, 0.25, 6, 0L, outputFile);
            }
        }
        catch (SVMException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        catch (ExpressionEvaluationException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        return iSeM;
    }

    public static List<Expression<ServiceView, Double>> createApproxLogicBasedFilters(ISeMReasoner reasoner) {
        LinkedList<Expression<ServiceView, Double>> filters = new LinkedList<Expression<ServiceView, Double>>();
        CachedExpression approxInput = new CachedExpression(new ServiceLevelConceptsEvaluation(new Inverse(new BipartiteGraphMatching<URI>(reasoner.getApproximatedConceptSubsumption())), "input"));
        ServiceLevelConceptsEvaluation<Double> approxPluginOutput = new ServiceLevelConceptsEvaluation<Double>(new BipartiteGraphMatching<URI>(reasoner.getApproximatedConceptSubsumption()), "output");
        ServiceLevelConceptsEvaluation<Double> approxSubsumedByOutput = new ServiceLevelConceptsEvaluation<Double>(new BipartiteGraphMatching<URI>(new Inverse<URI, Double>(reasoner.getApproximatedConceptSubsumption())), "output");
        Average h1 = new Average(approxInput, approxPluginOutput);
        Average h2 = new Average(approxInput, approxSubsumedByOutput);
        filters.add(h1);
        filters.add(h2);
        return filters;
    }

    public static Expression<ServiceView, Double> createSingleApproxLogicBasedFilter(ISeMReasoner reasoner) {
        List<Expression<ServiceView, Double>> filters = ISeMFactory.createApproxLogicBasedFilters(reasoner);
        return new Maximum<ServiceView>(filters.get(0), filters.get(1));
    }

    public static MatchingSetup createApproxLogicBasedSetup(ISeMReasoner reasoner) {
        Expression<ServiceView, Double> feature = ISeMFactory.createSingleApproxLogicBasedFilter(reasoner);
        RankDescending ranking = new RankDescending(feature);
        return new MatchingSetup(logicViewExtractor, Collections.singleton(feature), ranking);
    }

    public static ISeM createApproxLogicBasedMatcher() {
        OWLSRegistry registry = new OWLSRegistry();
        ISeMReasoner reasoner = new ISeMReasoner(registry, logicViewExtractor);
        registry.addEventHandler("processClasses", new ProcessClassesEventHandler(registry, reasoner, logicViewExtractor), ServiceRegistry.Event.REGISTRATION);
        MatchingSetup setup = ISeMFactory.createApproxLogicBasedSetup(reasoner);
        return new ISeM(registry, setup);
    }

    public static void main(String[] args) {
        try {
            SVMAggregation<ServiceView> filter = ISeMFactory.createHybridSVMFilter(new PelletReasoner(), null, new LossOfInformation(), new LossOfInformation(), new Cosine(new LuceneMemoryIndex()));
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element filterElem = xml.createElement("filter");
            xml.appendChild(filterElem);
            filter.decompile(xml, filterElem);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(xml);
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            transformer.transform(source, streamResult);
            System.out.println(writer.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SVMAggregation<ServiceView> createHybridInclApproxLBSVMFilter(ISeMReasoner reasoner, TheoremProver<PDDLExpression> prover, TextSimilarityMeasure inputSim, TextSimilarityMeasure outputSim, TextSimilarityMeasure descSim) throws NotSupportedException {
        List<Expression<ServiceView, Boolean>> lbFilters = ISeMFactory.createLogicBasedFilters(reasoner);
        Vector<CachedExpression<ServiceView, Boolean>> cachedLbFilters = new Vector<CachedExpression<ServiceView, Boolean>>();
        int i = 0;
        while (i < 4) {
            cachedLbFilters.add(new CachedExpression<ServiceView, Boolean>(lbFilters.get(i)));
            ++i;
        }
        CachedExpression logicalMatch = new CachedExpression(new Disjunction(new HashSet(cachedLbFilters)));
        Vector featureSpace = new Vector();
        for (Expression expression : cachedLbFilters) {
            featureSpace.add(new BooleanAsDouble(expression));
        }
        featureSpace.add(new BooleanAsDouble(new Negation(logicalMatch)));
        List<Expression<ServiceView, Double>> list = ISeMFactory.createApproxLogicBasedFilters(reasoner);
        featureSpace.add(new ConditionalExpression<ServiceView, Double>(logicalMatch, new FixedValue(1.0), list.get(0)));
        featureSpace.add(new ConditionalExpression<ServiceView, Double>(logicalMatch, new FixedValue(1.0), list.get(1)));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(inputSim), "inputDef"));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(outputSim), "outputDef"));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(descSim), "description"));
        if (prover != null) {
            featureSpace.add(new BooleanAsDouble<PDDLExpression>(ISeMFactory.createPreconditionFilter(prover)));
            featureSpace.add(new BooleanAsDouble<PDDLExpression>(ISeMFactory.createEffectFilter(prover)));
            featureSpace.add(new BooleanAsDouble<ServiceView>(new SpecificationAvailable("precondition")));
            featureSpace.add(new BooleanAsDouble<ServiceView>(new SpecificationAvailable("effect")));
        }
        featureSpace.add(ISeMFactory.createStructuralFilter(reasoner));
        return new SVMAggregation<ServiceView>(featureSpace);
    }

    public static SVMAggregation<ServiceView> createHybridInclApproxLBSVMFilter(ISeMReasoner reasoner, TheoremProver<PDDLExpression> prover, TextSimilarityMeasure inputSim, TextSimilarityMeasure outputSim, TextSimilarityMeasure descSim, File modelFile) throws NotSupportedException, IOException {
        List<Expression<ServiceView, Boolean>> lbFilters = ISeMFactory.createLogicBasedFilters(reasoner);
        Vector<CachedExpression<ServiceView, Boolean>> cachedLbFilters = new Vector<CachedExpression<ServiceView, Boolean>>();
        int i = 0;
        while (i < 4) {
            cachedLbFilters.add(new CachedExpression<ServiceView, Boolean>(lbFilters.get(i)));
            ++i;
        }
        CachedExpression logicalMatch = new CachedExpression(new Disjunction(new HashSet(cachedLbFilters)));
        Vector featureSpace = new Vector();
        for (Expression expression : cachedLbFilters) {
            featureSpace.add(new BooleanAsDouble(expression));
        }
        featureSpace.add(new BooleanAsDouble(new Negation(logicalMatch)));
        List<Expression<ServiceView, Double>> list = ISeMFactory.createApproxLogicBasedFilters(reasoner);
        featureSpace.add(new ConditionalExpression<ServiceView, Double>(logicalMatch, new FixedValue(1.0), list.get(0)));
        featureSpace.add(new ConditionalExpression<ServiceView, Double>(logicalMatch, new FixedValue(1.0), list.get(1)));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(inputSim), "inputDef"));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(outputSim), "outputDef"));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(descSim), "description"));
        if (prover != null) {
            featureSpace.add(new BooleanAsDouble<PDDLExpression>(ISeMFactory.createPreconditionFilter(prover)));
            featureSpace.add(new BooleanAsDouble<PDDLExpression>(ISeMFactory.createEffectFilter(prover)));
            featureSpace.add(new BooleanAsDouble<ServiceView>(new SpecificationAvailable("precondition")));
            featureSpace.add(new BooleanAsDouble<ServiceView>(new SpecificationAvailable("effect")));
        }
        featureSpace.add(ISeMFactory.createStructuralFilter(reasoner));
        return new SVMAggregation<ServiceView>(featureSpace, modelFile);
    }

    public static PruningSVMAggregation createHybridInclApproxLBPruningSVMFilter(ISeMReasoner reasoner, TheoremProver<PDDLExpression> prover, TextSimilarityMeasure inputSim, TextSimilarityMeasure outputSim, TextSimilarityMeasure descSim) throws NotSupportedException {
        List<Expression<ServiceView, Boolean>> lbFilters = ISeMFactory.createLogicBasedFilters(reasoner);
        Vector<CachedExpression<ServiceView, Boolean>> cachedLbFilters = new Vector<CachedExpression<ServiceView, Boolean>>();
        int i = 0;
        while (i < 4) {
            cachedLbFilters.add(new CachedExpression<ServiceView, Boolean>(lbFilters.get(i)));
            ++i;
        }
        CachedExpression logicalMatch = new CachedExpression(new Disjunction(new HashSet(cachedLbFilters)));
        Vector<Expression<ServiceView, Double>> featureSpace = new Vector<Expression<ServiceView, Double>>();
        for (Expression expression : cachedLbFilters) {
            featureSpace.add(new BooleanAsDouble(expression));
        }
        featureSpace.add(new BooleanAsDouble(new Negation(logicalMatch)));
        List<Expression<ServiceView, Double>> list = ISeMFactory.createApproxLogicBasedFilters(reasoner);
        featureSpace.add(new ConditionalExpression<ServiceView, Double>(logicalMatch, new FixedValue(1.0), list.get(0)));
        featureSpace.add(new ConditionalExpression<ServiceView, Double>(logicalMatch, new FixedValue(1.0), list.get(1)));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(inputSim), "inputDef"));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(outputSim), "outputDef"));
        featureSpace.add(new ServiceLevelLiteralsEvaluation(new Concatenation<Double>(descSim), "description"));
        if (prover != null) {
            featureSpace.add(new BooleanAsDouble<PDDLExpression>(ISeMFactory.createPreconditionFilter(prover)));
            featureSpace.add(new BooleanAsDouble<PDDLExpression>(ISeMFactory.createEffectFilter(prover)));
            featureSpace.add(new BooleanAsDouble<ServiceView>(new SpecificationAvailable("precondition")));
            featureSpace.add(new BooleanAsDouble<ServiceView>(new SpecificationAvailable("effect")));
        }
        featureSpace.add(ISeMFactory.createStructuralFilter(reasoner));
        return new PruningSVMAggregation(featureSpace);
    }

    public static MatchingSetup createHybridInclApproxLBSVMSetup(ISeMReasoner reasoner, TheoremProver<PDDLExpression> prover, TextSimilarityMeasure inputSim, TextSimilarityMeasure outputSim, TextSimilarityMeasure descSim) throws NotSupportedException {
        SVMAggregation<ServiceView> svmAggregation = ISeMFactory.createHybridInclApproxLBSVMFilter(reasoner, prover, inputSim, outputSim, descSim);
        RankDescending rankingOrder = new RankDescending(svmAggregation);
        HashSet<SVMAggregation<ServiceView>> filters = new HashSet<SVMAggregation<ServiceView>>();
        filters.add(svmAggregation);
        MatchingSetup setup = new MatchingSetup(hybridViewExtractor, filters, rankingOrder);
        return setup;
    }

    public static MatchingSetup createHybridInclApproxLBSVMSetup(ISeMReasoner reasoner, TheoremProver<PDDLExpression> prover, TextSimilarityMeasure inputSim, TextSimilarityMeasure outputSim, TextSimilarityMeasure descSim, File modelFile) throws NotSupportedException, IOException {
        SVMAggregation<ServiceView> svmAggregation = ISeMFactory.createHybridInclApproxLBSVMFilter(reasoner, prover, inputSim, outputSim, descSim, modelFile);
        RankDescending rankingOrder = new RankDescending(svmAggregation);
        HashSet<SVMAggregation<ServiceView>> filters = new HashSet<SVMAggregation<ServiceView>>();
        filters.add(svmAggregation);
        MatchingSetup setup = new MatchingSetup(hybridViewExtractor, filters, rankingOrder);
        return setup;
    }

    public static MatchingSetup createHybridInclApproxLBSVMSetupWithPruning(ISeMReasoner reasoner, TheoremProver<PDDLExpression> prover, TextSimilarityMeasure inputSim, TextSimilarityMeasure outputSim, TextSimilarityMeasure descSim) throws NotSupportedException {
        PruningSVMAggregation svmAggregation = ISeMFactory.createHybridInclApproxLBPruningSVMFilter(reasoner, prover, inputSim, outputSim, descSim);
        RankDescending rankingOrder = new RankDescending(svmAggregation);
        HashSet<PruningSVMAggregation> filters = new HashSet<PruningSVMAggregation>();
        filters.add(svmAggregation);
        MatchingSetup setup = new MatchingSetup(hybridViewExtractor, filters, rankingOrder);
        return setup;
    }

    public static ISeM createHybridInclApproxLBSVMMatcher(TrainingSet<URL> trainingSet, File outputFile, boolean matchPE) {
        MatchingSetup setup;
        LuceneMemoryIndex descIndex;
        LuceneMemoryIndex outputIndex;
        LuceneMemoryIndex inputIndex;
        OWLSRegistry registry = new OWLSRegistry();
        ISeMReasoner reasoner = new ISeMReasoner(registry, hybridViewExtractor);
        ThetaSubsumptionChecker prover = null;
        if (matchPE) {
            try {
                prover = new ThetaSubsumptionChecker();
            }
            catch (InferenceException e) {
                logger.error((Object)"Unable to initialize theta-subsumption checker. Matcher will be initialized without PE matching capability.", (Throwable)e);
                prover = null;
            }
        }
        try {
            inputIndex = new LuceneMemoryIndex();
            outputIndex = new LuceneMemoryIndex();
            descIndex = new LuceneMemoryIndex();
        }
        catch (IndexException e) {
            logger.error((Object)"Unable to create document index instance. Matcher has not been initialized.", (Throwable)e);
            return null;
        }
        registry.addEventHandler("processClasses", new ProcessClassesEventHandler(registry, reasoner, hybridViewExtractor), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_input", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)inputIndex, (ViewExtractor)hybridViewExtractor, "inputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_output", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)outputIndex, (ViewExtractor)hybridViewExtractor, "outputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_desc", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)descIndex, (ViewExtractor)hybridViewExtractor, "description"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("removeDoc_input", new RemoveFromIndexEventHandler(inputIndex), ServiceRegistry.Event.DEREGISTRATION);
        registry.addEventHandler("removeDoc_output", new RemoveFromIndexEventHandler(outputIndex), ServiceRegistry.Event.DEREGISTRATION);
        registry.addEventHandler("removeDoc_desc", new RemoveFromIndexEventHandler(descIndex), ServiceRegistry.Event.DEREGISTRATION);
        Cosine inputCosineMeasure = new Cosine(inputIndex);
        Cosine outputCosineMeasure = new Cosine(outputIndex);
        Cosine descCosineMeasure = new Cosine(descIndex);
        try {
            setup = ISeMFactory.createHybridInclApproxLBSVMSetup(reasoner, prover, inputCosineMeasure, outputCosineMeasure, descCosineMeasure);
        }
        catch (NotSupportedException e) {
            return null;
        }
        ISeM iSeM = new ISeM(registry, setup);
        try {
            TrainingSet<ServiceView> tmpTrainingSet = new TrainingSet<ServiceView>();
            for (Sample<URL> sample : trainingSet.getTrainingSet()) {
                URL requestUrl = sample.getRequestEntity();
                URL offerUrl = sample.getOfferEntity();
                try {
                    URI requestUri = registry.registerServices(requestUrl).iterator().next();
                    URI offerUri = registry.registerServices(offerUrl).iterator().next();
                    Sample<ServiceView> tmpSample = new Sample<ServiceView>(((ServiceRegistry)registry).getViewOnService(requestUri, hybridViewExtractor), ((ServiceRegistry)registry).getViewOnService(offerUri, hybridViewExtractor), sample.isRelevant());
                    tmpTrainingSet.addTrainingSample(tmpSample);
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to temporarly register sample service for SVM training.", (Throwable)e);
                }
                catch (ViewGenerationException e) {
                    logger.warn((Object)"Unable to extract sample service information for SVM training.", (Throwable)e);
                }
            }
            if (outputFile == null) {
                ((SVMAggregation)setup.getFeatureSpace().iterator().next()).train(tmpTrainingSet, 2.0, 0.25, 6, 0L);
            } else {
                ((SVMAggregation)setup.getFeatureSpace().iterator().next()).train(tmpTrainingSet, 2.0, 0.25, 6, 0L, outputFile);
            }
        }
        catch (SVMException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        catch (ExpressionEvaluationException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        reasoner.clearProbabilitiesCache();
        return iSeM;
    }

    public static ISeM createHybridInclApproxLBSVMMatcherWithPruning(TrainingSet<URL> trainingSet, File outputFile, boolean matchPE) {
        MatchingSetup setup;
        LuceneMemoryIndex descIndex;
        LuceneMemoryIndex outputIndex;
        LuceneMemoryIndex inputIndex;
        OWLSRegistry registry = new OWLSRegistry();
        ISeMReasoner reasoner = new ISeMReasoner(registry, hybridViewExtractor);
        ThetaSubsumptionChecker prover = null;
        if (matchPE) {
            try {
                prover = new ThetaSubsumptionChecker();
            }
            catch (InferenceException e) {
                logger.error((Object)"Unable to initialize theta-subsumption checker. Matcher will be initialized without PE matching capability.", (Throwable)e);
                prover = null;
            }
        }
        try {
            inputIndex = new LuceneMemoryIndex();
            outputIndex = new LuceneMemoryIndex();
            descIndex = new LuceneMemoryIndex();
        }
        catch (IndexException e) {
            logger.error((Object)"Unable to create document index instance. Matcher has not been initialized.", (Throwable)e);
            return null;
        }
        registry.addEventHandler("processClasses", new ProcessClassesEventHandler(registry, reasoner, hybridViewExtractor), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_input", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)inputIndex, (ViewExtractor)hybridViewExtractor, "inputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_output", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)outputIndex, (ViewExtractor)hybridViewExtractor, "outputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_desc", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)descIndex, (ViewExtractor)hybridViewExtractor, "description"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("removeDoc_input", new RemoveFromIndexEventHandler(inputIndex), ServiceRegistry.Event.DEREGISTRATION);
        registry.addEventHandler("removeDoc_output", new RemoveFromIndexEventHandler(outputIndex), ServiceRegistry.Event.DEREGISTRATION);
        registry.addEventHandler("removeDoc_desc", new RemoveFromIndexEventHandler(descIndex), ServiceRegistry.Event.DEREGISTRATION);
        Cosine inputCosineMeasure = new Cosine(inputIndex);
        Cosine outputCosineMeasure = new Cosine(outputIndex);
        Cosine descCosineMeasure = new Cosine(descIndex);
        try {
            setup = ISeMFactory.createHybridInclApproxLBSVMSetupWithPruning(reasoner, prover, inputCosineMeasure, outputCosineMeasure, descCosineMeasure);
        }
        catch (Exception e) {
            return null;
        }
        ISeM iSeM = new ISeM(registry, setup);
        try {
            TrainingSet<ServiceView> tmpTrainingSet = new TrainingSet<ServiceView>();
            for (Sample<URL> sample : trainingSet.getTrainingSet()) {
                URL requestUrl = sample.getRequestEntity();
                URL offerUrl = sample.getOfferEntity();
                try {
                    URI requestUri = registry.registerServices(requestUrl).iterator().next();
                    URI offerUri = registry.registerServices(offerUrl).iterator().next();
                    Sample<ServiceView> tmpSample = new Sample<ServiceView>(((ServiceRegistry)registry).getViewOnService(requestUri, hybridViewExtractor), ((ServiceRegistry)registry).getViewOnService(offerUri, hybridViewExtractor), sample.isRelevant());
                    tmpTrainingSet.addTrainingSample(tmpSample);
                }
                catch (IOException e) {
                    logger.warn((Object)"Unable to temporarly register sample service for SVM training.", (Throwable)e);
                }
                catch (ViewGenerationException e) {
                    logger.warn((Object)"Unable to extract sample service information for SVM training.", (Throwable)e);
                }
            }
            if (outputFile == null) {
                ((SVMAggregation)setup.getFeatureSpace().iterator().next()).train(tmpTrainingSet, 2.0, 0.25, 6, 0L);
            } else {
                ((SVMAggregation)setup.getFeatureSpace().iterator().next()).train(tmpTrainingSet, 2.0, 0.25, 6, 0L, outputFile);
            }
        }
        catch (SVMException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        catch (ExpressionEvaluationException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            logger.error((Object)"Error while training SVM.", (Throwable)e);
            return null;
        }
        reasoner.clearProbabilitiesCache();
        return iSeM;
    }

    public static ISeM createHybridInclApproxLBSVMMatcher(File modelFile, boolean matchPE) {
        MatchingSetup setup;
        LuceneMemoryIndex descIndex;
        LuceneMemoryIndex outputIndex;
        LuceneMemoryIndex inputIndex;
        OWLSRegistry registry = new OWLSRegistry();
        ISeMReasoner reasoner = new ISeMReasoner(registry, hybridViewExtractor);
        ThetaSubsumptionChecker prover = null;
        if (matchPE) {
            try {
                prover = new ThetaSubsumptionChecker();
            }
            catch (InferenceException e) {
                logger.error((Object)"Unable to initialize theta-subsumption checker. Matcher will be initialized without PE matching capability.", (Throwable)e);
                prover = null;
            }
        }
        try {
            inputIndex = new LuceneMemoryIndex();
            outputIndex = new LuceneMemoryIndex();
            descIndex = new LuceneMemoryIndex();
        }
        catch (IndexException e) {
            logger.error((Object)"Unable to create document index instance. Matcher has not been initialized.", (Throwable)e);
            return null;
        }
        registry.addEventHandler("processClasses", new ProcessClassesEventHandler(registry, reasoner, hybridViewExtractor), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_input", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)inputIndex, (ViewExtractor)hybridViewExtractor, "inputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_output", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)outputIndex, (ViewExtractor)hybridViewExtractor, "outputDef"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("addDoc_desc", new AddToIndexEventHandler((ServiceRegistry)registry, (Index)descIndex, (ViewExtractor)hybridViewExtractor, "description"), ServiceRegistry.Event.REGISTRATION);
        registry.addEventHandler("removeDoc_input", new RemoveFromIndexEventHandler(inputIndex), ServiceRegistry.Event.DEREGISTRATION);
        registry.addEventHandler("removeDoc_output", new RemoveFromIndexEventHandler(outputIndex), ServiceRegistry.Event.DEREGISTRATION);
        registry.addEventHandler("removeDoc_desc", new RemoveFromIndexEventHandler(descIndex), ServiceRegistry.Event.DEREGISTRATION);
        Cosine inputCosineMeasure = new Cosine(inputIndex);
        Cosine outputCosineMeasure = new Cosine(outputIndex);
        Cosine descCosineMeasure = new Cosine(descIndex);
        try {
            setup = ISeMFactory.createHybridInclApproxLBSVMSetup(reasoner, prover, inputCosineMeasure, outputCosineMeasure, descCosineMeasure, modelFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            return null;
        }
        ISeM iSeM = new ISeM(registry, setup);
        return iSeM;
    }
}

