/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem;

import de.dfki.isem.ApproximatedConceptSubsumption;
import de.dfki.isem.ISeMFactory;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import de.dfki.s2m2de.service.ConceptIdentifier;
import de.dfki.s2m2de.service.ServiceComponent;
import de.dfki.s2m2de.service.ServiceRegistry;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.ViewExtractor;
import de.dfki.s2m2de.service.ViewGenerationException;
import de.dfki.s2m2de.service.owls.OWLSRegistry;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.semanticweb.owl.inference.OWLReasonerAdapter;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.RemoveAxiom;
import org.semanticweb.owl.util.DLExpressivityChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.manchester.cs.owl.inference.dig11.DIGQueryResponse;
import uk.ac.manchester.cs.owl.inference.dig11.DIGReasoner;
import uk.ac.manchester.cs.owl.inference.dig11.DIGReasonerException;

public class ISeMReasoner
extends PelletReasoner {
    protected Logger logger = Logger.getLogger(ISeMReasoner.class);
    protected static final String TEMP_CLASS_URI = "http://www-ags.dfki.uni-sb.de/ISeM/LocalOntology#TempClass";
    protected static final String LOCAL_ALN_ONTOLOGY = "http://www-ags.dfki.uni-sb.de/ISeM/LocalOntologyALN";
    protected static final String TEMP_ONTOLOGY = "http://www-ags.dfki.uni-sb.de/ISeM/TempOntology";
    protected ServiceRegistry serviceRegistry;
    protected ViewExtractor viewExtractor;
    protected DIGReasoner mamasTng;
    protected ApproximatedConceptSubsumption approxSubsumption;
    protected OWLOntology alnOntology;
    protected HashMap<URI, Double> probabilities = new HashMap();
    protected double probabilityLowerBound = Double.MAX_VALUE;

    public ISeMReasoner(ServiceRegistry serviceRegistry, ViewExtractor viewExtractor) {
        this.serviceRegistry = serviceRegistry;
        this.viewExtractor = viewExtractor;
        try {
            this.mamasTng = new DIGReasoner(this.ontologyManager);
            this.mamasTng.getReasoner().setReasonerURL(URI.create("http://dee227.poliba.it:8080/MAMAS-tng/DIG").toURL());
            System.out.println(this.mamasTng.getReasoner().getIdentity().getSupportedAskElements());
            this.alnOntology = this.ontologyManager.createOntology(URI.create(LOCAL_ALN_ONTOLOGY));
            this.approxSubsumption = new ApproximatedConceptSubsumption(this);
        }
        catch (OWLException e) {
            this.logger.error((Object)"Unable to create local ALN ontology.", (Throwable)e);
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)"Invalid DIG HTTP address. Could not initialize reasoner.", (Throwable)e);
        }
    }

    @Override
    public List<OWLOntologyChange> processClass(OWLClass owlClass) {
        List<OWLOntologyChange> changes = super.processClass(owlClass);
        try {
            OWLOntology tempOntology = this.ontologyManager.createOntology(URI.create(TEMP_ONTOLOGY));
            for (OWLOntologyChange change : changes) {
                this.ontologyManager.addAxiom(tempOntology, change.getAxiom());
            }
            DLExpressivityChecker dlChecker = new DLExpressivityChecker(Collections.singleton(tempOntology));
            for (DLExpressivityChecker.Construct construct : dlChecker.getConstructs()) {
                if (construct.equals((Object)DLExpressivityChecker.Construct.AL) || construct.equals((Object)DLExpressivityChecker.Construct.N)) continue;
                return changes;
            }
            this.ontologyManager.removeOntology(URI.create(TEMP_ONTOLOGY));
            for (OWLOntologyChange change : changes) {
                this.ontologyManager.addAxiom(this.alnOntology, change.getAxiom());
            }
            this.mamasTng.loadOntologies(Collections.singleton(this.alnOntology));
            this.mamasTng.classify();
        }
        catch (OWLReasonerException e) {
            this.logger.warn((Object)("Unable to process class " + owlClass.getURI().toString() + " for MAMAS-tng."), (Throwable)e);
        }
        catch (OWLOntologyCreationException e) {
            this.logger.warn((Object)("Unable to process class " + owlClass.getURI().toString() + " for MAMAS-tng."), (Throwable)e);
        }
        catch (OWLOntologyChangeException e) {
            this.logger.warn((Object)("Unable to process class " + owlClass.getURI().toString() + " for MAMAS-tng."), (Throwable)e);
        }
        catch (OWLException e) {
            this.logger.warn((Object)("Unable to process class " + owlClass.getURI().toString() + " for MAMAS-tng."), (Throwable)e);
        }
        return changes;
    }

    protected OWLDescription contract(URI C, URI D) {
        if (!this.alnOntology.containsClassReference(C) || !this.alnOntology.containsClassReference(D)) {
            return this.owlFactory.getOWLClass(C);
        }
        try {
            Document request = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element asks = request.createElement("asks");
            asks.setAttribute("xmlns", "http://dl.kr.org/dig/2003/02/lang");
            asks.setAttribute("uri", this.mamasTng.getKbURI());
            request.appendChild(asks);
            Element contract = request.createElement("contract");
            contract.setAttribute("id", "q1");
            asks.appendChild(contract);
            Element CElem = request.createElement("catom");
            CElem.setAttribute("name", C.toString());
            contract.appendChild(CElem);
            Element DElem = request.createElement("catom");
            DElem.setAttribute("name", D.toString());
            contract.appendChild(DElem);
            Document response = this.mamasTng.getReasoner().performRequest(request);
            Iterator responseIter = this.mamasTng.getTranslator().getDIGQueryResponseIterator(this.owlFactory, response);
            return (OWLDescription)OWLReasonerAdapter.flattenSetOfSets((Set)((DIGQueryResponse)responseIter.next()).getConceptSets()).iterator().next();
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)("Unable to perform concept contraction for concepts " + C.toString() + " and " + D.toString() + "."), (Throwable)e);
            return null;
        }
        catch (DIGReasonerException e) {
            this.logger.error((Object)("Unable to perform concept contraction for concepts " + C.toString() + " and " + D.toString() + "."), (Throwable)e);
            return null;
        }
    }

    protected OWLDescription abduce(URI C, URI D) {
        if (!this.alnOntology.containsClassReference(C) || !this.alnOntology.containsClassReference(D)) {
            return this.owlFactory.getOWLClass(D);
        }
        try {
            Document request = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element asks = request.createElement("asks");
            asks.setAttribute("xmlns", "http://dl.kr.org/dig/2003/02/lang");
            asks.setAttribute("uri", this.mamasTng.getKbURI());
            request.appendChild(asks);
            Element abduce = request.createElement("abduce");
            abduce.setAttribute("id", "q2");
            asks.appendChild(abduce);
            Element KElem = request.createElement("catom");
            KElem.setAttribute("name", C.toString());
            abduce.appendChild(KElem);
            Element DElem = request.createElement("catom");
            DElem.setAttribute("name", D.toString());
            abduce.appendChild(DElem);
            Document response = this.mamasTng.getReasoner().performRequest(request);
            Iterator responseIter = this.mamasTng.getTranslator().getDIGQueryResponseIterator(this.owlFactory, response);
            OWLDescription H = (OWLDescription)OWLReasonerAdapter.flattenSetOfSets((Set)((DIGQueryResponse)responseIter.next()).getConceptSets()).iterator().next();
            return this.owlFactory.getOWLObjectIntersectionOf(new OWLDescription[]{this.owlFactory.getOWLClass(D), H});
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)("Unable to perform concept abduction for concepts " + C.toString() + " and " + D.toString() + "."), (Throwable)e);
            return null;
        }
        catch (DIGReasonerException e) {
            this.logger.error((Object)("Unable to perform concept abduction for concepts " + C.toString() + " and " + D.toString() + "."), (Throwable)e);
            return null;
        }
    }

    protected OWLDescription abduce(OWLDescription K, URI D) {
        if (!this.alnOntology.containsClassReference(D)) {
            return this.owlFactory.getOWLClass(D);
        }
        try {
            Document request = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element asks = request.createElement("asks");
            asks.setAttribute("xmlns", "http://dl.kr.org/dig/2003/02/lang");
            asks.setAttribute("uri", this.mamasTng.getKbURI());
            request.appendChild(asks);
            Element abduce = request.createElement("abduce");
            abduce.setAttribute("id", "q2");
            asks.appendChild(abduce);
            this.mamasTng.getTranslator().translateToDIG((OWLObject)K, request, (Node)abduce);
            Element DElem = request.createElement("catom");
            DElem.setAttribute("name", D.toString());
            abduce.appendChild(DElem);
            Document response = this.mamasTng.getReasoner().performRequest(request);
            Iterator responseIter = this.mamasTng.getTranslator().getDIGQueryResponseIterator(this.owlFactory, response);
            OWLDescription H = (OWLDescription)OWLReasonerAdapter.flattenSetOfSets((Set)((DIGQueryResponse)responseIter.next()).getConceptSets()).iterator().next();
            return this.owlFactory.getOWLObjectIntersectionOf(new OWLDescription[]{this.owlFactory.getOWLClass(D), H});
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)("Unable to perform concept abduction for concepts " + K.toString() + " and " + D.toString() + "."), (Throwable)e);
            return null;
        }
        catch (DIGReasonerException e) {
            this.logger.error((Object)("Unable to perform concept abduction for concepts " + K.toString() + " and " + D.toString() + "."), (Throwable)e);
            return null;
        }
    }

    protected double getProbability(URI C) {
        if (this.probabilities.containsKey(C)) {
            return this.probabilities.get(C);
        }
        HashMap<URI, Integer> parameterUsage = new HashMap<URI, Integer>();
        int parameterCount = 0;
        for (URI serviceUri : this.serviceRegistry.getRegisteredServices()) {
            try {
                Integer usage;
                ServiceView serviceView = this.serviceRegistry.getViewOnService(serviceUri, this.viewExtractor);
                Collection<ServiceComponent> inputs = serviceView.getComponents("input");
                Collection<ServiceComponent> outputs = serviceView.getComponents("output");
                for (ServiceComponent input : inputs) {
                    URI inputConceptUri = input.castTo(ConceptIdentifier.class).toURI();
                    if (parameterUsage.containsKey(inputConceptUri)) {
                        usage = (Integer)parameterUsage.get(inputConceptUri);
                        usage = usage + 1;
                        parameterUsage.put(inputConceptUri, usage);
                    } else {
                        parameterUsage.put(inputConceptUri, 1);
                    }
                    ++parameterCount;
                }
                for (ServiceComponent output : outputs) {
                    URI outputConceptUri = output.castTo(ConceptIdentifier.class).toURI();
                    if (parameterUsage.containsKey(outputConceptUri)) {
                        usage = (Integer)parameterUsage.get(outputConceptUri);
                        usage = usage + 1;
                        parameterUsage.put(outputConceptUri, usage);
                    } else {
                        parameterUsage.put(outputConceptUri, 1);
                    }
                    ++parameterCount;
                }
            }
            catch (ViewGenerationException e) {
                this.logger.warn((Object)("Unable to extract signature for " + serviceUri.toString() + ". Will be ignored for probability estimation."), (Throwable)e);
            }
        }
        if (parameterCount == 0) {
            return 0.0;
        }
        int sum = 0;
        for (URI D : parameterUsage.keySet()) {
            try {
                if (!this.conceptSubsumption.knowledgebaseEntails(C, D)) continue;
                sum += ((Integer)parameterUsage.get(D)).intValue();
            }
            catch (InferenceException e) {
                this.logger.warn((Object)("Error in probability estimation for concept " + C.toString() + ". Concept " + D.toString() + " could not be incorporated."));
            }
        }
        double prob = (double)sum / (double)parameterCount;
        this.probabilities.put(C, prob);
        return prob;
    }

    protected double getProbabilityLowerBound() {
        if (this.probabilityLowerBound == Double.MAX_VALUE) {
            for (URI classUri : this.processedClasses) {
                double prob = this.getProbability(classUri);
                if (!(prob < this.probabilityLowerBound) || !(prob > 0.0)) continue;
                this.probabilityLowerBound = prob;
            }
        }
        return this.probabilityLowerBound;
    }

    protected double getProbability(OWLDescription concept) {
        if (!concept.isAnonymous()) {
            return this.getProbability(concept.asOWLClass().getURI());
        }
        URI conceptUri = URI.create(TEMP_CLASS_URI);
        OWLEquivalentClassesAxiom tempAxiom = this.owlFactory.getOWLEquivalentClassesAxiom((OWLDescription)this.owlFactory.getOWLClass(conceptUri), concept);
        try {
            this.ontologyManager.addAxiom(this.localOntology, (OWLAxiom)tempAxiom);
        }
        catch (OWLOntologyChangeException e) {
            this.logger.error((Object)("Unable to compute probability for concept " + concept.toString() + ". Will be set to 0."), (Throwable)e);
            return 0.0;
        }
        double probability = this.getProbability(conceptUri);
        try {
            this.ontologyManager.applyChange((OWLOntologyChange)new RemoveAxiom(this.localOntology, (OWLAxiom)tempAxiom));
        }
        catch (OWLOntologyChangeException e) {
            this.logger.warn((Object)("Unable to remove temporary concept " + concept.toString() + " from local ALN matchmaker ontology. May cause wrong results for further probability computations."), (Throwable)e);
        }
        return probability;
    }

    protected Set<URI> getDirectCommonSubsumers(URI conceptUri1, OWLDescription concept2) throws InferenceException {
        if (!concept2.isAnonymous()) {
            return this.directCommonSubsumers.infer(conceptUri1, concept2.asOWLClass().getURI());
        }
        URI conceptUri2 = URI.create(TEMP_CLASS_URI);
        OWLEquivalentClassesAxiom tempAxiom = this.owlFactory.getOWLEquivalentClassesAxiom((OWLDescription)this.owlFactory.getOWLClass(conceptUri2), concept2);
        try {
            this.ontologyManager.addAxiom(this.localOntology, (OWLAxiom)tempAxiom);
        }
        catch (OWLOntologyChangeException e) {
            this.logger.error((Object)("Unable to compute direct common subsumers for " + conceptUri1.toString() + " and " + concept2.toString() + ". Returned owl#Thing instead."), (Throwable)e);
            return Collections.singleton(this.owlFactory.getOWLThing().getURI());
        }
        Set<URI> dcs = this.directCommonSubsumers.infer(conceptUri1, conceptUri2);
        try {
            this.ontologyManager.applyChange((OWLOntologyChange)new RemoveAxiom(this.localOntology, (OWLAxiom)tempAxiom));
        }
        catch (OWLOntologyChangeException e) {
            this.logger.warn((Object)("Unable to remove temporary concept " + concept2.toString() + " from local ALN matchmaker ontology. May cause wrong results for further probability computations."), (Throwable)e);
        }
        return dcs;
    }

    public ApproximatedConceptSubsumption getApproximatedConceptSubsumption() {
        return this.approxSubsumption;
    }

    public void clearProbabilitiesCache() {
        this.probabilities.clear();
    }

    public static void main(String[] args) {
        try {
            OWLSRegistry serviceRegistry = new OWLSRegistry();
            ISeMReasoner reasoner = new ISeMReasoner(serviceRegistry, ISeMFactory.getHybridViewExtractor());
            System.out.println("Process class 1...");
            reasoner.processClass(URI.create("http://127.0.0.1/ontology/books.owl#Novel"));
            System.out.println("Process class 2...");
            reasoner.processClass(URI.create("http://127.0.0.1/ontology/books.owl#Encyclopedia"));
            Set dcs = (Set)reasoner.getDirectCommonSubsumers().evaluate(URI.create("http://127.0.0.1/ontology/books.owl#Novel"), URI.create("http://127.0.0.1/ontology/books.owl#Encyclopedia"));
            System.out.println("Direct common subsumers:\n" + dcs);
            OWLDescription K = reasoner.contract(URI.create("http://127.0.0.1/ontology/books.owl#Novel"), URI.create("http://127.0.0.1/ontology/books.owl#Encyclopedia"));
            System.out.println("contract: " + K);
            OWLDescription Cprime = reasoner.abduce(K, URI.create("http://127.0.0.1/ontology/books.owl#Encyclopedia"));
            System.out.println("abduce: " + Cprime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

