/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem;

import de.dfki.s2m2de.service.ConceptIdentifier;
import de.dfki.s2m2de.service.PlainTextContent;
import de.dfki.s2m2de.service.ServiceComponent;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.ViewGenerationException;
import de.dfki.s2m2de.service.owls.OWLSExtractor;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAxiom;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

public class ParameterDefinitionExtractor
extends OWLSExtractor {
    public static final String INPUT_DEFINITION_TYPE = "inputDef";
    public static final String OUTPUT_DEFINITION_TYPE = "outputDef";
    protected OWLOntologyManager ontologyManager = OWLManager.createOWLOntologyManager();
    protected OWLDataFactory owlFactory = this.ontologyManager.getOWLDataFactory();

    @Override
    public ServiceView extract(URI serviceUri, URL documentUrl) throws ViewGenerationException {
        String conceptDefinition;
        ServiceView view = super.extract(serviceUri, documentUrl);
        for (ServiceComponent component : view.getComponents("input")) {
            conceptDefinition = this.processClass(((ConceptIdentifier)component).toURI());
            view.addComponent(INPUT_DEFINITION_TYPE, new PlainTextContent(INPUT_DEFINITION_TYPE, conceptDefinition));
        }
        for (ServiceComponent component : view.getComponents("output")) {
            conceptDefinition = this.processClass(((ConceptIdentifier)component).toURI());
            view.addComponent(OUTPUT_DEFINITION_TYPE, new PlainTextContent(OUTPUT_DEFINITION_TYPE, conceptDefinition));
        }
        return view;
    }

    private String processClass(URI classUri) {
        OWLClass owlClass = this.owlFactory.getOWLClass(classUri);
        return this.processClass(owlClass);
    }

    private String processClass(OWLClass owlClass) {
        try {
            OWLOntology onto = this.ontologyManager.loadOntologyFromPhysicalURI(this.removeFragment(owlClass.getURI()));
            return this.processClass(owlClass, onto, new HashSet<OWLEntity>());
        }
        catch (OWLOntologyCreationException e) {
            return owlClass.toString();
        }
    }

    private String processClass(OWLClass owlClass, OWLOntology ontology, Set<OWLEntity> processedItems) {
        if (processedItems.contains(owlClass)) {
            return "";
        }
        processedItems.add((OWLEntity)owlClass);
        Set definition = ontology.getAxioms(owlClass);
        String defString = "";
        for (OWLClassAxiom axiom : definition) {
            defString = String.valueOf(defString) + axiom.toString() + " ";
            Set owlClasses = axiom.getClassesInSignature();
            owlClasses.removeAll(processedItems);
            for (OWLClass otherOwlClass : owlClasses) {
                defString = String.valueOf(defString) + this.processClass(otherOwlClass, ontology, processedItems) + " ";
            }
            Set owlProperties = axiom.getObjectPropertiesInSignature();
            for (OWLObjectProperty owlProperty : owlProperties) {
                defString = String.valueOf(defString) + this.processObjectProperty(owlProperty, ontology, processedItems) + " ";
            }
            Set dataProperties = axiom.getDataPropertiesInSignature();
            for (OWLDataProperty dataProperty : dataProperties) {
                defString = String.valueOf(defString) + this.processDataProperty(dataProperty, ontology, processedItems) + " ";
            }
            Set owlIndividuals = axiom.getIndividualsInSignature();
            owlIndividuals.removeAll(processedItems);
            for (OWLIndividual owlIndividual : owlIndividuals) {
                defString = String.valueOf(defString) + this.processIndividual(owlIndividual, ontology, processedItems) + " ";
            }
        }
        return defString;
    }

    private String processObjectProperty(OWLObjectProperty owlProperty, OWLOntology ontology, Set<OWLEntity> processedItems) {
        if (processedItems.contains(owlProperty)) {
            return "";
        }
        processedItems.add((OWLEntity)owlProperty);
        Set definition = ontology.getAxioms((OWLObjectPropertyExpression)owlProperty);
        String defString = "";
        for (OWLObjectPropertyAxiom axiom : definition) {
            defString = String.valueOf(defString) + axiom.toString() + " ";
            Set owlClasses = axiom.getClassesInSignature();
            owlClasses.removeAll(processedItems);
            for (OWLClass otherOwlClass : owlClasses) {
                defString = String.valueOf(defString) + this.processClass(otherOwlClass, ontology, processedItems) + " ";
            }
            Set owlProperties = axiom.getObjectPropertiesInSignature();
            for (OWLObjectProperty otherOwlProperty : owlProperties) {
                defString = String.valueOf(defString) + this.processObjectProperty(otherOwlProperty, ontology, processedItems) + " ";
            }
            Set dataProperties = axiom.getDataPropertiesInSignature();
            for (OWLDataProperty dataProperty : dataProperties) {
                defString = String.valueOf(defString) + this.processDataProperty(dataProperty, ontology, processedItems) + " ";
            }
            Set owlIndividuals = axiom.getIndividualsInSignature();
            owlIndividuals.removeAll(processedItems);
            for (OWLIndividual owlIndividual : owlIndividuals) {
                defString = String.valueOf(defString) + this.processIndividual(owlIndividual, ontology, processedItems) + " ";
            }
        }
        return defString;
    }

    private String processDataProperty(OWLDataProperty owlProperty, OWLOntology ontology, Set<OWLEntity> processedItems) {
        if (processedItems.contains(owlProperty)) {
            return "";
        }
        processedItems.add((OWLEntity)owlProperty);
        Set definition = ontology.getAxioms(owlProperty);
        String defString = "";
        for (OWLDataPropertyAxiom axiom : definition) {
            defString = String.valueOf(defString) + axiom.toString() + " ";
            Set owlClasses = axiom.getClassesInSignature();
            owlClasses.removeAll(processedItems);
            for (OWLClass otherOwlClass : owlClasses) {
                defString = String.valueOf(defString) + this.processClass(otherOwlClass, ontology, processedItems) + " ";
            }
            Set owlProperties = axiom.getObjectPropertiesInSignature();
            for (OWLObjectProperty otherOwlProperty : owlProperties) {
                defString = String.valueOf(defString) + this.processObjectProperty(otherOwlProperty, ontology, processedItems) + " ";
            }
            Set dataProperties = axiom.getDataPropertiesInSignature();
            for (OWLDataProperty dataProperty : dataProperties) {
                defString = String.valueOf(defString) + this.processDataProperty(dataProperty, ontology, processedItems) + " ";
            }
            Set owlIndividuals = axiom.getIndividualsInSignature();
            owlIndividuals.removeAll(processedItems);
            for (OWLIndividual owlIndividual : owlIndividuals) {
                defString = String.valueOf(defString) + this.processIndividual(owlIndividual, ontology, processedItems) + " ";
            }
        }
        return defString;
    }

    private String processIndividual(OWLIndividual owlIndividual, OWLOntology ontology, Set<OWLEntity> processedItems) {
        if (processedItems.contains(owlIndividual)) {
            return "";
        }
        processedItems.add((OWLEntity)owlIndividual);
        Set definition = ontology.getAxioms(owlIndividual);
        String defString = "";
        for (OWLIndividualAxiom axiom : definition) {
            defString = String.valueOf(defString) + axiom.toString() + " ";
            Set owlClasses = axiom.getClassesInSignature();
            owlClasses.removeAll(processedItems);
            for (OWLClass otherOwlClass : owlClasses) {
                defString = String.valueOf(defString) + this.processClass(otherOwlClass, ontology, processedItems) + " ";
            }
            Set owlProperties = axiom.getObjectPropertiesInSignature();
            for (OWLObjectProperty owlProperty : owlProperties) {
                defString = String.valueOf(defString) + this.processObjectProperty(owlProperty, ontology, processedItems) + " ";
            }
            Set dataProperties = axiom.getDataPropertiesInSignature();
            for (OWLDataProperty dataProperty : dataProperties) {
                defString = String.valueOf(defString) + this.processDataProperty(dataProperty, ontology, processedItems) + " ";
            }
            Set owlIndividuals = axiom.getIndividualsInSignature();
            owlIndividuals.removeAll(processedItems);
            for (OWLIndividual otherOwlIndividual : owlIndividuals) {
                defString = String.valueOf(defString) + this.processIndividual(otherOwlIndividual, ontology, processedItems) + " ";
            }
        }
        return defString;
    }

    private final URI removeFragment(URI uri) {
        String uriString = uri.toString();
        uriString = uriString.substring(0, uriString.indexOf(35));
        return URI.create(uriString);
    }
}

