/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem;

import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import de.dfki.s2m2de.service.ConceptIdentifier;
import de.dfki.s2m2de.service.RegistryEventHandler;
import de.dfki.s2m2de.service.ServiceComponent;
import de.dfki.s2m2de.service.ServiceRegistry;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.ViewExtractor;
import de.dfki.s2m2de.service.ViewGenerationException;
import java.net.URI;

public class ProcessClassesEventHandler
implements RegistryEventHandler {
    protected ServiceRegistry registry;
    protected PelletReasoner pellet;
    protected ViewExtractor viewExtractor;

    public ProcessClassesEventHandler(ServiceRegistry registry, PelletReasoner pellet, ViewExtractor viewExtractor) {
        this.registry = registry;
        this.pellet = pellet;
        this.viewExtractor = viewExtractor;
    }

    @Override
    public void handle(URI serviceUri) {
        try {
            ServiceView serviceView = this.registry.getViewOnService(serviceUri, this.viewExtractor);
            for (ServiceComponent component : serviceView.getComponents("input")) {
                if (!component.hasCharacteristic(ConceptIdentifier.class)) continue;
                this.pellet.processClass(component.castTo(ConceptIdentifier.class).toURI());
            }
            for (ServiceComponent component : serviceView.getComponents("output")) {
                if (!component.hasCharacteristic(ConceptIdentifier.class)) continue;
                this.pellet.processClass(component.castTo(ConceptIdentifier.class).toURI());
            }
        }
        catch (ViewGenerationException e) {
            e.printStackTrace();
        }
    }
}

