/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem;

import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import de.dfki.s2m2de.expression.svm.ExpIncreasingDimension;
import de.dfki.s2m2de.expression.svm.ModelSearchSpace;
import de.dfki.s2m2de.expression.svm.SVMAggregation;
import de.dfki.s2m2de.expression.svm.SVMException;
import de.dfki.s2m2de.expression.svm.Sample;
import de.dfki.s2m2de.expression.svm.TrainingSet;
import de.dfki.s2m2de.expression.svm.libsvm.LibSVMParameters;
import de.dfki.s2m2de.service.ServiceView;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Vector;

public class PruningSVMAggregation
extends SVMAggregation<ServiceView> {
    public PruningSVMAggregation(Vector<Expression<ServiceView, Double>> featureSpace) {
        super(featureSpace);
    }

    public PruningSVMAggregation(Vector<Expression<ServiceView, Double>> featureSpace, File modelFile) throws IOException {
        super(featureSpace, modelFile);
    }

    @Override
    public void train(TrainingSet<ServiceView> trainingSet, double coarseGridStepSize, double fineGridStepSize, int folds, long seed) throws SVMException, ExpressionEvaluationException {
        HashSet<Sample<ServiceView>> toRemove = new HashSet<Sample<ServiceView>>();
        for (Sample<ServiceView> sample : trainingSet.getTrainingSet()) {
            try {
                Vector<Double> featureVec = new Vector<Double>();
                for (Expression featureDim : this.featureSpace) {
                    featureVec.add((Double)featureDim.evaluate(sample.getRequestEntity(), sample.getOfferEntity()));
                }
                sample.setFeatures(featureVec);
            }
            catch (ExpressionEvaluationException e) {
                System.err.println("Evaluation error. Ignored sample during training: " + sample.getRequestEntity().toString() + ", " + sample.getOfferEntity().toString() + ", " + sample.isRelevant());
                toRemove.add(sample);
            }
        }
        trainingSet.getTrainingSet().removeAll(toRemove);
        HashSet<Sample<ServiceView>> setNotEv = new HashSet<Sample<ServiceView>>();
        HashSet<Sample<ServiceView>> setE1H1 = new HashSet<Sample<ServiceView>>();
        HashSet<Sample<ServiceView>> setE1H2 = new HashSet<Sample<ServiceView>>();
        HashSet<Sample<ServiceView>> setE2H1 = new HashSet<Sample<ServiceView>>();
        HashSet<Sample<ServiceView>> setE2H2 = new HashSet<Sample<ServiceView>>();
        HashSet<Sample<ServiceView>> setE3H1 = new HashSet<Sample<ServiceView>>();
        HashSet<Sample<ServiceView>> setE3H2 = new HashSet<Sample<ServiceView>>();
        HashSet<Sample<ServiceView>> setE4H1 = new HashSet<Sample<ServiceView>>();
        HashSet<Sample<ServiceView>> setE4H2 = new HashSet<Sample<ServiceView>>();
        int sizeEv = 0;
        for (Sample<ServiceView> sample : trainingSet.getTrainingSet()) {
            if (sample.getFeatures().get(4) != 1.0) {
                setNotEv.add(sample);
                continue;
            }
            ++sizeEv;
            if (sample.isRelevant() && (sample.getFeatures().get(5) > 0.0 || sample.getFeatures().get(6) > 0.0)) {
                if (sample.getFeatures().get(5) >= sample.getFeatures().get(6)) {
                    setE1H1.add(sample);
                    continue;
                }
                setE1H2.add(sample);
                continue;
            }
            if (!sample.isRelevant() && sample.getFeatures().get(5) <= 0.0 && sample.getFeatures().get(6) <= 0.0) {
                if (sample.getFeatures().get(5) < sample.getFeatures().get(6)) {
                    setE2H1.add(sample);
                    continue;
                }
                setE2H2.add(sample);
                continue;
            }
            if (sample.isRelevant() && sample.getFeatures().get(5) <= 0.0 && sample.getFeatures().get(6) <= 0.0) {
                if (sample.getFeatures().get(5) < sample.getFeatures().get(6)) {
                    setE3H1.add(sample);
                    continue;
                }
                setE3H2.add(sample);
                continue;
            }
            if (sample.isRelevant() || !(sample.getFeatures().get(5) > 0.0) && !(sample.getFeatures().get(6) > 0.0)) continue;
            if (sample.getFeatures().get(5) >= sample.getFeatures().get(6)) {
                setE4H1.add(sample);
                continue;
            }
            setE4H2.add(sample);
        }
        double PEplus = (double)(setE1H1.size() + setE1H2.size() + setE3H1.size() + setE3H2.size()) / (double)sizeEv;
        double PEminus = (double)(setE2H1.size() + setE2H2.size() + setE4H1.size() + setE4H2.size()) / (double)sizeEv;
        double PH1plus = (double)(setE1H1.size() + setE4H1.size()) / (double)sizeEv;
        double PH2plus = (double)(setE1H2.size() + setE4H2.size()) / (double)sizeEv;
        double PH1minus = (double)(setE2H1.size() + setE3H1.size()) / (double)sizeEv;
        double PH2minus = (double)(setE2H2.size() + setE3H2.size()) / (double)sizeEv;
        double PH1plusEplus = (double)setE1H1.size() / (double)(setE1H1.size() + setE1H2.size() + setE3H1.size() + setE3H2.size());
        double PH2plusEplus = (double)setE1H2.size() / (double)(setE1H1.size() + setE1H2.size() + setE3H1.size() + setE3H2.size());
        double PH1minusEminus = (double)setE2H1.size() / (double)(setE2H1.size() + setE2H2.size() + setE4H1.size() + setE4H2.size());
        double PH2minusEminus = (double)setE2H2.size() / (double)(setE2H1.size() + setE2H2.size() + setE4H1.size() + setE4H2.size());
        double CoH1plusEplus = PEplus * PH1plusEplus / (PEplus + PH1plus - PEplus * PH1plusEplus);
        double CoH2plusEplus = PEplus * PH2plusEplus / (PEplus + PH2plus - PEplus * PH2plusEplus);
        double CoH1minusEminus = PEminus * PH1minusEminus / (PEminus + PH1minus - PEminus * PH1minusEminus);
        double CoH2minusEminus = PEminus * PH2minusEminus / (PEminus + PH2minus - PEminus * PH2minusEminus);
        System.out.println("|Ev| = " + sizeEv);
        System.out.println("|notEv| = " + setNotEv.size());
        System.out.println("|E1| = " + (setE1H1.size() + setE1H2.size()));
        System.out.println("|E2| = " + (setE2H1.size() + setE2H2.size()));
        System.out.println("|E3| = " + (setE3H1.size() + setE3H2.size()));
        System.out.println("|E4| = " + (setE4H1.size() + setE4H2.size()));
        System.out.println("Co(H1+,E+) = " + CoH1plusEplus);
        System.out.println("Co(H2+,E+) = " + CoH2plusEplus);
        System.out.println("Co(H1-,E-) = " + CoH1minusEminus);
        System.out.println("Co(H2-,E-) = " + CoH2minusEminus);
        HashSet finalSamples = new HashSet();
        finalSamples.addAll(setNotEv);
        for (Sample sample : setE1H1) {
            sample.getFeatures().set(4, 0.0);
            sample.getFeatures().set(5, CoH1plusEplus * sample.getFeatures().get(5));
            sample.getFeatures().set(6, 0.0);
            finalSamples.add(sample);
        }
        for (Sample sample : setE1H2) {
            sample.getFeatures().set(4, 0.0);
            sample.getFeatures().set(5, 0.0);
            sample.getFeatures().set(6, CoH2plusEplus * sample.getFeatures().get(6));
            finalSamples.add(sample);
        }
        for (Sample sample : setE2H1) {
            sample.getFeatures().set(5, CoH1minusEminus * sample.getFeatures().get(5));
            sample.getFeatures().set(6, 0.0);
            finalSamples.add(sample);
        }
        for (Sample sample : setE2H2) {
            sample.getFeatures().set(5, 0.0);
            sample.getFeatures().set(6, CoH2minusEminus * sample.getFeatures().get(6));
            finalSamples.add(sample);
        }
        for (Sample sample : setE4H1) {
            sample.getFeatures().set(5, (1.0 - CoH1plusEplus) * sample.getFeatures().get(5));
            sample.getFeatures().set(6, 0.0);
            finalSamples.add(sample);
        }
        for (Sample sample : setE4H2) {
            sample.getFeatures().set(5, 0.0);
            sample.getFeatures().set(6, (1.0 - CoH2plusEplus) * sample.getFeatures().get(6));
            finalSamples.add(sample);
        }
        trainingSet.setTrainingSet(finalSamples);
        ModelSearchSpace modelSearchSpace = new ModelSearchSpace(this.svmParameters);
        double cLowerBound = Math.pow(2.0, -5.0);
        double cUpperBound = Math.pow(2.0, 15.0);
        modelSearchSpace.addDimension(new ExpIncreasingDimension(LibSVMParameters.C, Double.toString(cLowerBound), Double.toString(cUpperBound), coarseGridStepSize));
        double gammaLowerBound = Math.pow(2.0, -15.0);
        double gammaUpperBound = Math.pow(2.0, 3.0);
        modelSearchSpace.addDimension(new ExpIncreasingDimension(LibSVMParameters.GAMMA, Double.toString(gammaLowerBound), Double.toString(gammaUpperBound), coarseGridStepSize));
        this.svmParameters = (LibSVMParameters)this.svm.searchModel(trainingSet, modelSearchSpace, folds, seed);
        ModelSearchSpace modelSearchSpace2 = new ModelSearchSpace(this.svmParameters);
        cLowerBound = Math.pow(2.0, Math.log(Double.parseDouble((String)this.svmParameters.get(LibSVMParameters.C))) / Math.log(2.0) - coarseGridStepSize + fineGridStepSize);
        cUpperBound = Math.pow(2.0, Math.log(Double.parseDouble((String)this.svmParameters.get(LibSVMParameters.C))) / Math.log(2.0) + coarseGridStepSize - fineGridStepSize);
        modelSearchSpace2.addDimension(new ExpIncreasingDimension(LibSVMParameters.C, Double.toString(cLowerBound), Double.toString(cUpperBound), fineGridStepSize));
        gammaLowerBound = Math.pow(2.0, Math.log(Double.parseDouble((String)this.svmParameters.get(LibSVMParameters.GAMMA))) / Math.log(2.0) - coarseGridStepSize + fineGridStepSize);
        gammaUpperBound = Math.pow(2.0, Math.log(Double.parseDouble((String)this.svmParameters.get(LibSVMParameters.GAMMA))) / Math.log(2.0) + coarseGridStepSize - fineGridStepSize);
        modelSearchSpace2.addDimension(new ExpIncreasingDimension(LibSVMParameters.GAMMA, Double.toString(gammaLowerBound), Double.toString(gammaUpperBound), fineGridStepSize));
        this.svmParameters = (LibSVMParameters)this.svm.searchModel(trainingSet, modelSearchSpace2, folds, seed);
        this.svm.train(trainingSet, this.svmParameters);
        this.trained = true;
    }

    @Override
    public void train(TrainingSet<ServiceView> trainingSet, double coarseGridStepSize, double fineGridStepSize, int folds, long seed, File outputFile) throws SVMException, ExpressionEvaluationException, IOException {
        this.train(trainingSet, coarseGridStepSize, fineGridStepSize, folds, seed);
        this.svm.saveTrainedModel(outputFile);
    }
}

