/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem.sme2;

import de.dfki.isem.ISeM;
import de.dfki.isem.ISeMFactory;
import de.dfki.s2m2de.MatchingResult;
import de.dfki.s2m2de.expression.svm.Sample;
import de.dfki.s2m2de.expression.svm.TrainingSet;
import de.dfki.sme2.IMatchmakerPlugin;
import de.dfki.sme2.TestCollection;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class ISeMHybridSVMPlugin
implements IMatchmakerPlugin {
    protected static final String TC_FILENAME = "testcollections/OWLS-TC4_PDDL/owls-tc4.xml";
    protected static final int SAMPLES = 2275;
    protected static final long SEED = 0L;
    private ISeM matchmaker;
    protected static final String MODEL_FILENAME = String.valueOf(ISeMHybridSVMPlugin.class.getSimpleName()) + "_model.xml";
    protected static final boolean NEW_MODEL = true;

    public ISeMHybridSVMPlugin() {
        try {
            TestCollection tc = TestCollection.parse((String)TC_FILENAME);
            Vector<Sample<URL>> relevantSamples = new Vector<Sample<URL>>();
            Vector<Sample<URL>> irrelevantSamples = new Vector<Sample<URL>>();
            for (URI query : tc.getQueries()) {
                for (URI offer : tc.getRelevanceSet(query).getBinaryRelevants()) {
                    relevantSamples.add(new Sample<URL>(query.toURL(), offer.toURL(), true));
                }
                for (URI offer : tc.getRelevanceSet(query).getBinaryIrrelevants()) {
                    irrelevantSamples.add(new Sample<URL>(query.toURL(), offer.toURL(), false));
                }
            }
            HashSet samples = new HashSet();
            Random rnd = new Random(0L);
            boolean nextRel = true;
            int i = 0;
            while (!(i >= 2275 || relevantSamples.isEmpty() && irrelevantSamples.isEmpty())) {
                int elem;
                if (nextRel && !relevantSamples.isEmpty()) {
                    elem = rnd.nextInt(relevantSamples.size());
                    samples.add((Sample)relevantSamples.remove(elem));
                    nextRel = false;
                } else {
                    if (irrelevantSamples.isEmpty()) break;
                    elem = rnd.nextInt(irrelevantSamples.size());
                    samples.add((Sample)irrelevantSamples.remove(elem));
                    nextRel = true;
                }
                ++i;
            }
            TrainingSet<URL> trainingSet = new TrainingSet<URL>(samples);
            System.out.println("Pulled " + samples.size() + " samples.");
            this.matchmaker = ISeMFactory.createHybridSVMMatcher(trainingSet, new File(MODEL_FILENAME), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void input(URL url) {
        try {
            this.matchmaker.getServiceRegistry().registerServices(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Hashtable<URL, Vector<URL>> query(URL url) {
        try {
            Vector<MatchingResult> ranking = this.matchmaker.match(url);
            Vector<URL> resultVec = new Vector<URL>();
            for (MatchingResult result : ranking) {
                resultVec.add(result.getOfferSource());
            }
            Hashtable<URL, Vector<URL>> output = new Hashtable<URL, Vector<URL>>();
            output.put(url, resultVec);
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Hashtable<URL, Vector<URL>>();
        }
    }

    public static void main(String[] args) {
        try {
            ISeMHybridSVMPlugin plugin = new ISeMHybridSVMPlugin();
            int i = 1;
            while (i < args.length) {
                plugin.input(new URL(args[i]));
                ++i;
            }
            URL request = new URL(args[0]);
            System.out.println(plugin.query(request));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

