/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.isem.sme2;

import de.dfki.isem.ISeM;
import de.dfki.isem.ISeMFactory;
import de.dfki.s2m2de.MatchingResult;
import de.dfki.sme2.IMatchmakerPlugin;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class ISeMStructuredTextSimCosPlugin
implements IMatchmakerPlugin {
    private ISeM matchmaker = ISeMFactory.createCosineTextSimMatcher();

    public void input(URL url) {
        try {
            this.matchmaker.getServiceRegistry().registerServices(url);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Hashtable<URL, Vector<URL>> query(URL url) {
        try {
            Vector<MatchingResult> ranking = this.matchmaker.match(url);
            Vector<URL> resultVec = new Vector<URL>();
            for (MatchingResult result : ranking) {
                resultVec.add(result.getOfferSource());
            }
            Hashtable<URL, Vector<URL>> output = new Hashtable<URL, Vector<URL>>();
            output.put(url, resultVec);
            return output;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Hashtable<URL, Vector<URL>>();
        }
    }

    public static void main(String[] args) {
        try {
            ISeMStructuredTextSimCosPlugin plugin = new ISeMStructuredTextSimCosPlugin();
            int i = 1;
            while (i < args.length) {
                plugin.input(new URL(args[i]));
                ++i;
            }
            URL request = new URL(args[0]);
            System.out.println(plugin.query(request));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

