/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de;

import de.dfki.s2m2de.MatchingException;
import de.dfki.s2m2de.MatchingResult;
import de.dfki.s2m2de.MatchingSetup;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import de.dfki.s2m2de.ranking.RankingOrder;
import de.dfki.s2m2de.service.ServiceRegistry;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.ViewExtractor;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.Vector;

public class MatchingEngine {
    protected ServiceRegistry serviceRegistry = null;
    protected Set<? extends Expression<ServiceView, ?>> featureSpace = null;
    protected RankingOrder rankingOrder = null;
    protected ViewExtractor viewExtractor = null;
    private ServiceRegistry requestRegistry = null;

    protected MatchingEngine() {
    }

    public MatchingEngine(ServiceRegistry serviceRegistry, MatchingSetup setup) {
        this.serviceRegistry = serviceRegistry;
        this.featureSpace = setup.getFeatureSpace();
        this.rankingOrder = setup.getRankingOrder();
        this.viewExtractor = setup.getViewExtractor();
        try {
            this.requestRegistry = (ServiceRegistry)serviceRegistry.getClass().newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public Vector<MatchingResult> match(URL requestDocument) throws MatchingException {
        Set<URI> serviceOffers = this.serviceRegistry.getRegisteredServices();
        try {
            Set<URI> serviceRequests = this.requestRegistry.registerServices(requestDocument);
            Vector<MatchingResult> resultRanking = new Vector<MatchingResult>();
            for (URI request : serviceRequests) {
                for (URI offer : serviceOffers) {
                    MatchingResult matchingResult = new MatchingResult(request, requestDocument, offer, this.serviceRegistry.getSource(offer));
                    try {
                        ServiceView requestView = this.requestRegistry.getViewOnService(request, this.viewExtractor);
                        ServiceView offerView = this.serviceRegistry.getViewOnService(offer, this.viewExtractor);
                        for (Expression<ServiceView, ?> expression : this.featureSpace) {
                            matchingResult.addFeature(expression, expression.evaluate(requestView, offerView));
                        }
                    }
                    catch (ExpressionEvaluationException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    resultRanking.add(matchingResult);
                }
            }
            for (URI serviceUri : serviceRequests) {
                this.requestRegistry.deregisterService(serviceUri);
            }
            Collections.sort(resultRanking, this.rankingOrder);
            return resultRanking;
        }
        catch (IOException e) {
            throw new MatchingException("Unable to parse request document", e);
        }
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

