/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BooleanAsDouble<Domain>
extends AbstractExpression<Domain, Double> {
    protected Expression<Domain, Boolean> booleanExpression;
    protected Double trueValue;
    protected Double falseValue;

    public BooleanAsDouble(Expression<Domain, Boolean> booleanExpression) {
        this.booleanExpression = booleanExpression;
        this.trueValue = new Double(1.0);
        this.falseValue = new Double(0.0);
    }

    public BooleanAsDouble(Expression<Domain, Boolean> booleanExpression, double trueValue, double falseValue) {
        this.booleanExpression = booleanExpression;
        this.trueValue = new Double(trueValue);
        this.falseValue = new Double(falseValue);
    }

    public BooleanAsDouble(Expression<Domain, Boolean> booleanExpression, Double trueValue, Double falseValue) {
        this.booleanExpression = booleanExpression;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    @Override
    public Double evaluate(Domain entity1, Domain entity2) throws ExpressionEvaluationException {
        if (this.booleanExpression.evaluate(entity1, entity2).booleanValue()) {
            return this.trueValue;
        }
        return this.falseValue;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element asDoubleElem = targetDoc.createElement("asdouble");
        parentElem.appendChild(asDoubleElem);
        if (this.trueValue != 1.0) {
            asDoubleElem.setAttribute("true", this.trueValue.toString());
        }
        if (this.falseValue != 0.0) {
            asDoubleElem.setAttribute("false", this.falseValue.toString());
        }
        this.booleanExpression.decompile(targetDoc, asDoubleElem);
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        Vector result = new Vector();
        result.add(this.booleanExpression);
        return result;
    }

    @Override
    public String getName() {
        String name = super.getName();
        name = String.valueOf(name) + "(true->" + this.trueValue + ", false->" + this.falseValue + ")";
        return name;
    }
}

