/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CachedExpression<Domain extends Comparable<Domain>, Range>
extends AbstractExpression<Domain, Range> {
    private static final String ID_PREFIX = "exp";
    private static int nextId = 0;
    private String id;
    protected Expression<Domain, Range> wrappedExpression;
    protected Range lastValue = null;
    protected Domain lastEntity1 = null;
    protected Domain lastEntity2 = null;

    public CachedExpression(Expression<Domain, Range> wrappedExpression) {
        this.wrappedExpression = wrappedExpression;
        this.id = ID_PREFIX + nextId++;
    }

    @Override
    public Range evaluate(Domain entity1, Domain entity2) throws ExpressionEvaluationException {
        if (entity1.compareTo(this.lastEntity1) == 0 && entity2.compareTo(this.lastEntity2) == 0) {
            return this.lastValue;
        }
        this.lastEntity1 = entity1;
        this.lastEntity2 = entity2;
        this.lastValue = this.wrappedExpression.evaluate(entity1, entity2);
        return this.lastValue;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element cachedElem = targetDoc.createElement("cached");
        parentElem.appendChild(cachedElem);
        if (targetDoc.getElementById(this.id.toString()) == null) {
            this.wrappedExpression.decompile(targetDoc, cachedElem);
            cachedElem.setAttribute("id", this.id);
            cachedElem.setIdAttribute("id", true);
        } else {
            Attr idref = targetDoc.createAttribute("expression");
            idref.setValue(this.id);
            cachedElem.setAttributeNode(idref);
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        Vector result = new Vector();
        result.add(this.wrappedExpression);
        return result;
    }
}

