/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Disjunction<Domain>
extends AbstractExpression<Domain, Boolean> {
    protected Set<Expression<Domain, Boolean>> basicExpressions;

    public Disjunction(Expression<Domain, Boolean> expression1, Expression<Domain, Boolean> expression2) {
        this.basicExpressions = new HashSet<Expression<Domain, Boolean>>();
        this.basicExpressions.add(expression1);
        this.basicExpressions.add(expression2);
    }

    public Disjunction(Set<Expression<Domain, Boolean>> basicExpressions) {
        this.basicExpressions = basicExpressions;
    }

    @Override
    public Boolean evaluate(Domain firstEntity, Domain secondEntity) throws ExpressionEvaluationException {
        for (Expression<Domain, Boolean> expression : this.basicExpressions) {
            if (!expression.evaluate(firstEntity, secondEntity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element andElem = targetDoc.createElement("and");
        parentElem.appendChild(andElem);
        for (Expression<Domain, Boolean> exp : this.basicExpressions) {
            exp.decompile(targetDoc, andElem);
        }
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        return new Vector(this.basicExpressions);
    }
}

