/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ForallExists<Domain>
extends AbstractExpression<Collection<Domain>, Boolean> {
    protected Expression<Domain, Boolean> basicExpression;

    public ForallExists(Expression<Domain, Boolean> basicExpression) {
        this.basicExpression = basicExpression;
    }

    @Override
    public Boolean evaluate(Collection<Domain> entities1, Collection<Domain> entities2) throws ExpressionEvaluationException {
        for (Domain entity1 : entities1) {
            boolean exists = false;
            for (Domain entity2 : entities2) {
                if (!this.basicExpression.evaluate(entity1, entity2).booleanValue()) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            return false;
        }
        return true;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element forallExistsElem = targetDoc.createElement("forallexists");
        parentElem.appendChild(forallExistsElem);
        this.basicExpression.decompile(targetDoc, forallExistsElem);
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        Vector result = new Vector();
        result.add(this.basicExpression);
        return result;
    }
}

