/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GreaterEquals<Domain>
extends AbstractExpression<Domain, Boolean> {
    protected Expression<Domain, Double> leftExpression;
    protected Expression<Domain, Double> rightExpression;

    public GreaterEquals(Expression<Domain, Double> leftExpression, Expression<Domain, Double> rightExpression) {
        this.leftExpression = leftExpression;
        this.rightExpression = rightExpression;
    }

    @Override
    public Boolean evaluate(Domain entity1, Domain entity2) throws ExpressionEvaluationException {
        if (this.leftExpression.evaluate(entity1, entity2) >= this.rightExpression.evaluate(entity1, entity2)) {
            return true;
        }
        return false;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element geqElem = targetDoc.createElement("greaterequals");
        parentElem.appendChild(geqElem);
        this.leftExpression.decompile(targetDoc, geqElem);
        this.rightExpression.decompile(targetDoc, geqElem);
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        Vector result = new Vector();
        result.add(this.leftExpression);
        result.add(this.rightExpression);
        return result;
    }
}

