/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Maximum<Domain>
extends AbstractExpression<Domain, Double> {
    protected Set<Expression<Domain, Double>> basicExpressions;

    public Maximum(Expression<Domain, Double> expression1, Expression<Domain, Double> expression2) {
        this.basicExpressions = new HashSet<Expression<Domain, Double>>();
        this.basicExpressions.add(expression1);
        this.basicExpressions.add(expression2);
    }

    public Maximum(Set<Expression<Domain, Double>> basicExpressions) throws ExpressionEvaluationException {
        if (basicExpressions == null || basicExpressions.isEmpty()) {
            throw new ExpressionEvaluationException("Maximum operator must not be initialized with zero basic operators.");
        }
        this.basicExpressions = basicExpressions;
    }

    @Override
    public Double evaluate(Domain firstEntity, Domain secondEntity) throws ExpressionEvaluationException {
        double max = -1.0;
        for (Expression<Domain, Double> exp : this.basicExpressions) {
            double val = exp.evaluate(firstEntity, secondEntity);
            if (!(val > max)) continue;
            max = val;
        }
        return max;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element maximumElem = targetDoc.createElement("maximum");
        parentElem.appendChild(maximumElem);
        for (Expression<Domain, Double> exp : this.basicExpressions) {
            exp.decompile(targetDoc, maximumElem);
        }
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        return new Vector(this.basicExpressions);
    }
}

