/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression;

import de.dfki.s2m2de.expression.CollectionExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.service.ConceptIdentifier;
import de.dfki.s2m2de.service.ServiceComponent;
import de.dfki.s2m2de.service.ServiceView;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceLevelConceptsEvaluation<Range>
extends CollectionExpression<URI, ServiceView, Range> {
    protected String conceptsType;

    public ServiceLevelConceptsEvaluation(Expression<Collection<URI>, Range> basicExpression, String conceptsType) {
        super(basicExpression);
        this.conceptsType = conceptsType;
    }

    @Override
    protected Collection<URI> getEntities(ServiceView upperEntity) throws ClassCastException {
        Collection<ServiceComponent> concepts = upperEntity.getComponents(this.conceptsType);
        LinkedList<URI> resultSet = new LinkedList<URI>();
        for (ServiceComponent concept : concepts) {
            resultSet.add(((ConceptIdentifier)concept).toURI());
        }
        return resultSet;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element conceptsElem = targetDoc.createElement("concepts");
        parentElem.appendChild(conceptsElem);
        conceptsElem.setAttribute("type", this.conceptsType);
        this.basicExpression.decompile(targetDoc, conceptsElem);
    }

    @Override
    protected String getFocus() {
        return String.valueOf(this.conceptsType) + "URI";
    }
}

