/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression;

import de.dfki.s2m2de.expression.CollectionExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.service.PlainTextContent;
import de.dfki.s2m2de.service.ServiceComponent;
import de.dfki.s2m2de.service.ServiceView;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceLevelLiteralsEvaluation<Range>
extends CollectionExpression<String, ServiceView, Range> {
    protected Set<String> conceptsTypes;

    public ServiceLevelLiteralsEvaluation(Expression<Collection<String>, Range> basicExpression, String conceptsType) {
        super(basicExpression);
        this.conceptsTypes = new HashSet<String>();
        this.conceptsTypes.add(conceptsType);
    }

    public ServiceLevelLiteralsEvaluation(Expression<Collection<String>, Range> basicExpression, Set<String> conceptsTypes) {
        super(basicExpression);
        this.conceptsTypes = conceptsTypes;
    }

    @Override
    protected Collection<String> getEntities(ServiceView upperEntity) throws ClassCastException {
        LinkedList<ServiceComponent> concepts = new LinkedList<ServiceComponent>();
        for (String conceptsType : this.conceptsTypes) {
            concepts.addAll(upperEntity.getComponents(conceptsType));
        }
        LinkedList<String> resultSet = new LinkedList<String>();
        for (ServiceComponent concept : concepts) {
            resultSet.add(((PlainTextContent)concept).toString());
        }
        return resultSet;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element literalsElem = targetDoc.createElement("literals");
        parentElem.appendChild(literalsElem);
        Iterator<String> typeIter = this.conceptsTypes.iterator();
        String types = typeIter.next();
        while (typeIter.hasNext()) {
            types = String.valueOf(types) + " " + typeIter.next();
        }
        literalsElem.setAttribute("type", types);
        this.basicExpression.decompile(targetDoc, literalsElem);
    }

    @Override
    protected String getFocus() {
        return String.valueOf(this.conceptsTypes.toString()) + "String";
    }
}

