/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import de.dfki.s2m2de.service.ServiceComponent;
import de.dfki.s2m2de.service.ServiceView;
import de.dfki.s2m2de.service.Specification;
import de.dfki.s2m2de.service.SpecificationExpression;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpecificationEvaluation<Focus extends SpecificationExpression, Range>
extends AbstractExpression<ServiceView, Range> {
    protected Expression<Focus, Range> basicExpression;
    protected String componentType;

    public SpecificationEvaluation(Expression<Focus, Range> basicExpression, String componentType) {
        this.basicExpression = basicExpression;
        this.componentType = componentType;
    }

    @Override
    public Range evaluate(ServiceView entity1, ServiceView entity2) throws ExpressionEvaluationException {
        Collection<ServiceComponent> components1 = entity1.getComponents(this.componentType);
        Collection<ServiceComponent> components2 = entity2.getComponents(this.componentType);
        Object expression1 = null;
        Object expression2 = null;
        try {
            expression1 = components1.isEmpty() ? null : (Object)((Specification)components1.iterator().next()).getExpression();
        }
        catch (ClassCastException e) {
            throw new ExpressionEvaluationException("Unable to extract \"" + this.componentType + "\" condition expression in " + entity1.getServiceUri() + ".", e);
        }
        try {
            expression2 = components2.isEmpty() ? null : (Object)((Specification)components2.iterator().next()).getExpression();
        }
        catch (ClassCastException e) {
            throw new ExpressionEvaluationException("Unable to extract \"" + this.componentType + "\" condition expression in " + entity2.getServiceUri() + ".", e);
        }
        return this.basicExpression.evaluate(expression1, expression2);
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        Vector result = new Vector();
        result.add(this.basicExpression);
        return result;
    }

    @Override
    public String getName() {
        String name = super.getName();
        return String.valueOf(name) + "(" + this.componentType + ")";
    }
}

