/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression.bpg;

import de.dfki.s2m2de.expression.bpg.pair;

public final class BestAssignmentSolver {
    double[][] cost;
    int numCol;
    int numRow;
    private static byte NOT_MARKED = 0;
    private static byte STARRED_ZERO = 1;
    private static byte PRIMED_ZERO = (byte)2;

    public static void main(String[] param) {
        double[][] test = new double[][]{{2.0, 5.0}, {3.0, 1.0}, {6.0, 3.0}};
        byte[][] solution = new BestAssignmentSolver(test).munkres();
        int i = 0;
        while (i < solution.length) {
            int j = 0;
            while (j < solution[i].length) {
                System.out.print(String.valueOf(solution[i][j]) + " ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public BestAssignmentSolver(double[][] cost) {
        this.numCol = cost[0].length;
        this.numRow = cost.length;
        if (this.numRow > this.numCol) {
            throw new IllegalArgumentException("Expecting more rows than columns");
        }
        this.cost = cost;
    }

    public byte[][] munkres() {
        munkres m = new munkres();
        return m.solve();
    }

    public int[] solve() {
        byte[][] marks = this.munkres();
        int[] matchedRows = new int[marks.length];
        int i = 0;
        while (i < marks.length) {
            int j = 0;
            while (j < marks[i].length) {
                if (marks[i][j] == 1) {
                    matchedRows[i] = j;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return matchedRows;
    }

    public class munkres {
        byte[][] mark;
        int[] rowIsCovered;
        int[] colIsCovered;

        public byte[][] solve() {
            this.mark = new byte[BestAssignmentSolver.this.numRow][];
            int i = 0;
            while (i < BestAssignmentSolver.this.numRow) {
                this.mark[i] = new byte[BestAssignmentSolver.this.numCol];
                ++i;
            }
            this.rowIsCovered = new int[BestAssignmentSolver.this.numRow];
            this.colIsCovered = new int[BestAssignmentSolver.this.numCol];
            this.reduceRows();
            this.starSomeZeros();
            while (!this.isDone()) {
                pair p = this.findAndPrimeUncoveredZero();
                new step5().main(p);
            }
            return this.mark;
        }

        public void reduceRows() {
            int i = 0;
            while (i < BestAssignmentSolver.this.numRow) {
                double minval = BestAssignmentSolver.this.cost[i][0];
                int j = 1;
                while (j < BestAssignmentSolver.this.numCol) {
                    if (minval > BestAssignmentSolver.this.cost[i][j]) {
                        minval = BestAssignmentSolver.this.cost[i][j];
                    }
                    ++j;
                }
                j = 0;
                while (j < BestAssignmentSolver.this.numCol) {
                    double[] dArray = BestAssignmentSolver.this.cost[i];
                    int n = j++;
                    dArray[n] = dArray[n] - minval;
                }
                ++i;
            }
        }

        public void starSomeZeros() {
            boolean[] colIsCovered = new boolean[BestAssignmentSolver.this.numCol];
            int i = 0;
            while (i < BestAssignmentSolver.this.numRow) {
                int j = 0;
                while (j < BestAssignmentSolver.this.numCol) {
                    if (!colIsCovered[j] && BestAssignmentSolver.this.cost[i][j] == 0.0) {
                        this.mark[i][j] = STARRED_ZERO;
                        colIsCovered[j] = true;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public boolean isDone() {
            int count = 0;
            int j = 0;
            while (j < BestAssignmentSolver.this.numCol) {
                int i = 0;
                while (i < BestAssignmentSolver.this.numRow) {
                    if (this.mark[i][j] == STARRED_ZERO) {
                        this.colIsCovered[j] = 1;
                        ++count;
                        break;
                    }
                    ++i;
                }
                ++j;
            }
            return count >= BestAssignmentSolver.this.numRow;
        }

        public pair findAndPrimeUncoveredZero() {
            pair p;
            block0: while (true) {
                if ((p = this.findUncoveredZero()) == null) {
                    this.makeSomeZeros();
                    continue;
                }
                this.mark[p.row][p.col] = PRIMED_ZERO;
                int j = 0;
                while (j < BestAssignmentSolver.this.numCol) {
                    if (this.mark[p.row][j] == STARRED_ZERO) {
                        this.rowIsCovered[p.row] = 1;
                        this.colIsCovered[j] = 0;
                        continue block0;
                    }
                    ++j;
                }
                break;
            }
            return p;
        }

        public pair findUncoveredZero() {
            int i = 0;
            while (i < BestAssignmentSolver.this.numRow) {
                int j = 0;
                while (j < BestAssignmentSolver.this.numCol) {
                    if (BestAssignmentSolver.this.cost[i][j] == 0.0 && this.rowIsCovered[i] == 0 && this.colIsCovered[j] == 0) {
                        return new pair(i, j);
                    }
                    ++j;
                }
                ++i;
            }
            return null;
        }

        public void makeSomeZeros() {
            int j;
            double minval = 3.4028234663852886E38;
            int i = 0;
            while (i < BestAssignmentSolver.this.numRow) {
                if (this.rowIsCovered[i] != 1) {
                    j = 0;
                    while (j < BestAssignmentSolver.this.numCol) {
                        if (this.colIsCovered[j] == 0 && minval > BestAssignmentSolver.this.cost[i][j]) {
                            minval = BestAssignmentSolver.this.cost[i][j];
                        }
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < BestAssignmentSolver.this.numRow) {
                j = 0;
                while (j < BestAssignmentSolver.this.numCol) {
                    if (this.rowIsCovered[i] == 1) {
                        double[] dArray = BestAssignmentSolver.this.cost[i];
                        int n = j;
                        dArray[n] = dArray[n] + minval;
                    }
                    if (this.colIsCovered[j] == 0) {
                        double[] dArray = BestAssignmentSolver.this.cost[i];
                        int n = j;
                        dArray[n] = dArray[n] - minval;
                    }
                    ++j;
                }
                ++i;
            }
        }

        public String toString() {
            StringBuffer output = new StringBuffer();
            int j = 0;
            while (j < BestAssignmentSolver.this.numCol) {
                output.append("\t").append(this.colIsCovered[j]);
                ++j;
            }
            output.append("\n");
            int i = 0;
            while (i < BestAssignmentSolver.this.numRow) {
                output.append(this.rowIsCovered[i]);
                int j2 = 0;
                while (j2 < BestAssignmentSolver.this.numCol) {
                    output.append("\t").append(BestAssignmentSolver.this.cost[i][j2]);
                    if (this.mark[i][j2] == STARRED_ZERO) {
                        output.append("*");
                    } else if (this.mark[i][j2] == PRIMED_ZERO) {
                        output.append("'");
                    }
                    ++j2;
                }
                output.append("\n");
                ++i;
            }
            return output.toString();
        }

        class step5 {
            pair[] path;

            step5() {
                this.path = new pair[((munkres)munkres.this).BestAssignmentSolver.this.numRow * 2];
            }

            public int find_star_in_col(int c) {
                int i = 0;
                while (i < ((munkres)munkres.this).BestAssignmentSolver.this.numRow) {
                    if (munkres.this.mark[i][c] == STARRED_ZERO) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            public int find_prime_in_row(int r) {
                int j = 0;
                while (j < ((munkres)munkres.this).BestAssignmentSolver.this.numCol) {
                    if (munkres.this.mark[r][j] == PRIMED_ZERO) {
                        return j;
                    }
                    ++j;
                }
                return -1;
            }

            public void clear_covers() {
                int i = 0;
                while (i < ((munkres)munkres.this).BestAssignmentSolver.this.numRow) {
                    munkres.this.rowIsCovered[i] = 0;
                    munkres.this.colIsCovered[i] = 0;
                    ++i;
                }
            }

            public void clear_primes() {
                int i = 0;
                while (i < ((munkres)munkres.this).BestAssignmentSolver.this.numRow) {
                    int j = 0;
                    while (j < ((munkres)munkres.this).BestAssignmentSolver.this.numCol) {
                        if (munkres.this.mark[i][j] == PRIMED_ZERO) {
                            munkres.this.mark[i][j] = NOT_MARKED;
                        }
                        ++j;
                    }
                    ++i;
                }
            }

            public void main(pair p) {
                int r;
                int count = 0;
                this.path[count] = p;
                while ((r = this.find_star_in_col(this.path[count].col)) != -1) {
                    this.path[++count] = new pair(r, this.path[count - 1].col);
                    int c = this.find_prime_in_row(this.path[count].row);
                    this.path[++count] = new pair(this.path[count - 1].row, c);
                }
                int i = 0;
                while (i <= count) {
                    munkres.this.mark[this.path[i].row][this.path[i].col] = munkres.this.mark[this.path[i].row][this.path[i].col] == STARRED_ZERO ? NOT_MARKED : STARRED_ZERO;
                    ++i;
                }
                this.clear_covers();
                this.clear_primes();
            }
        }
    }
}

