/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression.bpg;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import de.dfki.s2m2de.expression.bpg.BestAssignmentSolver;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BipartiteGraphMatching<Domain>
extends AbstractExpression<Collection<Domain>, Double> {
    public static Double NO_MATCH = Double.MIN_VALUE;
    protected Expression<Domain, Double> basicExpression;

    public BipartiteGraphMatching(Expression<Domain, Double> basicExpression) {
        this.basicExpression = basicExpression;
    }

    @Override
    public Double evaluate(Collection<Domain> entities1, Collection<Domain> entities2) throws ExpressionEvaluationException {
        if (entities1.isEmpty()) {
            return 1.0;
        }
        if (entities2.size() < entities1.size()) {
            return NO_MATCH;
        }
        double[][] valueMatrix = new double[entities1.size()][entities2.size()];
        double maxValue = Double.MIN_VALUE;
        int i = 0;
        int j = 0;
        for (Domain entity1 : entities1) {
            j = 0;
            for (Domain entity2 : entities2) {
                valueMatrix[i][j] = this.basicExpression.evaluate(entity1, entity2);
                if (valueMatrix[i][j] > maxValue) {
                    maxValue = valueMatrix[i][j];
                }
                ++j;
            }
            ++i;
        }
        double[][] costMatrix = new double[entities1.size()][entities2.size()];
        i = 0;
        while (i < entities1.size()) {
            j = 0;
            while (j < entities2.size()) {
                costMatrix[i][j] = maxValue - valueMatrix[i][j];
                ++j;
            }
            ++i;
        }
        byte[][] solution = new BestAssignmentSolver(costMatrix).munkres();
        double addedValues = 0.0;
        i = 0;
        while (i < entities1.size()) {
            j = 0;
            while (j < entities2.size()) {
                if (solution[i][j] != 0) {
                    addedValues += valueMatrix[i][j];
                    break;
                }
                ++j;
            }
            ++i;
        }
        return addedValues / (double)entities1.size();
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element bpgElem = targetDoc.createElement("bpg");
        parentElem.appendChild(bpgElem);
        this.basicExpression.decompile(targetDoc, bpgElem);
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        Vector result = new Vector();
        result.add(this.basicExpression);
        return result;
    }
}

