/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression.svm;

import de.dfki.s2m2de.expression.svm.AbstractModelSearchDimension;
import de.dfki.s2m2de.expression.svm.SVMParameters;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ModelSearchSpace {
    protected Logger logger = Logger.getLogger(this.getClass());
    protected SVMParameters basicParameters;
    protected Vector<AbstractModelSearchDimension> dimensions = new Vector();
    protected boolean hasMoreModels = true;

    public ModelSearchSpace(SVMParameters basicParameters) {
        this.basicParameters = basicParameters;
    }

    public void addDimension(AbstractModelSearchDimension dimension) {
        this.dimensions.add(dimension);
    }

    public SVMParameters getNextModel() {
        try {
            SVMParameters newParameters = (SVMParameters)this.basicParameters.getClass().newInstance();
            newParameters.putAll(this.basicParameters);
            for (AbstractModelSearchDimension dimension : this.dimensions) {
                newParameters.put(dimension.getVariable(), dimension.getCurrentValue());
            }
            this.hasMoreModels = false;
            for (int dim = 0; dim < this.dimensions.size(); ++dim) {
                AbstractModelSearchDimension currentDimension = this.dimensions.get(dim);
                currentDimension.increment();
                if (currentDimension.exceedsUpperBound()) {
                    currentDimension.resetCurrentValue();
                    continue;
                }
                this.hasMoreModels = true;
                break;
            }
            return newParameters;
        }
        catch (InstantiationException e) {
            this.logger.warn((Object)"Unable to get next model in search space.", (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            this.logger.warn((Object)"Unable to get next model in search space.", (Throwable)e);
            return null;
        }
    }

    public boolean hasMoreModels() {
        return this.hasMoreModels;
    }
}

