/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression.svm;

import de.dfki.s2m2de.expression.AbstractExpression;
import de.dfki.s2m2de.expression.Expression;
import de.dfki.s2m2de.expression.ExpressionEvaluationException;
import de.dfki.s2m2de.expression.svm.ExpIncreasingDimension;
import de.dfki.s2m2de.expression.svm.ModelSearchSpace;
import de.dfki.s2m2de.expression.svm.SVM;
import de.dfki.s2m2de.expression.svm.SVMException;
import de.dfki.s2m2de.expression.svm.SVMParameters;
import de.dfki.s2m2de.expression.svm.Sample;
import de.dfki.s2m2de.expression.svm.TrainingSet;
import de.dfki.s2m2de.expression.svm.libsvm.LibSVM;
import de.dfki.s2m2de.expression.svm.libsvm.LibSVMParameters;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVMAggregation<Domain>
extends AbstractExpression<Domain, Double> {
    protected Vector<Expression<Domain, Double>> featureSpace;
    protected SVM<Domain> svm;
    protected SVMParameters svmParameters;
    protected boolean trained;

    public SVMAggregation(Vector<Expression<Domain, Double>> featureSpace) {
        this.svm = new LibSVM();
        this.featureSpace = featureSpace;
        this.trained = false;
        this.svmParameters = LibSVMParameters.createDefault();
    }

    public SVMAggregation(Vector<Expression<Domain, Double>> featureSpace, File modelFile) throws IOException {
        this.svm = new LibSVM();
        this.svm.loadTrainedModel(modelFile);
        this.svmParameters = this.svm.getTrainingParameters();
        this.trained = true;
        this.featureSpace = featureSpace;
    }

    public SVMAggregation(Class<? extends SVM<Domain>> svmImplementation, SVMParameters svmParameters, Vector<Expression<Domain, Double>> featureSpace) throws SVMException {
        try {
            this.svm = svmImplementation.newInstance();
            this.svmParameters = svmParameters;
        }
        catch (InstantiationException e) {
            throw new SVMException("Unable to initialize " + svmImplementation.getCanonicalName() + " as SVM.", e);
        }
        catch (IllegalAccessException e) {
            throw new SVMException("Unable to initialize " + svmImplementation.getCanonicalName() + " as SVM.", e);
        }
        this.featureSpace = featureSpace;
        this.trained = false;
    }

    public SVMAggregation(Class<? extends SVM<Domain>> svmImplementation, Vector<Expression<Domain, Double>> featureSpace, File modelFile) throws SVMException, IOException {
        try {
            this.svm = svmImplementation.newInstance();
            this.svm.loadTrainedModel(modelFile);
            this.svmParameters = this.svm.getTrainingParameters();
            this.trained = true;
        }
        catch (InstantiationException e) {
            throw new SVMException("Unable to initialize " + svmImplementation.getCanonicalName() + " as SVM.", e);
        }
        catch (IllegalAccessException e) {
            throw new SVMException("Unable to initialize " + svmImplementation.getCanonicalName() + " as SVM.", e);
        }
        catch (IOException e) {
            throw e;
        }
        this.featureSpace = featureSpace;
    }

    @Override
    public Double evaluate(Domain entity1, Domain entity2) throws ExpressionEvaluationException {
        if (!this.trained) {
            throw new ExpressionEvaluationException("SVM is not trained yet.");
        }
        Vector<Double> featureVec = new Vector<Double>();
        for (Expression<Domain, Double> featureDim : this.featureSpace) {
            featureVec.add(featureDim.evaluate(entity1, entity2));
        }
        try {
            return this.svm.getDistance(new Sample<Domain>(entity1, entity2, featureVec));
        }
        catch (SVMException e) {
            throw new ExpressionEvaluationException("Unable to aggregate features using SVM.", e);
        }
    }

    public void train(TrainingSet<Domain> trainingSet, double coarseGridStepSize, double fineGridStepSize, int folds, long seed) throws SVMException, ExpressionEvaluationException {
        HashSet<Sample<Domain>> toRemove = new HashSet<Sample<Domain>>();
        for (Sample<Domain> sample : trainingSet.getTrainingSet()) {
            try {
                Vector<Double> featureVec = new Vector<Double>();
                for (Expression<Domain, Double> featureDim : this.featureSpace) {
                    featureVec.add(featureDim.evaluate(sample.getRequestEntity(), sample.getOfferEntity()));
                }
                sample.setFeatures(featureVec);
            }
            catch (ExpressionEvaluationException e) {
                System.err.println("Evaluation error. Ignored sample during training: " + sample.requestEntity.toString() + ", " + sample.offerEntity.toString() + ", " + sample.relevant);
                toRemove.add(sample);
            }
        }
        trainingSet.getTrainingSet().removeAll(toRemove);
        ModelSearchSpace searchSpace = new ModelSearchSpace(this.svmParameters);
        double cLowerBound = Math.pow(2.0, -5.0);
        double cUpperBound = Math.pow(2.0, 15.0);
        searchSpace.addDimension(new ExpIncreasingDimension(LibSVMParameters.C, Double.toString(cLowerBound), Double.toString(cUpperBound), coarseGridStepSize));
        double gammaLowerBound = Math.pow(2.0, -15.0);
        double gammaUpperBound = Math.pow(2.0, 3.0);
        searchSpace.addDimension(new ExpIncreasingDimension(LibSVMParameters.GAMMA, Double.toString(gammaLowerBound), Double.toString(gammaUpperBound), coarseGridStepSize));
        this.svmParameters = (LibSVMParameters)this.svm.searchModel(trainingSet, searchSpace, folds, seed);
        searchSpace = new ModelSearchSpace(this.svmParameters);
        cLowerBound = Math.pow(2.0, Math.log(Double.parseDouble((String)this.svmParameters.get(LibSVMParameters.C))) / Math.log(2.0) - coarseGridStepSize + fineGridStepSize);
        cUpperBound = Math.pow(2.0, Math.log(Double.parseDouble((String)this.svmParameters.get(LibSVMParameters.C))) / Math.log(2.0) + coarseGridStepSize - fineGridStepSize);
        searchSpace.addDimension(new ExpIncreasingDimension(LibSVMParameters.C, Double.toString(cLowerBound), Double.toString(cUpperBound), fineGridStepSize));
        gammaLowerBound = Math.pow(2.0, Math.log(Double.parseDouble((String)this.svmParameters.get(LibSVMParameters.GAMMA))) / Math.log(2.0) - coarseGridStepSize + fineGridStepSize);
        gammaUpperBound = Math.pow(2.0, Math.log(Double.parseDouble((String)this.svmParameters.get(LibSVMParameters.GAMMA))) / Math.log(2.0) + coarseGridStepSize - fineGridStepSize);
        searchSpace.addDimension(new ExpIncreasingDimension(LibSVMParameters.GAMMA, Double.toString(gammaLowerBound), Double.toString(gammaUpperBound), fineGridStepSize));
        this.svmParameters = (LibSVMParameters)this.svm.searchModel(trainingSet, searchSpace, folds, seed);
        this.svm.train(trainingSet, this.svmParameters);
        this.trained = true;
    }

    public void train(TrainingSet<Domain> trainingSet, double coarseGridStepSize, double fineGridStepSize, int folds, long seed, File outputFile) throws SVMException, ExpressionEvaluationException, IOException {
        this.train(trainingSet, coarseGridStepSize, fineGridStepSize, folds, seed);
        this.svm.saveTrainedModel(outputFile);
    }

    public double getCrossValidationAccuracy() {
        if (!this.trained) {
            return Double.MIN_VALUE;
        }
        return this.svm.getTrainingParameters().getAccuracy();
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element svmElem = targetDoc.createElement("svm");
        parentElem.appendChild(svmElem);
        for (Expression<Domain, Double> exp : this.featureSpace) {
            exp.decompile(targetDoc, svmElem);
        }
    }

    @Override
    public List<Expression<?, ?>> getSubExpressions() {
        return new Vector(this.featureSpace);
    }
}

