/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression.svm;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SVMParameters
extends HashMap<Integer, String> {
    protected static final long serialVersionUID = 1L;
    protected Double accuracy = null;

    public Double getAccuracy() {
        return this.accuracy;
    }

    protected void setAccuracy(Double accuracy) {
        this.accuracy = accuracy;
    }

    public boolean areValid() {
        return false;
    }

    public void addToXMLDocument(Document document) {
        Element paramsElem = document.createElement("parameters");
        paramsElem.setAttribute("class", this.getClass().getName());
        if (this.accuracy != null) {
            paramsElem.setAttribute("accuracy", this.accuracy.toString());
        }
        for (Map.Entry entry : this.entrySet()) {
            Element paramElem = document.createElement("parameter");
            paramElem.setAttribute("id", ((Integer)entry.getKey()).toString());
            paramElem.appendChild(document.createTextNode((String)entry.getValue()));
            paramsElem.appendChild(paramElem);
        }
        document.getDocumentElement().appendChild(paramsElem);
    }

    public static SVMParameters parse(Element element) {
        Logger logger = Logger.getLogger(SVMParameters.class);
        try {
            logger.info((Object)("Parsing parameters of type " + element.getAttribute("class") + "."));
            SVMParameters parameters = (SVMParameters)Class.forName(element.getAttribute("class")).newInstance();
            if (element.hasAttribute("accuracy")) {
                parameters.setAccuracy(Double.parseDouble(element.getAttribute("accuracy")));
            }
            int i = 0;
            while (i < element.getChildNodes().getLength()) {
                Element subNode = (Element)element.getChildNodes().item(i);
                parameters.put(Integer.parseInt(subNode.getAttribute("id")), subNode.getTextContent());
                ++i;
            }
            return parameters;
        }
        catch (Exception e) {
            logger.error((Object)"Unable to parse parameters.", (Throwable)e);
            return null;
        }
    }
}

