/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression.svm;

import de.dfki.s2m2de.expression.svm.Sample;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class TrainingSet<Domain> {
    protected Set<Sample<Domain>> trainingSet;

    public TrainingSet() {
        this.trainingSet = new HashSet<Sample<Domain>>();
    }

    public TrainingSet(Set<Sample<Domain>> samples) {
        this.trainingSet = samples;
    }

    public Set<Sample<Domain>> getTrainingSet() {
        return this.trainingSet;
    }

    public void setTrainingSet(Set<Sample<Domain>> trainingSet) {
        this.trainingSet = trainingSet;
    }

    public void addTrainingSample(Sample<Domain> sample) {
        this.trainingSet.add(sample);
    }

    public void clearAllFeatures() {
        for (Sample<Domain> sample : this.trainingSet) {
            sample.clearFeatures();
        }
    }

    public int getNumberOfDimensions() {
        try {
            return this.trainingSet.iterator().next().getFeatures().size();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getSize() {
        return this.trainingSet.size();
    }

    public LinkedList<TrainingSet<Domain>> fold(int n, long seed) {
        Random rnd = new Random(seed);
        LinkedList<TrainingSet<Domain>> folds = new LinkedList<TrainingSet<Domain>>();
        int i = 0;
        while (i < n) {
            folds.add(new TrainingSet<Domain>());
            ++i;
        }
        Vector<Sample<Domain>> samples = new Vector<Sample<Domain>>(this.trainingSet);
        Iterator iter = folds.iterator();
        while (!samples.isEmpty()) {
            Sample<Domain> sample = samples.remove(rnd.nextInt(samples.size()));
            ((TrainingSet)iter.next()).addTrainingSample(sample);
            if (iter.hasNext()) continue;
            iter = folds.iterator();
        }
        return folds;
    }

    public static <Domain> TrainingSet<Domain> merge(Collection<TrainingSet<Domain>> items) {
        HashSet<Sample<Domain>> samples = new HashSet<Sample<Domain>>();
        for (TrainingSet<Domain> item : items) {
            samples.addAll(item.getTrainingSet());
        }
        return new TrainingSet<Domain>(samples);
    }

    public String toString() {
        return this.trainingSet.toString();
    }
}

