/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression.svm.libsvm;

import de.dfki.s2m2de.expression.svm.AbstractSVM;
import de.dfki.s2m2de.expression.svm.SVMException;
import de.dfki.s2m2de.expression.svm.SVMParameters;
import de.dfki.s2m2de.expression.svm.Sample;
import de.dfki.s2m2de.expression.svm.TrainingSet;
import de.dfki.s2m2de.expression.svm.libsvm.LibSVMParameters;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import libsvm.svm;
import libsvm.svm_model;
import libsvm.svm_node;
import libsvm.svm_parameter;
import libsvm.svm_problem;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LibSVM<Domain>
extends AbstractSVM<Domain> {
    public static final String MODEL_FILENAME = "svm.model";
    private Logger logger = Logger.getLogger(this.getClass());
    protected double rho;
    protected double obj;
    protected int firstLabel;
    protected LibSVMParameters parameters = null;
    protected Vector<Double> alpha = null;
    protected double sumAlpha;
    protected Vector<Vector<Double>> sv = null;

    public LibSVM() {
    }

    public LibSVM(File svmModel) throws IOException {
        this.loadTrainedModel(svmModel);
    }

    @Override
    public void train(TrainingSet<Domain> trainingSet, SVMParameters parameters) throws SVMException {
        if (!LibSVMParameters.class.isInstance(parameters)) {
            SVMException exception = new SVMException("Incompatible parameters settings for LibSVM: " + parameters.getClass().getName());
            this.logger.error((Object)"Unable to train SVM.", (Throwable)exception);
            throw exception;
        }
        if (!parameters.areValid()) {
            SVMException exception = new SVMException("Invalid parameters settings for LibSVM.");
            this.logger.error((Object)"Unable to train SVM.", (Throwable)exception);
            throw exception;
        }
        try {
            svm_problem libSVMProb = new svm_problem();
            libSVMProb.x = new svm_node[trainingSet.getSize()][trainingSet.getNumberOfDimensions()];
            libSVMProb.y = new double[trainingSet.getSize()];
            int i = 0;
            for (Sample<Domain> sample : trainingSet.getTrainingSet()) {
                Vector<Double> features = sample.getFeatures();
                int j = 0;
                while (j < features.size()) {
                    libSVMProb.x[i][j] = new svm_node();
                    libSVMProb.x[i][j].index = j + 1;
                    libSVMProb.x[i][j].value = features.elementAt(j);
                    ++j;
                }
                libSVMProb.y[i] = sample.isRelevant() ? 1.0 : -1.0;
                ++i;
            }
            libSVMProb.l = trainingSet.getSize();
            svm_parameter libSVMParam = new svm_parameter();
            if (((String)parameters.get(LibSVMParameters.TYPE)).equals("0")) {
                libSVMParam.svm_type = 0;
                libSVMParam.C = new Double((String)parameters.get(LibSVMParameters.C));
            } else if (((String)parameters.get(LibSVMParameters.TYPE)).equals("1")) {
                libSVMParam.svm_type = 1;
                libSVMParam.nu = new Double((String)parameters.get(LibSVMParameters.NU));
            }
            if (((String)parameters.get(LibSVMParameters.KERNEL)).equals("0")) {
                libSVMParam.kernel_type = 0;
            } else if (((String)parameters.get(LibSVMParameters.KERNEL)).equals("1")) {
                libSVMParam.kernel_type = 1;
                libSVMParam.gamma = new Double((String)parameters.get(LibSVMParameters.GAMMA));
                libSVMParam.coef0 = new Double((String)parameters.get(LibSVMParameters.COEF0));
                libSVMParam.degree = new Integer((String)parameters.get(LibSVMParameters.DEGREE));
            } else if (((String)parameters.get(LibSVMParameters.KERNEL)).equals("2")) {
                libSVMParam.kernel_type = 2;
                libSVMParam.gamma = new Double((String)parameters.get(LibSVMParameters.GAMMA));
            } else if (((String)parameters.get(LibSVMParameters.KERNEL)).equals("3")) {
                libSVMParam.kernel_type = 3;
                libSVMParam.gamma = new Double((String)parameters.get(LibSVMParameters.GAMMA));
                libSVMParam.coef0 = new Double((String)parameters.get(LibSVMParameters.COEF0));
            }
            libSVMParam.eps = new Double((String)parameters.get(LibSVMParameters.EPSILON));
            libSVMParam.cache_size = new Double((String)parameters.get(LibSVMParameters.CACHESIZE));
            libSVMParam.shrinking = new Boolean((String)parameters.get(LibSVMParameters.SHRINKING)) != false ? 1 : 0;
            PrintStream outStream = System.out;
            ByteArrayOutputStream svmOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(svmOutputStream);
            System.setOut(printStream);
            svm_model model = svm.svm_train((svm_problem)libSVMProb, (svm_parameter)libSVMParam);
            System.setOut(outStream);
            svmOutputStream.flush();
            this.parseResultOutput(svmOutputStream.toString());
            this.parameters = (LibSVMParameters)parameters;
            this.parseModelFile(model, trainingSet.getNumberOfDimensions());
            int[] labels = new int[2];
            svm.svm_get_labels((svm_model)model, (int[])labels);
            this.firstLabel = labels[0];
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to train SVM.", (Throwable)e);
            this.parameters = null;
            this.alpha = null;
            this.sv = null;
            throw new SVMException("Unable to train SVM.", e);
        }
    }

    @Override
    public SVMParameters getTrainingParameters() {
        return this.parameters;
    }

    protected void parseResultOutput(String str) {
        try {
            String line = str.substring(str.indexOf("obj = "));
            line = line.split("\n")[0];
            String objString = line.split(",")[0].split("obj = ")[1];
            String rhoString = line.split(",")[1].split(" rho = ")[1];
            this.obj = Double.parseDouble(objString);
            this.rho = Double.parseDouble(rhoString);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error while parsing SVM output:\n" + str), (Throwable)e);
            this.obj = 0.0;
            this.rho = 0.0;
        }
    }

    protected void parseModelFile(svm_model model, int dimensions) throws IOException {
        svm.svm_save_model((String)MODEL_FILENAME, (svm_model)model);
        BufferedReader reader = new BufferedReader(new FileReader(MODEL_FILENAME));
        reader.readLine();
        reader.readLine();
        reader.readLine();
        reader.readLine();
        reader.readLine();
        reader.readLine();
        reader.readLine();
        reader.readLine();
        reader.readLine();
        this.alpha = new Vector();
        this.sv = new Vector();
        this.sumAlpha = 0.0;
        String line = reader.readLine();
        while (line != null) {
            String[] tokens = line.split(" ");
            Double a = new Double(tokens[0]);
            Vector<Double> svVec = new Vector<Double>();
            int i = 0;
            while (i < dimensions) {
                svVec.add(0.0);
                ++i;
            }
            i = 1;
            while (i < tokens.length) {
                int pos = new Integer(tokens[i].split(":")[0]) - 1;
                double v = new Double(tokens[i].split(":")[1]);
                svVec.set(pos, v);
                ++i;
            }
            this.alpha.add(a);
            this.sumAlpha += a.doubleValue();
            this.sv.add(svVec);
            line = reader.readLine();
        }
        reader.close();
    }

    @Override
    public boolean predict(Sample<Domain> sample) throws SVMException {
        return this.getDistance(sample) > 0.0;
    }

    private static double rbfKernel(Vector<Double> xi, Vector<Double> xj, double gamma) {
        double squaredNorm = 0.0;
        int i = 0;
        while (i < xi.size()) {
            squaredNorm += (xi.get(i) - xj.get(i)) * (xi.get(i) - xj.get(i));
            ++i;
        }
        return Math.exp(-gamma * squaredNorm);
    }

    @Override
    public double getDistance(Sample<Domain> sample) throws SVMException {
        if (((String)this.parameters.get(LibSVMParameters.TYPE)).equals("0") && ((String)this.parameters.get(LibSVMParameters.KERNEL)).equals("2")) {
            double gamma = Double.parseDouble((String)this.parameters.get(LibSVMParameters.GAMMA));
            double bias = -this.rho;
            double dv = 0.0;
            Vector<Double> xs = sample.getFeatures();
            int i = 0;
            while (i < this.sv.size()) {
                Vector<Double> svVec = this.sv.get(i);
                dv += this.alpha.get(i) * LibSVM.rbfKernel(svVec, xs, gamma);
                ++i;
            }
            double magW = this.obj + this.sumAlpha < 0.0 ? Math.sqrt(2.0 * -(this.obj + this.sumAlpha)) : Math.sqrt(2.0 * (this.obj + this.sumAlpha));
            return (double)this.firstLabel * ((dv += bias) / magW);
        }
        throw new SVMException("Distance computation for specified SVM type and used kernel not implemented.");
    }

    @Override
    public void saveTrainedModel(File file) throws IOException {
        try {
            Document xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element modelElem = xml.createElement("model");
            xml.appendChild(modelElem);
            this.parameters.addToXMLDocument(xml);
            Element rhoElem = xml.createElement("rho");
            rhoElem.appendChild(xml.createTextNode(Double.toString(this.rho)));
            modelElem.appendChild(rhoElem);
            Element objElem = xml.createElement("obj");
            objElem.appendChild(xml.createTextNode(Double.toString(this.obj)));
            modelElem.appendChild(objElem);
            Element labelElem = xml.createElement("firstlabel");
            labelElem.appendChild(xml.createTextNode(Integer.toString(this.firstLabel)));
            modelElem.appendChild(labelElem);
            Element svsElem = xml.createElement("svs");
            svsElem.setAttribute("dim", Integer.toString(this.sv.get(0).size()));
            modelElem.appendChild(svsElem);
            int i = 0;
            while (i < this.sv.size()) {
                Element svElem = xml.createElement("sv");
                svElem.setAttribute("alpha", Double.toString(this.alpha.get(i)));
                String svStr = "";
                int j = 0;
                while (j < this.sv.get(i).size()) {
                    svStr = String.valueOf(svStr) + Double.toString(this.sv.get(i).get(j)) + " ";
                    ++j;
                }
                svStr.trim();
                svElem.appendChild(xml.createTextNode(svStr));
                svsElem.appendChild(svElem);
                ++i;
            }
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                DOMSource source = new DOMSource(xml);
                FileOutputStream os = new FileOutputStream(file);
                StreamResult streamResult = new StreamResult(os);
                transformer.transform(source, streamResult);
            }
            catch (TransformerConfigurationException e) {
                this.logger.error((Object)("Unable to save SVM model to " + file.toString() + "."), (Throwable)e);
                throw new IOException("Unable to save SVM model to " + file.toString() + ".", e);
            }
            catch (FileNotFoundException e) {
                this.logger.error((Object)("Unable to save SVM model to " + file.toString() + "."), (Throwable)e);
                throw new IOException("Unable to save SVM model to " + file.toString() + ".", e);
            }
            catch (TransformerException e) {
                this.logger.error((Object)("Unable to save SVM model to " + file.toString() + "."), (Throwable)e);
                throw new IOException("Unable to save SVM model to " + file.toString() + ".", e);
            }
        }
        catch (ParserConfigurationException e) {
            this.logger.error((Object)("Unable to save SVM model to " + file.toString() + "."), (Throwable)e);
            throw new IOException("Unable to save SVM model to " + file.toString() + ".", e);
        }
    }

    @Override
    public void loadTrainedModel(File file) throws IOException {
        this.alpha = new Vector();
        this.sv = new Vector();
        this.parameters = null;
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            int i = 0;
            while (i < document.getDocumentElement().getChildNodes().getLength()) {
                Node subNode = document.getDocumentElement().getChildNodes().item(i);
                if (subNode.getNodeType() == 1) {
                    Element elem = (Element)subNode;
                    if (elem.getNodeName().equals("rho")) {
                        this.rho = Double.parseDouble(elem.getTextContent());
                    } else if (elem.getNodeName().equals("obj")) {
                        this.obj = Double.parseDouble(elem.getTextContent());
                    } else if (elem.getNodeName().equals("firstlabel")) {
                        this.firstLabel = Integer.parseInt(elem.getTextContent());
                    } else if (elem.getNodeName().equals("parameters")) {
                        this.parameters = (LibSVMParameters)SVMParameters.parse(elem);
                    } else if (elem.getNodeName().equals("svs")) {
                        this.sumAlpha = 0.0;
                        int j = 0;
                        while (j < elem.getChildNodes().getLength()) {
                            subNode = elem.getChildNodes().item(j);
                            if (subNode.getNodeType() == 1) {
                                Element svElem = (Element)subNode;
                                Double a = new Double(svElem.getAttribute("alpha"));
                                this.sumAlpha += a.doubleValue();
                                this.alpha.add(a);
                                String[] values = svElem.getTextContent().split(" ");
                                this.sv.add(new Vector());
                                String[] stringArray = values;
                                int n = values.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String value = stringArray[n2];
                                    this.sv.lastElement().add(new Double(value));
                                    ++n2;
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        catch (SAXException e) {
            this.logger.warn((Object)("Parsing error while processing " + file.toString() + "."), (Throwable)e);
            this.alpha = null;
            this.sv = null;
            this.parameters = null;
            throw new IOException("Parsing error while processing " + file.toString() + ".", e);
        }
        catch (IOException e) {
            this.logger.warn((Object)("File " + file.toString() + " not found. Unable to parse SVM model."), (Throwable)e);
            this.alpha = null;
            this.sv = null;
            this.parameters = null;
            throw new IOException("File " + file.toString() + " not found. Unable to parse SVM model.", e);
        }
        catch (ParserConfigurationException e) {
            this.logger.warn((Object)"Unable to create XML parser.", (Throwable)e);
            this.alpha = null;
            this.sv = null;
            this.parameters = null;
            throw new IOException("Unable to create XML parser.", e);
        }
    }
}

