/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.expression.svm.libsvm;

import de.dfki.s2m2de.expression.svm.SVMParameters;

public class LibSVMParameters
extends SVMParameters {
    public static final long serialVersionUID = 1L;
    public static final Integer TYPE = 1;
    public static final String C_SVC = "0";
    public static final String NU_SVC = "1";
    public static final Integer KERNEL = 2;
    public static final String LINEAR = "0";
    public static final String POLYNOMIAL = "1";
    public static final String RBF = "2";
    public static final String SIGMOID = "3";
    public static final Integer C = 3;
    public static final Integer NU = 4;
    public static final Integer GAMMA = 5;
    public static final Integer COEF0 = 6;
    public static final Integer DEGREE = 7;
    public static final Integer EPSILON = 8;
    public static final Integer CACHESIZE = 9;
    public static final Integer SHRINKING = 10;
    public static final String SHRINKING_ENABLED = "true";
    public static final String SHRINKING_DISABLED = "true";

    @Override
    public boolean areValid() {
        if (!(this.containsKey(TYPE) && this.containsKey(KERNEL) && this.containsKey(EPSILON) && this.containsKey(CACHESIZE) && this.containsKey(SHRINKING))) {
            return false;
        }
        if (((String)this.get(TYPE)).equals("0") && !this.containsKey(C)) {
            return false;
        }
        if (((String)this.get(TYPE)).equals("1") && !this.containsKey(NU)) {
            return false;
        }
        if (!(!((String)this.get(KERNEL)).equals("1") || this.containsKey(GAMMA) && this.containsKey(DEGREE) && this.containsKey(COEF0))) {
            return false;
        }
        if (((String)this.get(KERNEL)).equals(RBF) && !this.containsKey(GAMMA)) {
            return false;
        }
        return !((String)this.get(KERNEL)).equals(SIGMOID) || this.containsKey(GAMMA) && this.containsKey(COEF0);
    }

    public static LibSVMParameters createDefault() {
        LibSVMParameters svmParameters = new LibSVMParameters();
        svmParameters.put(TYPE, "0");
        svmParameters.put(KERNEL, RBF);
        svmParameters.put(CACHESIZE, Double.toString(1000.0));
        svmParameters.put(EPSILON, Double.toString(0.01));
        svmParameters.put(SHRINKING, "true");
        return svmParameters;
    }

    public static LibSVMParameters createDefault(double C, double gamma) {
        LibSVMParameters svmParameters = new LibSVMParameters();
        svmParameters.put(TYPE, "0");
        svmParameters.put(KERNEL, RBF);
        svmParameters.put(CACHESIZE, Double.toString(1000.0));
        svmParameters.put(EPSILON, Double.toString(0.01));
        svmParameters.put(SHRINKING, "true");
        svmParameters.put(GAMMA, Double.toString(gamma));
        svmParameters.put(LibSVMParameters.C, Double.toString(C));
        return svmParameters;
    }
}

