/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.inference.dl.pellet;

import com.clarkparsia.modularity.IncrementalClassifier;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.dl.ConceptEquivalence;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PelletConceptEquivalence
extends ConceptEquivalence {
    protected IncrementalClassifier internalReasoner;
    protected PelletReasoner pellet;
    protected OWLDataFactory factory;

    protected PelletConceptEquivalence(PelletReasoner pellet) {
        this.pellet = pellet;
        this.internalReasoner = pellet.classifier;
        this.factory = this.internalReasoner.getReasoner().getManager().getOWLDataFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean knowledgebaseEntails(List<URI> entities) throws InferenceException {
        try {
            OWLClass otherConcept;
            Iterator<URI> iterator = entities.iterator();
            OWLClass firstConcept = this.factory.getOWLClass(iterator.next());
            if (!this.internalReasoner.isDefined(firstConcept)) {
                this.pellet.processClass(firstConcept);
            }
            do {
                if (!iterator.hasNext()) {
                    return true;
                }
                otherConcept = this.factory.getOWLClass(iterator.next());
                if (this.internalReasoner.isDefined(otherConcept)) continue;
                this.pellet.processClass(otherConcept);
            } while (this.internalReasoner.isEquivalentClass((OWLDescription)firstConcept, (OWLDescription)otherConcept));
            return false;
        }
        catch (OWLReasonerException e) {
            throw new InferenceException(e);
        }
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element elem = targetDoc.createElement("equivalent");
        elem.setAttribute("reasoner", "pellet");
        parentElem.appendChild(elem);
    }
}

