/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.inference.dl.pellet;

import com.clarkparsia.modularity.IncrementalClassifier;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.dl.ConceptSubsumption;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import java.net.URI;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PelletConceptSubsumption
extends ConceptSubsumption {
    protected IncrementalClassifier internalReasoner;
    protected PelletReasoner pellet;
    protected OWLDataFactory factory;

    protected PelletConceptSubsumption(PelletReasoner pellet) {
        this.pellet = pellet;
        this.internalReasoner = pellet.classifier;
        this.factory = this.internalReasoner.getReasoner().getManager().getOWLDataFactory();
    }

    @Override
    public boolean knowledgebaseEntails(URI concept, URI subsumedConcept) throws InferenceException {
        try {
            OWLClass owlConcept = this.factory.getOWLClass(concept);
            OWLClass owlSubsumedConcept = this.factory.getOWLClass(subsumedConcept);
            if (!this.internalReasoner.isDefined(owlConcept)) {
                this.pellet.processClass(owlConcept);
            }
            if (!this.internalReasoner.isDefined(owlSubsumedConcept)) {
                this.pellet.processClass(owlSubsumedConcept);
            }
            return this.internalReasoner.isSubClassOf((OWLDescription)owlSubsumedConcept, (OWLDescription)owlConcept);
        }
        catch (OWLReasonerException e) {
            throw new InferenceException(e);
        }
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element elem = targetDoc.createElement("subsumes");
        elem.setAttribute("reasoner", "pellet");
        parentElem.appendChild(elem);
    }
}

