/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.inference.dl.pellet;

import com.clarkparsia.modularity.IncrementalClassifier;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.dl.DirectCommonSubsumers;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.inference.OWLReasonerAdapter;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PelletDirectCommonSubsumers
extends DirectCommonSubsumers {
    protected IncrementalClassifier internalReasoner;
    protected PelletReasoner pellet;
    protected OWLDataFactory factory;

    protected PelletDirectCommonSubsumers(PelletReasoner pellet) {
        this.pellet = pellet;
        this.internalReasoner = pellet.classifier;
        this.factory = this.internalReasoner.getReasoner().getManager().getOWLDataFactory();
    }

    @Override
    public Set<URI> infer(List<URI> entities) throws InferenceException {
        if (entities.isEmpty()) {
            throw new InferenceException("Computation of direct common subsumers for 0 entities not possible.");
        }
        if (entities.size() == 1) {
            return Collections.singleton(entities.get(0));
        }
        Set commonAncestors = new HashSet();
        Set otherAncestors = new HashSet();
        try {
            commonAncestors = OWLReasonerAdapter.flattenSetOfSets((Set)this.internalReasoner.getAncestorClasses((OWLDescription)this.factory.getOWLClass(entities.get(0))));
            int i = 1;
            while (i < entities.size()) {
                otherAncestors = OWLReasonerAdapter.flattenSetOfSets((Set)this.internalReasoner.getAncestorClasses((OWLDescription)this.factory.getOWLClass(entities.get(i))));
                HashSet<OWLClass> tempAncestors = new HashSet<OWLClass>();
                for (OWLClass ancestor : commonAncestors) {
                    if (!otherAncestors.contains(ancestor)) continue;
                    tempAncestors.add(ancestor);
                }
                commonAncestors = tempAncestors;
                ++i;
            }
        }
        catch (OWLReasonerException e) {
            throw new InferenceException("Unable to compute direct common subsumers.", e);
        }
        int max = 0;
        HashSet<URI> dcs = new HashSet<URI>();
        dcs.add(this.factory.getOWLThing().getURI());
        for (OWLClass ancestor : commonAncestors) {
            try {
                int depth = this.pellet.getDepth(ancestor);
                if (depth > max) {
                    max = depth;
                    dcs.clear();
                    dcs.add(ancestor.getURI());
                    continue;
                }
                if (depth != max) continue;
                dcs.add(ancestor.getURI());
            }
            catch (OWLReasonerException oWLReasonerException) {
                // empty catch block
            }
        }
        return dcs;
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element elem = targetDoc.createElement("dcs");
        elem.setAttribute("reasoner", "pellet");
        parentElem.appendChild(elem);
    }
}

