/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.inference.dl.pellet;

import com.clarkparsia.modularity.IncrementalClassifier;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.dl.LeastGenericConcept;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.inference.OWLReasonerAdapter;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PelletLeastGenericConcept
extends LeastGenericConcept {
    protected IncrementalClassifier internalReasoner;
    protected PelletReasoner pellet;
    protected OWLDataFactory factory;

    protected PelletLeastGenericConcept(PelletReasoner pellet) {
        this.pellet = pellet;
        this.internalReasoner = pellet.classifier;
        this.factory = this.internalReasoner.getReasoner().getManager().getOWLDataFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean knowledgebaseEntails(URI lgcConcept, URI concept) throws InferenceException {
        try {
            OWLClass superClass;
            OWLClass owlConcept = this.factory.getOWLClass(concept);
            OWLClass owlLgcConcept = this.factory.getOWLClass(lgcConcept);
            if (!this.internalReasoner.isDefined(owlConcept)) {
                this.pellet.processClass(owlConcept);
            }
            if (!this.internalReasoner.isDefined(owlLgcConcept)) {
                this.pellet.processClass(owlLgcConcept);
            }
            Iterator iterator = OWLReasonerAdapter.flattenSetOfSets((Set)this.internalReasoner.getSuperClasses((OWLDescription)owlConcept)).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(superClass = (OWLClass)iterator.next()).getURI().equals(lgcConcept));
            return true;
        }
        catch (OWLReasonerException e) {
            throw new InferenceException(e);
        }
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element elem = targetDoc.createElement("lgc");
        elem.setAttribute("reasoner", "pellet");
        parentElem.appendChild(elem);
    }
}

