/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.inference.dl.pellet;

import com.clarkparsia.modularity.IncrementalClassifier;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.dl.LeastSpecificConcept;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import java.net.URI;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.inference.OWLReasonerAdapter;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PelletLeastSpecificConcept
extends LeastSpecificConcept {
    protected IncrementalClassifier internalReasoner;
    protected PelletReasoner pellet;
    protected OWLDataFactory factory;

    protected PelletLeastSpecificConcept(PelletReasoner pellet) {
        this.pellet = pellet;
        this.internalReasoner = pellet.classifier;
        this.factory = this.internalReasoner.getReasoner().getManager().getOWLDataFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean knowledgebaseEntails(URI lscConcept, URI concept) throws InferenceException {
        try {
            OWLClass subClass;
            OWLClass owlConcept = this.factory.getOWLClass(concept);
            OWLClass owlLscConcept = this.factory.getOWLClass(lscConcept);
            if (!this.internalReasoner.isDefined(owlConcept)) {
                this.pellet.processClass(owlConcept);
            }
            if (!this.internalReasoner.isDefined(owlLscConcept)) {
                this.pellet.processClass(owlLscConcept);
            }
            Iterator iterator = OWLReasonerAdapter.flattenSetOfSets((Set)this.internalReasoner.getSubClasses((OWLDescription)owlConcept)).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(subClass = (OWLClass)iterator.next()).getURI().equals(lscConcept));
            return true;
        }
        catch (OWLReasonerException e) {
            throw new InferenceException(e);
        }
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element elem = targetDoc.createElement("lsc");
        elem.setAttribute("reasoner", "pellet");
        parentElem.appendChild(elem);
    }
}

