/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.inference.dl.pellet;

import com.clarkparsia.modularity.IncrementalClassifier;
import de.dfki.s2m2de.inference.dl.DLReasoner;
import de.dfki.s2m2de.inference.dl.pellet.PelletConceptEquivalence;
import de.dfki.s2m2de.inference.dl.pellet.PelletConceptSubsumption;
import de.dfki.s2m2de.inference.dl.pellet.PelletDirectCommonSubsumers;
import de.dfki.s2m2de.inference.dl.pellet.PelletInverseConceptSubsumption;
import de.dfki.s2m2de.inference.dl.pellet.PelletLeastGenericConcept;
import de.dfki.s2m2de.inference.dl.pellet.PelletLeastSpecificConcept;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.semanticweb.owl.apibinding.OWLManager;
import org.semanticweb.owl.inference.OWLReasonerAdapter;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.AddAxiom;
import org.semanticweb.owl.model.OWLAxiom;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLClassAxiom;
import org.semanticweb.owl.model.OWLDataFactory;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyAxiom;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLEntity;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualAxiom;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyAxiom;
import org.semanticweb.owl.model.OWLObjectPropertyExpression;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOntologyChange;
import org.semanticweb.owl.model.OWLOntologyChangeException;
import org.semanticweb.owl.model.OWLOntologyCreationException;
import org.semanticweb.owl.model.OWLOntologyManager;

public class PelletReasoner
extends DLReasoner {
    public static final String LOCAL_ONTOLOGY_URI = "http://www-ags.dfki.uni-sb.de/ISeM/LocalOntology";
    protected OWLOntologyManager ontologyManager;
    protected OWLDataFactory owlFactory;
    protected OWLOntology localOntology = null;
    protected IncrementalClassifier classifier;
    protected Set<URI> processedClasses = new HashSet<URI>();

    public PelletReasoner() {
        this.ontologyManager = OWLManager.createOWLOntologyManager();
        this.classifier = new IncrementalClassifier(this.ontologyManager);
        try {
            this.localOntology = this.ontologyManager.createOntology(URI.create(LOCAL_ONTOLOGY_URI));
            this.classifier.loadOntology(this.localOntology);
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
        }
        catch (OWLReasonerException oWLReasonerException) {
            // empty catch block
        }
        this.owlFactory = this.ontologyManager.getOWLDataFactory();
        this.conceptEquivalence = new PelletConceptEquivalence(this);
        this.conceptSubsumption = new PelletConceptSubsumption(this);
        this.inverseConceptSubsumption = new PelletInverseConceptSubsumption(this);
        this.leastGenericConcept = new PelletLeastGenericConcept(this);
        this.leastSpecificConcept = new PelletLeastSpecificConcept(this);
        this.directCommonSubsumers = new PelletDirectCommonSubsumers(this);
    }

    public List<OWLOntologyChange> processClass(URI classUri) {
        OWLClass owlClass = this.owlFactory.getOWLClass(classUri);
        return this.processClass(owlClass);
    }

    public List<OWLOntologyChange> processClass(OWLClass owlClass) {
        if (this.processedClasses.contains(owlClass.getURI())) {
            return Collections.emptyList();
        }
        try {
            Vector<OWLOntologyChange> changes = new Vector<OWLOntologyChange>();
            OWLOntology onto = this.ontologyManager.loadOntologyFromPhysicalURI(this.removeFragment(owlClass.getURI()));
            changes.addAll(this.ontologyManager.applyChange((OWLOntologyChange)new AddAxiom(this.localOntology, (OWLAxiom)this.owlFactory.getOWLSubClassAxiom((OWLDescription)owlClass, (OWLDescription)this.owlFactory.getOWLThing()))));
            changes.addAll(this.processClass(owlClass, onto, new HashSet<OWLEntity>()));
            this.classifier.classify();
            this.processedClasses.add(owlClass.getURI());
            return changes;
        }
        catch (OWLOntologyCreationException e) {
            return Collections.emptyList();
        }
        catch (OWLReasonerException e) {
            return Collections.emptyList();
        }
        catch (OWLOntologyChangeException e) {
            return Collections.emptyList();
        }
    }

    private List<OWLOntologyChange> processClass(OWLClass owlClass, OWLOntology ontology, Set<OWLEntity> processedItems) {
        if (processedItems.contains(owlClass)) {
            return Collections.emptyList();
        }
        try {
            Vector<OWLOntologyChange> changes = new Vector<OWLOntologyChange>();
            processedItems.add((OWLEntity)owlClass);
            Set definition = ontology.getAxioms(owlClass);
            for (OWLClassAxiom axiom : definition) {
                AddAxiom add = new AddAxiom(this.localOntology, (OWLAxiom)axiom);
                changes.addAll(this.ontologyManager.applyChange((OWLOntologyChange)add));
                Set owlClasses = axiom.getClassesInSignature();
                owlClasses.removeAll(processedItems);
                for (OWLClass otherOwlClass : owlClasses) {
                    changes.addAll(this.processClass(otherOwlClass, ontology, processedItems));
                }
                Set owlProperties = axiom.getObjectPropertiesInSignature();
                for (OWLObjectProperty owlProperty : owlProperties) {
                    changes.addAll(this.processObjectProperty(owlProperty, ontology, processedItems));
                }
                Set dataProperties = axiom.getDataPropertiesInSignature();
                for (OWLDataProperty dataProperty : dataProperties) {
                    changes.addAll(this.processDataProperty(dataProperty, ontology, processedItems));
                }
                Set owlIndividuals = axiom.getIndividualsInSignature();
                owlIndividuals.removeAll(processedItems);
                for (OWLIndividual owlIndividual : owlIndividuals) {
                    changes.addAll(this.processIndividual(owlIndividual, ontology, processedItems));
                }
            }
            return changes;
        }
        catch (OWLOntologyChangeException e) {
            return Collections.emptyList();
        }
    }

    private List<OWLOntologyChange> processObjectProperty(OWLObjectProperty owlProperty, OWLOntology ontology, Set<OWLEntity> processedItems) {
        if (processedItems.contains(owlProperty)) {
            return Collections.emptyList();
        }
        try {
            Vector<OWLOntologyChange> changes = new Vector<OWLOntologyChange>();
            processedItems.add((OWLEntity)owlProperty);
            Set definition = ontology.getAxioms((OWLObjectPropertyExpression)owlProperty);
            for (OWLObjectPropertyAxiom axiom : definition) {
                AddAxiom add = new AddAxiom(this.localOntology, (OWLAxiom)axiom);
                changes.addAll(this.ontologyManager.applyChange((OWLOntologyChange)add));
                Set owlClasses = axiom.getClassesInSignature();
                owlClasses.removeAll(processedItems);
                for (OWLClass otherOwlClass : owlClasses) {
                    changes.addAll(this.processClass(otherOwlClass, ontology, processedItems));
                }
                Set owlProperties = axiom.getObjectPropertiesInSignature();
                for (OWLObjectProperty otherOwlProperty : owlProperties) {
                    changes.addAll(this.processObjectProperty(otherOwlProperty, ontology, processedItems));
                }
                Set dataProperties = axiom.getDataPropertiesInSignature();
                for (OWLDataProperty dataProperty : dataProperties) {
                    changes.addAll(this.processDataProperty(dataProperty, ontology, processedItems));
                }
                Set owlIndividuals = axiom.getIndividualsInSignature();
                owlIndividuals.removeAll(processedItems);
                for (OWLIndividual owlIndividual : owlIndividuals) {
                    changes.addAll(this.processIndividual(owlIndividual, ontology, processedItems));
                }
            }
            return changes;
        }
        catch (OWLOntologyChangeException e) {
            return Collections.emptyList();
        }
    }

    private List<OWLOntologyChange> processDataProperty(OWLDataProperty owlProperty, OWLOntology ontology, Set<OWLEntity> processedItems) {
        if (processedItems.contains(owlProperty)) {
            return Collections.emptyList();
        }
        try {
            Vector<OWLOntologyChange> changes = new Vector<OWLOntologyChange>();
            processedItems.add((OWLEntity)owlProperty);
            Set definition = ontology.getAxioms(owlProperty);
            for (OWLDataPropertyAxiom axiom : definition) {
                AddAxiom add = new AddAxiom(this.localOntology, (OWLAxiom)axiom);
                changes.addAll(this.ontologyManager.applyChange((OWLOntologyChange)add));
                Set owlClasses = axiom.getClassesInSignature();
                owlClasses.removeAll(processedItems);
                for (OWLClass otherOwlClass : owlClasses) {
                    changes.addAll(this.processClass(otherOwlClass, ontology, processedItems));
                }
                Set owlProperties = axiom.getObjectPropertiesInSignature();
                for (OWLObjectProperty otherOwlProperty : owlProperties) {
                    changes.addAll(this.processObjectProperty(otherOwlProperty, ontology, processedItems));
                }
                Set dataProperties = axiom.getDataPropertiesInSignature();
                for (OWLDataProperty dataProperty : dataProperties) {
                    changes.addAll(this.processDataProperty(dataProperty, ontology, processedItems));
                }
                Set owlIndividuals = axiom.getIndividualsInSignature();
                owlIndividuals.removeAll(processedItems);
                for (OWLIndividual owlIndividual : owlIndividuals) {
                    changes.addAll(this.processIndividual(owlIndividual, ontology, processedItems));
                }
            }
            return changes;
        }
        catch (OWLOntologyChangeException e) {
            return Collections.emptyList();
        }
    }

    private List<OWLOntologyChange> processIndividual(OWLIndividual owlIndividual, OWLOntology ontology, Set<OWLEntity> processedItems) {
        if (processedItems.contains(owlIndividual)) {
            return Collections.emptyList();
        }
        try {
            Vector<OWLOntologyChange> changes = new Vector<OWLOntologyChange>();
            processedItems.add((OWLEntity)owlIndividual);
            Set definition = ontology.getAxioms(owlIndividual);
            for (OWLIndividualAxiom axiom : definition) {
                AddAxiom add = new AddAxiom(this.localOntology, (OWLAxiom)axiom);
                changes.addAll(this.ontologyManager.applyChange((OWLOntologyChange)add));
                Set owlClasses = axiom.getClassesInSignature();
                owlClasses.removeAll(processedItems);
                for (OWLClass otherOwlClass : owlClasses) {
                    changes.addAll(this.processClass(otherOwlClass, ontology, processedItems));
                }
                Set owlProperties = axiom.getObjectPropertiesInSignature();
                for (OWLObjectProperty owlProperty : owlProperties) {
                    changes.addAll(this.processObjectProperty(owlProperty, ontology, processedItems));
                }
                Set dataProperties = axiom.getDataPropertiesInSignature();
                for (OWLDataProperty dataProperty : dataProperties) {
                    changes.addAll(this.processDataProperty(dataProperty, ontology, processedItems));
                }
                Set owlIndividuals = axiom.getIndividualsInSignature();
                owlIndividuals.removeAll(processedItems);
                for (OWLIndividual otherOwlIndividual : owlIndividuals) {
                    changes.addAll(this.processIndividual(otherOwlIndividual, ontology, processedItems));
                }
            }
            return changes;
        }
        catch (OWLOntologyChangeException e) {
            return Collections.emptyList();
        }
    }

    protected final URI removeFragment(URI uri) {
        String uriString = uri.toString();
        uriString = uriString.substring(0, uriString.indexOf(35));
        return URI.create(uriString);
    }

    protected int getDepth(OWLClass owlClass) throws OWLReasonerException {
        if (owlClass.equals(this.owlFactory.getOWLThing())) {
            return 0;
        }
        Set parents = OWLReasonerAdapter.flattenSetOfSets((Set)this.classifier.getSuperClasses((OWLDescription)owlClass));
        if (parents.isEmpty()) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        for (OWLClass parent : parents) {
            int depth = 0;
            if (!parent.equals(this.owlFactory.getOWLThing())) {
                depth = this.getDepth(parent);
            }
            min = Math.min(min, depth);
        }
        return min + 1;
    }

    protected int getDepth(URI conceptUri) throws OWLReasonerException {
        return this.getDepth(this.owlFactory.getOWLClass(conceptUri));
    }

    protected int getDistanceToAncestor(OWLClass concept, OWLClass ancestor) throws OWLReasonerException {
        if (concept.equals(ancestor)) {
            return 0;
        }
        if (this.classifier.getEquivalentClasses((OWLDescription)concept).contains(ancestor)) {
            return 0;
        }
        LinkedList list = new LinkedList(OWLReasonerAdapter.flattenSetOfSets((Set)this.classifier.getSuperClasses((OWLDescription)concept)));
        LinkedList<Integer> distances = new LinkedList<Integer>();
        int i = 0;
        while (i < list.size()) {
            distances.add(1);
            ++i;
        }
        while (!list.isEmpty()) {
            OWLClass current = (OWLClass)list.pollFirst();
            int distance = (Integer)distances.pollFirst();
            if (current.equals(ancestor)) {
                return distance;
            }
            list.addAll(OWLReasonerAdapter.flattenSetOfSets((Set)this.classifier.getSuperClasses((OWLDescription)current)));
            int i2 = distances.size();
            while (i2 < list.size()) {
                distances.add(distance + 1);
                ++i2;
            }
        }
        return Integer.MAX_VALUE;
    }

    protected int getDistanceToAncestor(URI concept, URI ancestor) throws OWLReasonerException {
        return this.getDistanceToAncestor(this.owlFactory.getOWLClass(concept), this.owlFactory.getOWLClass(ancestor));
    }

    public static void main(String[] args) {
    }
}

