/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.inference.dl.pellet;

import com.clarkparsia.modularity.IncrementalClassifier;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.NonStandardInferenceCapability;
import de.dfki.s2m2de.inference.dl.NotSupportedException;
import de.dfki.s2m2de.inference.dl.pellet.PelletReasoner;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.inference.OWLReasonerException;
import org.semanticweb.owl.model.OWLDataFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StructuralConceptSimilarity
extends NonStandardInferenceCapability<URI, Double> {
    protected IncrementalClassifier internalReasoner;
    protected PelletReasoner pellet;
    protected OWLDataFactory factory;
    private double alpha = 0.2;
    private double beta = 0.6;

    public StructuralConceptSimilarity(PelletReasoner pellet) {
        this.pellet = pellet;
        this.internalReasoner = pellet.classifier;
        this.factory = this.internalReasoner.getReasoner().getManager().getOWLDataFactory();
    }

    public StructuralConceptSimilarity(PelletReasoner pellet, double alpha, double beta) {
        this.pellet = pellet;
        this.internalReasoner = pellet.classifier;
        this.factory = this.internalReasoner.getReasoner().getManager().getOWLDataFactory();
        this.alpha = alpha;
        this.beta = beta;
    }

    @Override
    public Double infer(List<URI> entities) throws InferenceException {
        if (entities.size() != 2) {
            throw new InferenceException("Invalid number of arguments (" + entities.size() + ") for structural similarity computation capability.");
        }
        return this.infer(entities.get(0), entities.get(1));
    }

    public Double infer(URI concept1, URI concept2) throws InferenceException {
        try {
            Set<URI> dcs = this.pellet.getDirectCommonSubsumers().infer(concept1, concept2);
            URI minDcs = null;
            int h = Integer.MAX_VALUE;
            for (URI oneDcs : dcs) {
                int depth = this.pellet.getDepth(oneDcs);
                if (depth >= h) continue;
                minDcs = oneDcs;
                h = depth;
            }
            int l = this.pellet.getDistanceToAncestor(concept1, minDcs) + this.pellet.getDistanceToAncestor(concept2, minDcs);
            double betah = this.beta * (double)h;
            double expbetah = Math.exp(betah);
            double expminusbetah = 1.0 / expbetah;
            double result = Math.exp(-this.alpha * (double)l) * ((expbetah - expminusbetah) / (expbetah + expminusbetah));
            return result;
        }
        catch (OWLReasonerException e) {
            throw new InferenceException("Unable to compute structural similarity.", e);
        }
        catch (NotSupportedException e) {
            throw new InferenceException("Unable to compute structural similarity.", e);
        }
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element elem = targetDoc.createElement("structsim");
        elem.setAttribute("reasoner", "pellet");
        elem.setAttribute("alpha", "" + this.alpha);
        elem.setAttribute("beta", "" + this.beta);
        parentElem.appendChild(elem);
    }
}

