/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.inference.tp.thetasubsumption;

import alice.tuprolog.MalformedGoalException;
import alice.tuprolog.Prolog;
import alice.tuprolog.SolveInfo;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.tp.Implication;
import de.dfki.s2m2de.service.pddl.Atom;
import de.dfki.s2m2de.service.pddl.Conjunction;
import de.dfki.s2m2de.service.pddl.Negation;
import de.dfki.s2m2de.service.pddl.PDDLExpression;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ThetaSubsumption
extends Implication<PDDLExpression> {
    protected Prolog prologEngine;

    protected ThetaSubsumption(Prolog prologEngine) {
        this.prologEngine = prologEngine;
    }

    @Override
    public boolean knowledgebaseEntails(PDDLExpression antecedent, PDDLExpression consequent) throws InferenceException {
        String prologAntecedent = "[" + this.pddlExpression2prologString(antecedent) + "]";
        String prologConsequent = "[" + this.pddlExpression2prologString(consequent) + "]";
        try {
            String prologProblem = String.format("plain_subsume(%s, %s).", prologConsequent, prologAntecedent);
            SolveInfo answer = this.prologEngine.solve(prologProblem);
            return answer.isSuccess();
        }
        catch (MalformedGoalException e) {
            throw new InferenceException("Unable to check theta subsumption for: \"" + prologConsequent + " <= " + prologAntecedent + "\".", e);
        }
    }

    @Override
    public boolean knowledgebaseEntails(String antecedent, String consequent) throws InferenceException {
        String prologAntecedent = "[" + antecedent + "]";
        String prologConsequent = "[" + consequent + "]";
        try {
            String prologProblem = String.format("plain_subsume(%s, %s).", prologConsequent, prologAntecedent);
            SolveInfo answer = this.prologEngine.solve(prologProblem);
            return answer.isSuccess();
        }
        catch (MalformedGoalException e) {
            throw new InferenceException("Unable to check theta subsumption for: \"" + prologConsequent + " <= " + prologAntecedent + "\".", e);
        }
    }

    protected String pddlExpression2prologString(Atom atom) {
        Iterator<String> iter = atom.getParameters().iterator();
        String predicate = atom.getPredicate();
        predicate = predicate.substring(predicate.lastIndexOf(35) + 1);
        predicate = predicate.toLowerCase();
        String variable = iter.next();
        variable = variable.substring(variable.lastIndexOf(35) + 1);
        variable = variable.substring(variable.indexOf(95) + 1);
        variable = variable.toUpperCase();
        String str = String.valueOf(predicate) + "(" + variable;
        while (iter.hasNext()) {
            variable = iter.next();
            variable = variable.substring(variable.lastIndexOf(35) + 1);
            variable = variable.substring(variable.indexOf(95) + 1);
            variable = variable.toUpperCase();
            str = String.valueOf(str) + "," + variable;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    protected String pddlExpression2prologString(Conjunction conj) throws InferenceException {
        Iterator<PDDLExpression> iter = conj.getBasicExpressions().iterator();
        String str = this.pddlExpression2prologString(iter.next());
        while (iter.hasNext()) {
            str = String.valueOf(str) + "," + this.pddlExpression2prologString(iter.next());
        }
        return str;
    }

    protected String pddlExpression2prologString(Negation neg) throws InferenceException {
        return "not " + this.pddlExpression2prologString(neg.getBasicExpression());
    }

    protected String pddlExpression2prologString(PDDLExpression expr) throws InferenceException {
        if (expr instanceof Atom) {
            return this.pddlExpression2prologString((Atom)expr);
        }
        if (expr instanceof Conjunction) {
            return this.pddlExpression2prologString((Conjunction)expr);
        }
        if (expr instanceof Negation) {
            return this.pddlExpression2prologString((Negation)expr);
        }
        throw new InferenceException("Unsupported PDDL expression: " + expr.toString());
    }

    @Override
    public void decompile(Document targetDoc, Element parentElem) {
        Element elem = targetDoc.createElement("implies");
        parentElem.appendChild(elem);
        elem.setAttribute("prover", "thetasubsumption");
    }
}

