/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.s2m2de.inference.tp.thetasubsumption;

import alice.tuprolog.InvalidTheoryException;
import alice.tuprolog.Prolog;
import alice.tuprolog.Theory;
import de.dfki.s2m2de.inference.InferenceException;
import de.dfki.s2m2de.inference.tp.TheoremProver;
import de.dfki.s2m2de.inference.tp.thetasubsumption.ThetaSubsumption;
import de.dfki.s2m2de.service.pddl.PDDLExpression;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ThetaSubsumptionChecker
extends TheoremProver<PDDLExpression> {
    public static final String PROLOG_THEORY_LOCATION = "Prolog/plain_subsume.pl";
    protected Prolog prologEngine;

    public ThetaSubsumptionChecker() throws InferenceException {
        try {
            this.prologEngine = new Prolog();
            this.prologEngine.setTheory(new Theory((InputStream)new FileInputStream(PROLOG_THEORY_LOCATION)));
            this.implication = new ThetaSubsumption(this.prologEngine);
        }
        catch (InvalidTheoryException e) {
            throw new InferenceException("Unable to create theory.", e);
        }
        catch (FileNotFoundException e) {
            throw new InferenceException("Unable to create theory.", e);
        }
        catch (IOException e) {
            throw new InferenceException("Unable to create theory.", e);
        }
    }

    public static void main(String[] args) {
        try {
            String antecedent = "accepted(CREDITCARDACCOUNT),authorized(PERSON),accountHolder(PERSON,CREDITCARDACCOUNT)";
            String consequent = "accepted(CustomerCreditCardNumber),accountHolder(CustomerName,CustomerCreditCardNumber)";
            ThetaSubsumptionChecker checker = new ThetaSubsumptionChecker();
            boolean implies = ((ThetaSubsumption)checker.getImplication()).knowledgebaseEntails(antecedent, consequent);
            System.out.println("implies = " + implies);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

